<?php

$arrConfig = array(
    'service_manager' => array(
        'aliases' => array(
            'translator' => 'MvcTranslator',
        )
    ),
    'translator' => array(
        'locale' => LANG,
        'translation_file_patterns' => array(
            array(
                'type'     => 'phpArray',
                'base_dir' => ROOT_PUBLIC.'/Frontend/language',
                'pattern'  => '%s.php',
            ),
        ),
    ),
    'controllers' => array(
        'invokables' => array(
            'Frontend\Controller\Ajax'          => 'Frontend\Controller\AjaxController',
            'Frontend\Controller\Contact'       => 'Frontend\Controller\ContactController',
            'Frontend\Controller\Cron'          => 'Frontend\Controller\CronController',
            'Frontend\Controller\Html'          => 'Frontend\Controller\HtmlController',
            'Frontend\Controller\Index'         => 'Frontend\Controller\IndexController',
            'Frontend\Controller\Member'        => 'Frontend\Controller\MemberController',
            'Frontend\Controller\News'          => 'Frontend\Controller\NewsController',
            'Frontend\Controller\Order'         => 'Frontend\Controller\OrderController',
            'Frontend\Controller\Product'       => 'Frontend\Controller\ProductController',
            'Frontend\Controller\Search'        => 'Frontend\Controller\SearchController',
            'Frontend\Controller\CronJob'        => 'Frontend\Controller\CronJobController',
        ),
    ),
    'view_manager' => array(
        'display_not_found_reason'    => true,
        'display_exceptions'          => true,
        'doctype'                     => 'HTML5',
        'not_found_template'          => 'error/404',
        'exception_template'          => 'error/index',
        'template_map' => array(
            include(__DIR__ . '/../template_map.php')
            // 'layout/layout'           => __DIR__ . '/../view/layout/layout.phtml',
            // 'error/404'               => __DIR__ . '/../view/error/404.phtml',
            // 'error/index'             => __DIR__ . '/../view/error/index.phtml',
            // 'block/pagination'        => __DIR__ . '/../view/block/pagination.phtml',
        ),
        'template_path_stack' => array(__DIR__ . '/../view')
    ),
    'view_helpers' => array(
        'invokables' => array(
            'block1'                => 'Frontend\Block\Block1',
            'block2'                => 'Frontend\Block\Block2',
            'block3'                => 'Frontend\Block\Block3',
            'block4'                => 'Frontend\Block\Block4',
            'block5'                => 'Frontend\Block\Block5',
            'header'                => 'Frontend\Block\Header',
            'footer'                => 'Frontend\Block\Footer',
            'sidebarTeacher'        => 'Frontend\Block\SidebarTeacher',
            'sidebarMaster'         => 'Frontend\Block\SidebarMaster',
            'sidebarConsultant'     => 'Frontend\Block\SidebarConsultant',
            'sidebarAccountant'     => 'Frontend\Block\SidebarAccountant',
            'sidebar'               => 'Frontend\Block\Sidebar',
            'head'                  => 'Frontend\Block\Head',
            'breadcrumb'            => 'Frontend\Block\Breadcrumb',
            'toSlug'                => 'Frontend\View\Helper\ToSlug',
            'cutString'             => 'Frontend\View\Helper\CutString',
            'getYT'                 => 'Frontend\View\Helper\YoutubeID',
            'sortByColumn'          => 'Frontend\View\Helper\SortByColumn',
            'sortNestedCate'        => 'Frontend\View\Helper\SortNestedCate',
            'counter'               => 'Frontend\View\Helper\Counter\Counter',
            'convertWebpEditor'     => 'Frontend\View\Helper\ConvertWebpEditor',
            'timeElapsedString'     => 'Frontend\View\Helper\TimeElapsedString',
            'cleanLink'             => 'Frontend\View\Helper\CleanLink',
            'getDayOfWeek'          => 'Frontend\View\Helper\getDayOfWeek',
            'generateSchedule'      => 'Frontend\View\Helper\generateSchedule',
            'paginationMonth'       => 'Frontend\View\Helper\paginationMonth',
        ),
    ),
    'router' => array(
        'routes' => array(
            'frontend' => array(
                'type'    => 'Literal',
                'options' => array(
                    'route'    => '/frontend',
                    'defaults' => array(
                        '__NAMESPACE__' => 'Frontend\Controller',
                        'controller'    => 'Index',
                        'action'        => 'index',
                    ),
                ),
                'may_terminate' => true,
                'child_routes' => array(
                    'default' => array(
                        'type'    => 'Segment',
                        'options' => array(
                            'route' => '/[/:module][:controller][/:action][/id=:id]',
                            'constraints' => array(
                                '__NAMESPACE__' => 'Frontend\Controller',
                                'controller'  => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'action'      => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'id'          => '[0-9,]+'
                            ),
                            'defaults' => array(),
                        ),
                    ),
                ),
            ),
        ),
    )
);
$list_lang = array(''); // '/vi','/en','/de','/fr','/ja','/ru','/zh'
// Tạo link list module
$arModule = array(
    'no_action_number' => array('Cron' => array('sitemap')),
    'no_id' => array(
        'Ajax' => array(
            'ajax81' => 81,
            'ajax82' => 82,
            'ajax83' => 83,
            'ajax84' => 84,
            'ajax85' => 85,
            'ajax86' => 86,
            'ajax87' => 87,
            'ajax88' => 88,
            'ajax89' => 89,
            'ajax90' => 90,
            'ajax91' => 91,
            'ajax92' => 92,
            'ajax93' => 93,
            'ajax94' => 94,
            'ajax95' => 95,
            'ajax96' => 96,
            'ajax97' => 97,
        ),
        'Member' => array(
            'download' => 70,
            'profile' => 71,
            'signUp' => 72,
            'signIn' => 73,
            'signOut' => 74,
            'password' => 75,
            'teacher' => 76,
            'master' => 77,
            'consultant' => 78,
            'accountant' => 79,
            'check' => 80
        ),
        // 'Order' => array('cart' => 61, 'booking' => 62), // 'list' => 63, 'detail' => 64, 'discount' => 65
        // 'Search' => array('search:ispaging' => 99),
        // 'Contact' => array('index' => 51, 'register' => 52) // 'register' => 52, 'subscriber' => 53, 'comment' => 54
    ),
    'id' => array(
        // 'Product' => array(
        //     'list' => array(11),
        //     'detail' => array(15)
        // ),
        // 'News' => array(
        //     'list' => array(21),
        //     'detail' => array(25)
        // ),
        // 'Html' => array(
        //     'list' => array(),
        //     'page' => array(31)
        // )
    ),
    'filter' => array(
        // 'pbrand' => array(
        //     'name' => array('br','brand_id'),
        //     'module' => array(
        //         'Product' => array(11)
        //     )
        // ),
        // 'plabel' => array(
        //     'name' => array('lb','label_id'),
        //     'module' => array(
        //         'Product' => array(11)
        //     )
        // ),
        // 'menu' => array(
        //     'name' => array('mn','menu_id'),
        //     'module' => array(
        //         'Product' => array(11)
        //     )
        // ),
        // 'tag' => array(
        //     'name' => array('tg','tag_id'),
        //     'module' => array(
        //         'Product' => array(11),
        //         'News' => array(21)
        //     )
        // )
    )
);
foreach ($list_lang as $vl_lang) {
    foreach ($arModule['no_action_number'] as $module => $arrAction) {
        foreach ($arrAction as $action_name) {
            $arrConfig['router']['routes'][] = array(
                'type' => 'Literal',
                'options' => array (
                    'route' => '/'.$action_name.'.html',
                    'defaults' => array (
                        '__NAMESPACE__' => 'Frontend\Controller',
                        'controller' => 'Frontend\Controller\\'.$module,
                        'action' => $action_name,
                    ),
                )
            );
        }
    }
    foreach ($arModule['no_id'] as $module => $arrAction) {
        foreach ($arrAction as $action_name => $action_number) {
            $arr = explode(':', $action_name);
            $action_name = $arr[0];
            $arrConfig['router']['routes'][] = array(
                'type' => 'regex',
                'options' => array (
                    'regex' => $vl_lang.'/(?<slug>[a-zA-Z0-9-]+)-(?<format>('.$action_number.'.html))?',
                    'defaults' => array (
                        '__NAMESPACE__' => 'Frontend\Controller',
                        'controller' => 'Frontend\Controller\\'.$module,
                        'action' => $action_name,
                    ),
                    'spec' => '%slug%-%format%'
                )
            );
            if (isset($arr[1]) && $arr[1]){
                $arrConfig['router']['routes'][] = array(
                    'type' => 'regex',
                    'options' => array (
                        'regex' => $vl_lang.'/(?<slug>[a-zA-Z0-9-]+)(-pg(?<page>[0-9]+))-(?<format>('.$action_number.'.html))?',
                        'defaults' => array (
                            '__NAMESPACE__' => 'Frontend\Controller',
                            'controller' => 'Frontend\Controller\\'.$module,
                            'action' => $action_name,
                        ),
                        'spec' => '%slug%-pg%page%-%format%'
                    )
                );
            }
        }
    }
    foreach ($arModule['id'] as $module => $arrAction) {
        foreach ($arrAction as $action_name => $arrAction_number) {
            foreach ($arrAction_number as $action_number) {
                $arrConfig['router']['routes'][] = array(
                    'type' => 'regex',
                    'options' => array (
                        'regex' => $vl_lang.'/(?<slug>[a-zA-Z0-9-]+)-(?<id>[0-9-]+)-(?<format>('.$action_number.'.html))?',
                        'defaults' => array (
                            '__NAMESPACE__' => 'Frontend\Controller',
                            'controller' => 'Frontend\Controller\\'.$module,
                            'action' => $action_name.$action_number,
                        ),
                        'spec' => '(?<slug>[a-zA-Z0-9-]+)-%id%-%format%'
                    )
                );
                if ($action_name == 'list') {
                    $arrConfig['router']['routes'][] = array(
                        'type' => 'regex',
                        'options' => array (
                            'regex' => $vl_lang.'/(?<slug>[a-zA-Z0-9-]+)(-pg(?<page>[0-9]+))-(?<id>[0-9-]+)-(?<format>('.$action_number.'.html))?',
                            'defaults' => array (
                                '__NAMESPACE__' => 'Frontend\Controller',
                                'controller' => 'Frontend\Controller\\'.$module,
                                'action' => 'list'.$action_number,
                            ),
                            'spec' => '%slug%-pg%page%-%id%-%format%'
                        )
                    );
                }
            }
        }
    }
    foreach ($arModule['filter'] as $arrs) {
        foreach ($arrs['module'] as $module => $arrAction_number) {
            foreach ($arrAction_number as $action_number) {
                $arrConfig['router']['routes'][] = array(
                    'type' => 'regex',
                    'options' => array (
                        'regex' => $vl_lang.'/(?<slug>[a-zA-Z0-9-]+)-(?<shortcut>('.$arrs["name"][0].'))(?<'.$arrs["name"][1].'>[0-9-]+)-(?<format>('.$action_number.'.html))?',
                        'defaults' => array (
                            '__NAMESPACE__' => 'Frontend\Controller',
                            'controller' => 'Frontend\Controller\\'.$module,
                            'action' => 'list'.$action_number,
                        ),
                        'spec' => '%slug%-'.$arrs["name"][0].'%'.$arrs["name"][1].'%-%format%'
                    )
                );
                // theo danh muc
                $arrConfig['router']['routes'][] = array(
                    'type' => 'regex',
                    'options' => array (
                        'regex' => $vl_lang.'/(?<slug>[a-zA-Z0-9-]+)-(?<shortcut>('.$arrs["name"][0].'))(?<'.$arrs["name"][1].'>[0-9-]+)-(?<id>[0-9-]+)-(?<format>('.$action_number.'.html))?',
                        'defaults' => array (
                            '__NAMESPACE__' => 'Frontend\Controller',
                            'controller' => 'Frontend\Controller\\'.$module,
                            'action' => 'list'.$action_number,
                        ),
                        'spec' => '%slug%-'.$arrs["name"][0].'%'.$arrs["name"][1].'%-%id%-%format%'
                    )
                );
                // phan trang
                $arrConfig['router']['routes'][] = array(
                    'type' => 'regex',
                    'options' => array (
                        'regex' => $vl_lang.'/(?<slug>[a-zA-Z0-9-]+)(-pg(?<page>[0-9]+))-(?<shortcut>('.$arrs["name"][0].'))(?<'.$arrs["name"][1].'>[0-9-]+)-(?<format>('.$action_number.'.html))?',
                        'defaults' => array (
                            '__NAMESPACE__' => 'Frontend\Controller',
                            'controller' => 'Frontend\Controller\\'.$module,
                            'action' => 'list'.$action_number,
                        ),
                        'spec' => '%slug%-pg%page%-'.$arrs["name"][0].'%'.$arrs["name"][1].'%-%format%'
                    )
                );
                // phan trang || theo danh muc
                $arrConfig['router']['routes'][] = array(
                    'type' => 'regex',
                    'options' => array (
                        'regex' => $vl_lang.'/(?<slug>[a-zA-Z0-9-]+)(-pg(?<page>[0-9]+))-(?<shortcut>('.$arrs["name"][0].'))(?<'.$arrs["name"][1].'>[0-9-]+)-(?<id>[0-9-]+)-(?<format>('.$action_number.'.html))?',
                        'defaults' => array (
                            '__NAMESPACE__' => 'Frontend\Controller',
                            'controller' => 'Frontend\Controller\\'.$module,
                            'action' => 'list'.$action_number,
                        ),
                        'spec' => '%slug%-pg%page%-'.$arrs["name"][0].'%'.$arrs["name"][1].'%-%id%-%format%'
                    )
                );
            }
        }
    }
}
// Tạo link trang chủ
foreach (array_filter($list_lang) as $vl_lang) {
    $arrConfig['router']['routes'][] = array(
        'type'    => 'Zend\Mvc\Router\Http\Literal',
        'options' => array(
            'route' => $vl_lang,
            'defaults' => array(
                '__NAMESPACE__' => 'Frontend\Controller',
                'controller'    => 'Frontend\Controller\Index',
                'action'        => 'index',
            ),
        ),
    );
    $arrConfig['router']['routes'][] = array(
        'type' => 'Zend\Mvc\Router\Http\Literal',
        'options' => array(
            'route'    => $vl_lang.'/',
            'defaults' => array(
                '__NAMESPACE__' => 'Frontend\Controller',
                'controller'    => 'Frontend\Controller\Index',
                'action'        => 'index',
            ),
        ),
    );
}
$arrConfig['router']['routes'][] = array(
    'type' => 'Zend\Mvc\Router\Http\Literal',
    'options' => array(
        'route'    => '/',
        'defaults' => array(
            '__NAMESPACE__' => 'Frontend\Controller',
            'controller'    => 'Frontend\Controller\Index',
            'action'        => 'index',
        ),
    ),
);
$arrConfig['router']['routes'][] = array(
    'type' => 'Zend\Mvc\Router\Http\Literal',
    'options' => array(
        'route'    => '/cronjob',
        'defaults' => array(
            '__NAMESPACE__' => 'Frontend\Controller',
            'controller'    => 'Frontend\Controller\CronJob',
        ),
    ),
);
return $arrConfig;

?>