<?php

namespace Frontend\Block;
use Zend\View\Helper\AbstractHelper;

class Head extends AbstractHelper
{
    public function __invoke($action, $position)
    {
        $data = array('data' => array('action' => $action, 'position' => $position));
        /**
         * Vị trí hiển thị css, js
         *     top: hiển thị ở thẻ <head>
         *     bot: hiển thị trước thẻ đóng </body>
         * File yêu cầu đặt trong thư mục "template/frontend/"
         * Cú pháp tạo mảng:
         *         '<Vị trí hiển thị>' => array(
         *           '<action>' => array(
         *               'css' => array(<file css>), // chú ý vị trí trước sau các file
         *               'js' => array(<file js>) // chú ý vị trí trước sau các file
         *             ),
         *         )
         */
        $data['head'] = array(
            'top' => array(
                'global' => array(
                    'css' => array('global.css'),
                    'js' => array('global.js')
                ),
                // Page theo yêu cầu
                'home' => array(
                    'css' => array('page_login.css'),
                    'js' => array('page_login.js')
                ),
                'profile' => array(
                    'css' => array('v_datepicker.css','page_profile.css'),
                    'js' => array('v_datepicker.js','page_profile.js')
                ),
                'master' => array(
                    'css' => array('v_tom-select.css','v_datepicker.css','page_tu-van.css','page_account.css','page_diem-danh.css','page_bang-cong.css'),
                    'js' => array('v_exceljs.js','v_FileSaver.js','v_tom-select.js','v_datepicker.js','page_diem-danh.js','page_bang-cong.js')
                ),
                'teacher' => array(
                    'css' => array('v_tom-select.css','page_diem-danh.css','page_bang-cong.css'),
                    'js' => array('v_tom-select.js','page_diem-danh.js','page_bang-cong.js')
                ),
                'accountant' => array(
                    'css' => array('page_bang-cong.css'),
                    'js' => array('v_exceljs.js','v_FileSaver.js')
                )
            ),
            'bot' => array(

            )
        );
        $data = $this->view->partial('block/head/head-src.phtml',$data); // Code
        // $data = $this->view->partial('block/head/head-internal-page.phtml',$data); // External(global), Internal(page) (*)
        // $data = $this->view->partial('block/head/head-internal-all.phtml',$data); // Internal(global, page)
        echo $data;
    }
}