<?php

namespace Frontend\Block;

use Frontend\Model\MenuPublicTb;
use Frontend\Model\ClassTb;
use Frontend\Model\NotificationTb;
use Frontend\View\Helper\SortNestedCate;
use Zend\Session\Container;
use Zend\View\Helper\AbstractHelper;

class Header extends AbstractHelper
{
	public function __invoke($params = null)
    {
    	//Begin code

        $MenuPublicTb = new MenuPublicTb();
        $ClassTb = new ClassTb();
        $NotificationTb = new NotificationTb();
        $SortNestedCate = new SortNestedCate();

        $session = new Container('frontend');
        $data['logged'] = $session->logged;

        $arrayNotifyNew = $arrayNotifyClose = array(
            'parent' => 0,
            'status' => 2
        );

        $arrayNotifyClose['status'] = 1;

        if($data['logged']['role'] == 1) {
            $arrayNotifyNew['user_open'] = $arrayNotifyClose['user_open'] = $data['logged']['id'];

            $data['listNotifyNew'] = $NotificationTb->listItem($arrayNotifyNew);
            $data['listNotifyClose'] = $NotificationTb->listItem($arrayNotifyClose);

            foreach ($data['listNotifyNew'] as $i => $value) {
                $reply = $NotificationTb->listItem(array('parent' => $value['id'], 'orderby' => 'notify.id ASC'));
                $data['listNotifyNew'][$i]['reply'] = $reply;
            }

            foreach ($data['listNotifyClose'] as $i => $value) {
                $reply = $NotificationTb->listItem(array('parent' => $value['id'], 'orderby' => 'notify.id ASC'));
                $data['listNotifyClose'][$i]['reply'] = $reply;
            }
        } else if($data['logged']['role'] == 2) {
            $listClass = $ClassTb->listItem();
            if($listClass) {
                $arrayNotifyNew['class_id'] = $arrayNotifyClose['class_id'] = array_column($listClass, 'id');

                $data['listNotifyNew'] = $NotificationTb->listItem($arrayNotifyNew);
                $data['listNotifyClose'] = $NotificationTb->listItem($arrayNotifyClose);

                foreach ($data['listNotifyNew'] as $i => $value) {
                    $reply = $NotificationTb->listItem(array('parent' => $value['id'], 'orderby' => 'notify.id ASC'));
                    $data['listNotifyNew'][$i]['reply'] = $reply;
                }

                foreach ($data['listNotifyClose'] as $i => $value) {
                    $reply = $NotificationTb->listItem(array('parent' => $value['id'], 'orderby' => 'notify.id ASC'));
                    $data['listNotifyClose'][$i]['reply'] = $reply;
                }
            }
        } else {
            $listClass = $ClassTb->listItem(array('consultant_id' => $data['logged']['id']));
            if($listClass) {
                $arrayNotifyNew['class_id'] = $arrayNotifyClose['class_id'] = array_column($listClass, 'id');

                $data['listNotifyNew'] = $NotificationTb->listItem($arrayNotifyNew);
                $data['listNotifyClose'] = $NotificationTb->listItem($arrayNotifyClose);

                foreach ($data['listNotifyNew'] as $i => $value) {
                    $reply = $NotificationTb->listItem(array('parent' => $value['id'], 'orderby' => 'notify.id ASC'));
                    $data['listNotifyNew'][$i]['reply'] = $reply;
                }

                foreach ($data['listNotifyClose'] as $i => $value) {
                    $reply = $NotificationTb->listItem(array('parent' => $value['id'], 'orderby' => 'notify.id ASC'));
                    $data['listNotifyClose'][$i]['reply'] = $reply;
                }
            }
        }

	    //End code

		$data = $this->view->partial('block/header.phtml',$data);
		echo $data;
	}
}