<?php

namespace Frontend\Controller;
use Frontend\Controller\ProductController;
use Frontend\Model\MemberTb;
use Frontend\Model\ClassTb;
use Frontend\Model\StudentTb;
use Frontend\Model\RoleTb;
use Frontend\Model\ConfigTb;
use Frontend\Model\InfoTb;
use Frontend\Model\StudentAttendancesTb;
use Frontend\Model\TimekeepingTb;
use Frontend\Model\SalariesTb;
use Zend\Mvc\Controller\AbstractActionController;
use Zend\Session\Container;
use Zend\View\Model\ViewModel;

class AjaxController extends AbstractActionController
{
    public function ajax81Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());
            $session = new Container('frontend');
            $MemberTb = new MemberTb();
            $data['listAccount'] = $MemberTb->listItem(array('deny_role' => [1], 'deny_id' => [$session->logged['id']], 'keysearch' => $params['keysearch']));

            //End code
        }

        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax82Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());

            $RoleTb = new RoleTb();
            $data['listRole'] = $RoleTb->listItem(array('deny_id' => [1]));

            $MemberTb = new MemberTb();
            $data['member'] = $MemberTb->getItem(array(
                'id' => $params['member_id'],
                'columns' => array('id','email','fullname','thumbnail','phone','address','birthday','sex','role','bank_number','bank_name','bank_owner','status','password')
            ));

            $data['link'] = $params['link'];

            //End code
        }
        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax83Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());

            $MemberTb = new MemberTb();
            $data['teacher'] = $MemberTb->getItem(array(
                'id' => $params['teacher_id'],
                'columns' => array('id','email','fullname','thumbnail','phone','address','birthday','sex','role','bank_number','bank_name','bank_owner','status','time_work','note','password')
            ));

            $data['link'] = $params['link'];

            //End code
        }
        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax84Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());

            $array = array(
                'role' => 1,
                'limit' => $params['limit']
            );

            $session = new Container('frontend'); // Khai báo thư viện: "Zend\Session\Container;"
            $session->filter = $session->filter ? $session->filter : array();

            if(isset($params['keysearch'])) {
                $array['keysearch'] = $session->keysearch = $params['keysearch'];
            }

            $MemberController = new MemberController();
            $list = $MemberController->listPageTeacher($array);
            $data['listTeacher'] = $list['list'];
            $data['paginator'] = $list['paginator'];
            $data['page'] = $list['params']['page'];

            $htmlList = $htmlPaginator = '';
            if($data['paginator']->getTotalItemCount() > 0) {
                foreach ($data['listTeacher'] as $i => $value) {
                    $htmlList .= '<tr data-id="'.$value['id'].'">
                        <td>'.(($data['paginator']->getPages()->current - 1) * $data['paginator']->getItemCountPerPage() + $i + 1).'</td>
                        <td><a href="'.$params['link'].'&wage='.$value['id'].'" class="name">'.$value['fullname'].'</a></td>
                        <td class="text-left">'.$value['email'].'</td>
                        '.($session->logged['role'] != 4 ? '<td><i ht-target="#modalEditTeacher" class="fa fa-pencil" aria-hidden="true"></i></td><td><i ht-trigger="c-modal" ht-target="#modalConfirmTeacher" class="fa fa-trash" aria-hidden="true"></i></td>':'').'
                    </tr>';
                }

                // Lùi lại 1 trang
                if (isset($this->previous)) {
                    $linkPrevious = '<a href="'.$params['link'].'&page='.$data['paginator']->getPages()->previous.'"><span><i class="fa fa-angle-left" aria-hidden="true"></i></span></a>';
                } else {
                    $linkPrevious = '<span class="disable"><i class="fa fa-angle-left" aria-hidden="true"></i></span>';
                }

                // Tiến lên 1 trang
                if (isset($data['paginator']->getPages()->next)) {
                    $linkNext = '<a href="'.$params['link'].'&page='.$data['paginator']->getPages()->next.'"><span><i class="fa fa-angle-right" aria-hidden="true"></i></span></a>';
                } else {
                    $linkNext ='<span class="disable"><i class="fa fa-angle-right" aria-hidden="true"></i></span>';
                }

                $htmlPaginator = '<div class="pagination">
                    <div class="pagination_number">
                        <span>'.$data['paginator']->getPages()->current.'</span>
                        <span>/</span>
                        <span>'.$data['paginator']->getPages()->last.'</span>
                    </div>
                    <div class="pagination_arrow">
                        '.$linkPrevious.' '.$linkNext.'
                    </div>
                </div>';
            } else {
                $htmlList = '<tr><td colspan="7">Không tìm thấy kết quả</td></tr>';
                $htmlPaginator = '<div class="pagination">
                    <div class="pagination_number">
                        <span>0</span>
                        <span>/</span>
                        <span>0</span>
                    </div>
                    <div class="pagination_arrow">
                        <span class="disable"><i class="fa fa-angle-left" aria-hidden="true"></i></span>
                        <span class="disable"><i class="fa fa-angle-right" aria-hidden="true"></i></span>
                    </div>
                </div>';
            }

            echo json_encode(array('htmlList' => $htmlList, 'htmlPaginator' => $htmlPaginator));

            //End code
        }

        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax85Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());
            $session = new Container('frontend'); // Khai báo thư viện: "Zend\Session\Container;"

            $array = array(
                'status' => $params['status'] == 2 ? 2 : 1,
                'limit' => $params['limit']
            );

            if(in_array($session->logged['role'], [4])) {
                $array['consultant_id'] = $session->logged['id'];
            }

            $session->filter = $session->filter ? $session->filter : array();

            if(isset($params['keysearch'])) {
                $array['keysearch'] = $session->keysearch = $params['keysearch'];
            }

            if(isset($params['teacher_id'])) {
                $session->teacher_id = $params['teacher_id'];
                if($params['teacher_id'])
                    $array['teacher_id'] = $params['teacher_id'];
            }

            $MemberController = new MemberController();
            $list = $MemberController->listPageClass($array);
            $data['listClass'] = $list['list'];
            $data['paginator'] = $list['paginator'];
            $data['page'] = $list['params']['page'];

            $htmlList = $htmlPaginator = '';
            if($data['paginator']->getTotalItemCount() > 0) {
                foreach ($data['listClass'] as $i => $value) {
                    $htmlList .= '<tr data-id="'.$value['id'].'">
                        <td>'.(($data['paginator']->getPages()->current - 1) * $data['paginator']->getItemCountPerPage() + $i + 1).'</td>
                        <td><a href="'.$params['linkCurrent'].'&id='.$value['id'].'" class="name">'.$value['name'].'</a></td>
                        <td><span class="td-teacher"><a href="'.$params['linkMenu'].'?action=teacher&wage='.$value['teacher_id'].'" target="_blank">'.$value['teacher_name'].'</a></span></td>
                        <td>'.$value['start_date'].'</td>
                        <td>'.$value['end_date'].'</td>
                        '.($session->logged['role'] != 4 ? '<td><i ht-target="#modalEditClass" class="fa fa-pencil" aria-hidden="true"></i></td>':'').($session->logged['role'] == 2 ? '<td><i ht-trigger="c-modal" ht-target="#modalConfirmClass" class="fa fa-trash" aria-hidden="true"></i></td>':'').'
                    </tr>';
                }

                // Lùi lại 1 trang
                if (isset($this->previous)) {
                    $linkPrevious = '<a href="'.$params['linkChange'].'&page='.$data['paginator']->getPages()->previous.'"><span><i class="fa fa-angle-left" aria-hidden="true"></i></span></a>';
                } else {
                    $linkPrevious = '<span class="disable"><i class="fa fa-angle-left" aria-hidden="true"></i></span>';
                }

                // Tiến lên 1 trang
                if (isset($data['paginator']->getPages()->next)) {
                    $linkNext = '<a href="'.$params['linkChange'].'&page='.$data['paginator']->getPages()->next.'"><span><i class="fa fa-angle-right" aria-hidden="true"></i></span></a>';
                } else {
                    $linkNext ='<span class="disable"><i class="fa fa-angle-right" aria-hidden="true"></i></span>';
                }

                $htmlPaginator = '<div class="pagination">
                    <div class="pagination_number">
                        <span>'.$data['paginator']->getPages()->current.'</span>
                        <span>/</span>
                        <span>'.$data['paginator']->getPages()->last.'</span>
                    </div>
                    <div class="pagination_arrow">
                        '.$linkPrevious.' '.$linkNext.'
                    </div>
                </div>';
            } else {
                $htmlList = '<tr><td colspan="7">Không tìm thấy kết quả</td></tr>';
                $htmlPaginator = '<div class="pagination">
                    <div class="pagination_number">
                        <span>0</span>
                        <span>/</span>
                        <span>0</span>
                    </div>
                    <div class="pagination_arrow">
                        <span class="disable"><i class="fa fa-angle-left" aria-hidden="true"></i></span>
                        <span class="disable"><i class="fa fa-angle-right" aria-hidden="true"></i></span>
                    </div>
                </div>';
            }

            echo json_encode(array('htmlList' => $htmlList, 'htmlPaginator' => $htmlPaginator, 'array' => $array));

            //End code
        }

        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax86Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());

            $session = new Container('frontend');
            $data['member'] = $session->logged;

            $MemberTb = new MemberTb();
            $ClassTb = new ClassTb();
            $data['listTeacher'] = $MemberTb->listItem(array('role' => 1));
            $data['listConsultants'] = $MemberTb->listItem(array('role' => [2,3,4]));
            $data['class'] = $ClassTb->getItem(array('id' => $params['class_id']));

            $data['link'] = $params['link'];

            //End code
        }
        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax87Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());

            $StudentTb = new StudentTb();
            $ClassTb = new ClassTb();

            $data['student'] = $StudentTb->getItem(array('id' => $params['student_id']));
            $data['student']['class_name'] = $ClassTb->getItem(array('id' => $data['student']['class_id']))['name'];

            //End code
        }
        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax88Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());

            $StudentTb = new StudentTb();
            $ClassTb = new ClassTb();
            $data['student'] = $StudentTb->getItem(array('id' => $params['student_id']));
            $data['class'] = $ClassTb->listItem();

            $data['link'] = $params['link'];

            //End code
        }
        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax89Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());
            $session = new Container('frontend'); // Khai báo thư viện: "Zend\Session\Container;"
            $MemberController = new MemberController();

            $array = array(
                'limit' => 10,
                'limit' => $params['limit']
            );

            if(in_array($session->logged['role'], [4])) {
                $listClass = array_column($MemberController->listClass(array('consultant_id' => $session->logged['id'])), 'id');
                $array['class_id'] = $listClass ? $listClass : '-1';
            }

            $session->filter = $session->filter ? $session->filter : array();

            if(isset($params['keysearch'])) {
                $array['keysearch'] = $session->keysearch = $params['keysearch'];
            }

            $list = $MemberController->listPageStudent($array);
            $data['listStudent'] = $list['list'];
            $data['paginator'] = $list['paginator'];
            $data['page'] = $list['params']['page'];

            $htmlList = $htmlPaginator = '';
            if($data['paginator']->getTotalItemCount() > 0) {
                foreach ($data['listStudent'] as $i => $value) {
                    $htmlList .= '<tr data-id="'.$value['id'].'">
                        <td>'.(($data['paginator']->getPages()->current - 1) * $data['paginator']->getItemCountPerPage() + $i + 1).'</td>
                        <td><a href="javascript:;" ht-target="#modalViewStudent" class="name">'.$value['fullname'].'</a></td>
                        <td>'.$value['phone'].'</td>
                        <td>'.$value['class_name'].'</td>
                        '.($session->logged['role'] != 4 ? '<td><i ht-target="#modalEditStudent" class="fa fa-pencil" aria-hidden="true"></i></td><td><i ht-trigger="c-modal" ht-target="#modalConfirmStudent" class="fa fa-trash" aria-hidden="true"></i></td>':'').'
                    </tr>';
                }

                // Lùi lại 1 trang
                if (isset($this->previous)) {
                    $linkPrevious = '<a href="'.$params['link'].'&page='.$data['paginator']->getPages()->previous.'"><span><i class="fa fa-angle-left" aria-hidden="true"></i></span></a>';
                } else {
                    $linkPrevious = '<span class="disable"><i class="fa fa-angle-left" aria-hidden="true"></i></span>';
                }

                // Tiến lên 1 trang
                if (isset($data['paginator']->getPages()->next)) {
                    $linkNext = '<a href="'.$params['link'].'&page='.$data['paginator']->getPages()->next.'"><span><i class="fa fa-angle-right" aria-hidden="true"></i></span></a>';
                } else {
                    $linkNext ='<span class="disable"><i class="fa fa-angle-right" aria-hidden="true"></i></span>';
                }

                $htmlPaginator = '<div class="pagination">
                    <div class="pagination_number">
                        <span>'.$data['paginator']->getPages()->current.'</span>
                        <span>/</span>
                        <span>'.$data['paginator']->getPages()->last.'</span>
                    </div>
                    <div class="pagination_arrow">
                        '.$linkPrevious.' '.$linkNext.'
                    </div>
                </div>';
            } else {
                $htmlList = '<tr><td colspan="7">Không tìm thấy kết quả</td></tr>';
                $htmlPaginator = '<div class="pagination">
                    <div class="pagination_number">
                        <span>0</span>
                        <span>/</span>
                        <span>0</span>
                    </div>
                    <div class="pagination_arrow">
                        <span class="disable"><i class="fa fa-angle-left" aria-hidden="true"></i></span>
                        <span class="disable"><i class="fa fa-angle-right" aria-hidden="true"></i></span>
                    </div>
                </div>';
            }

            echo json_encode(array('htmlList' => $htmlList, 'htmlPaginator' => $htmlPaginator, 'logged' => $array));
            return $this->getResponse();

            //End code
        }

        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax90Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {
            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());
            $session = new Container('frontend');
            $MemberController = new MemberController();

            if($params['class_id'] && $params['teacher_id']) {
                $StudentAttendancesTb = new StudentAttendancesTb();
                $ClassTb = new ClassTb();
                $classCurrent = $ClassTb->getItem(array(
                    'id' => $params['class_id'],
                    'teacher_id' => $params['teacher_id'],
                ));

                // tạo ra các buổi học
                $makeupDate = json_decode($classCurrent['makeup_date'], true) ? json_decode($classCurrent['makeup_date'], true) : [];
                $offDate = $classCurrent['off_date'] ? $classCurrent['off_date'] : [];
                $schedule = $MemberController->generateSchedule($classCurrent['start_date'], $classCurrent['end_date'], $classCurrent['day_of_week'], $makeupDate, $offDate);

                $indexActive = array_search(1, array_column($schedule, 'active'));
                if($schedule[$indexActive] && $params['student_id']) {
                    $activeDate = $schedule[$indexActive];

                    // check có hv trong bảng điểm danh chưa?
                    $studentAttendances = $StudentAttendancesTb->getItem(array(
                        'student_id' => $params['student_id'],
                        'class_id' => $classCurrent['id'],
                        'session_date' => $activeDate['date']
                    ));

                    if($studentAttendances['id']) {
                        $postStudent['id'] = $studentAttendances['id'];
                    }

                    $postStudent['post'] = array(
                        'student_id' => $params['student_id'],
                        'class_id' => $classCurrent['id'],
                        'session_date' => $activeDate['date'],
                        'checkin' => $params['checkin']
                    );
                    $studentAttendancesIDResponse = $StudentAttendancesTb->saveData($postStudent);

                    switch ($params['checkin']) {
                        case 'ĐH':
                            $classNameHTML = 'present-color';
                            break;
                        case 'CP':
                            $classNameHTML = 'cp-color';
                            break;
                        default:
                            $classNameHTML = 'absence-color';
                            break;
                    }

                    // Check nếu đã điểm danh hết hv thì sẽ tạo 1 chấm công cho gv
                    $studentList = $MemberController->sortStudentsByName($MemberController->listStudent(array(
                        'class_id' => $classCurrent['id'],
                        'status' => 1
                    )));

                    if($studentList) {
                        foreach ($studentList as $i => $student) {
                            $studentList[$i]['checkin'] = [];
                            foreach ($schedule as $j => $item) {
                                $studentAttendances = $StudentAttendancesTb->getItem(array(
                                    'student_id' => $student['id'],
                                    'class_id' => $classCurrent['id'],
                                    'session_date' => $item['date']
                                ));

                                $studentList[$i]['checkin'][str_replace('/','-', $item['date'])] = array(
                                    'label' => $item['label'],
                                    'date' => $item['date'],
                                    'active' => $item['active'],
                                    'active_next' => $item['active_next'],
                                    'off' => $item['off']
                                );

                                if($studentAttendances['id']) {
                                    $studentList[$i]['checkin'][str_replace('/','-', $item['date'])]['checkInName'] = $studentAttendances['checkin'];
                                }
                            }
                        }

                        foreach ($schedule as $i => $item) {
                            $checkin = [];
                            foreach ($studentList as $j => $student) {
                                $checkin[] = array(
                                    'id' => $student['id'],
                                    'fullname' => $student['fullname'],
                                    'checkInName' => $student['checkin'][str_replace('/','-', $item['date'])]['checkInName'],
                                    'off' => $item['off']
                                );
                            }

                            $countTotalAbsent = 0;
                            foreach ($checkin as $value) {
                                if($value['checkInName'] && !$value['off'])
                                    $countTotalAbsent++;
                            }
                            $schedule[$i]['totalAbsent'] = $countTotalAbsent;
                            $schedule[$i]['totalStudent'] = count($studentList);
                        }

                        // lấy ra ngày active và ngày đó không OFF
                        if($schedule[$indexActive]['totalAbsent'] == $schedule[$indexActive]['totalStudent'] && !$schedule[$indexActive]['off']) {
                            $TimekeepingTb = new TimekeepingTb();
                            $postData = [
                                'class_id' => $classCurrent['id'],
                                'teacher_id' => $classCurrent['teacher_id'],
                                'date_checkin' => $schedule[$indexActive]['date']
                            ];

                            $itemTimekeeping = $TimekeepingTb->getItem($postData);

                            if(!$itemTimekeeping['id']) {
                                $TimekeepingTb->saveData(['post' => $postData]);
                            }
                        }
                    }
                }
            }

            echo json_encode(array(
                'studentAttendances' => $studentAttendancesIDResponse,
                'className' => $classNameHTML,
                'scheduleCurrent' => $schedule[$indexActive],
                'itemTimekeeping' => $itemTimekeeping,
                'postData' => $postData,
            ));

            return $this->getResponse();

            //End code
        }
    }

    public function ajax91Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {
            //Begin code
            $params = array_merge($params, $this->getRequest()->getPost()->toArray());
            $session = new Container('frontend');
            $MemberController = new MemberController();

            if($params['class_id'] && $params['teacher_id']) {
                $ClassTb = new ClassTb();
                $classCurrent = $ClassTb->getItem(array(
                    'id' => $params['class_id'],
                    'teacher_id' => $params['teacher_id']
                ));

                // tạo ra các buổi học
                $makeupDate = json_decode($classCurrent['makeup_date'], true) ? json_decode($classCurrent['makeup_date'], true) : [];
                $offDate = $classCurrent['off_date'] ? $classCurrent['off_date'] : [];
                $schedule = $MemberController->generateSchedule($classCurrent['start_date'], $classCurrent['end_date'], $classCurrent['day_of_week'], $makeupDate, $offDate);

                $indexActive = array_search(1, array_column($schedule, 'active'));
                if($indexActive && $params['student_id']) {
                    $activeDate = $schedule[$indexActive];

                    $StudentAttendancesTb = new StudentAttendancesTb();
                    $studentAttendances = $StudentAttendancesTb->listItem(array(
                        'student_id' => $params['student_id'],
                        'class_id' => $classCurrent['id'],
                    ));

                    $ConfigTb = new ConfigTb();
                    $config = $ConfigTb->getItem(array('id' => 1));

                    if($config['student_off'] > 0) {
                        $StudentTb = new StudentTb();
                        $student = $StudentTb->getItem(array('id' => $params['student_id']));

                        $result = $MemberController->checkContinuousAbsence($schedule, $studentAttendances, $config['student_off']);
                        if ($result['has_absence'] && $classCurrent['consultant_email']) {
                            if(empty($student['sendmail']) || $student['sendmail'] != 1) {
                                $detailAbsent = '';
                                foreach ($result['absent_sessions'] as $absent) {
                                    $detailAbsent .= '<p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><strong>. '.$absent['label'].': '.$absent['date'].'</strong></span></span></em></p>';
                                }

                                $InfoTb = new InfoTb();
                                $data['info'] = $InfoTb->getItem();

                                $template = array(
                                    'subject' => '[[[domain]]] Thông báo: Học viên [[ten-hoc-vien]] đã vắng mặt [[buoi]] buổi liên tiếp',
                                    'key' => array('[[domain]]','[[ten-tu-van]]','[[ten-hoc-vien]]','[[lop-hoc]]','[[buoi]]','[[thong-tin-vang]]'),
                                    'value' => array(
                                        DOMAIN,
                                        $classCurrent['consultant_name'],
                                        $student['fullname'],
                                        $classCurrent['name'],
                                        $config['student_off'],
                                        $detailAbsent
                                    ),
                                    'body' => '<p style="border-bottom: 1px solid #eee;"><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank"><img height="43" src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'" style="width: 140px;" /></a></span></span></p>
                                        <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Chào bạn <strong>[[ten-tu-van]]</strong>,</span></span></p>
                                        <p style="margin-bottom: 10px;"><font color="#1f4e79" face="Times New Roman, Times, serif"><span style="font-size: 16px;"><b><i>Học viên [[ten-hoc-vien]] thuộc lớp </i></b><strong><i>[[lop-hoc]] đã vắng mặt [[buoi]] buổi liên tiếp.&nbsp;</i></strong></span></font></p>
                                        <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Thông tin vắng mặt của học viên:</span></span></em></strong></span></p>
                                        <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;">[[thong-tin-vang]]</p>
                                        <p style="margin-top: 0;"><span style="font-family:Times New Roman,Times,serif;font-size:16px;"><em><strong>* <u>Ghi chú</u>:</strong> Đây là email thông báo tự động. Vui lòng không phản hồi lại email này!</em></span></p>'
                                );

                                $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                                    'emailTo' => $classCurrent['consultant_email'],
                                    'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                                    'body' => str_replace($template['key'], $template['value'], $template['body'])
                                ));

                                // Flag check đã sendmail
                                $StudentTb->saveData(array('id' => $params['student_id'], 'post' => array('sendmail' => true)));
                            }
                        } else {
                            // Đặt lại biến sendmail
                            $StudentTb->saveData(array('id' => $params['student_id'], 'post' => array('sendmail' => 2)));
                        }
                    }
                }
            }

            echo json_encode(array('result' => $result, 'student' => $student));

            //End code
        }

        return $this->getResponse();
    }

    public function ajax92Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {
            //Begin code
            $params = array_merge($params, $this->getRequest()->getPost()->toArray());
            $session = new Container('frontend');
            $MemberController = new MemberController();

            if($params['class_id'] && $params['teacher_id'] && $params['off_date']) {
                $ClassTb = new ClassTb();
                $classCurrent = $ClassTb->getItem(array(
                    'id' => $params['class_id'],
                    'teacher_id' => $params['teacher_id']
                ));

                $offDate = $classCurrent['off_date'] ? $classCurrent['off_date'] : [];

                if($params['type'] == 'add') {
                    $offDate[] = $params['off_date'];
                    $offDate = array_unique($offDate);
                } else {
                    if(!empty($offDate)) {
                        $indexDate = array_search($params['off_date'], $offDate);
                        if ($indexDate !== false) {
                            unset($offDate[$indexDate]);
                            $offDate = array_values($offDate);
                        }
                    }
                }

                $ClassTb->saveData(array('id' => $classCurrent['id'], 'post' => ['off_date' => $offDate]));

                // Lấy lại thông tin class sau khi update
                $classAfterSave = $ClassTb->getItem(array(
                    'id' => $params['class_id'],
                    'teacher_id' => $params['teacher_id']
                ));

                // tạo ra các buổi học
                $makeupDate = json_decode($classAfterSave['makeup_date'], true) ? json_decode($classAfterSave['makeup_date'], true) : [];
                $offDate = $classAfterSave['off_date'] ? $classAfterSave['off_date'] : [];
                $schedule = $MemberController->generateSchedule($classAfterSave['start_date'], $classAfterSave['end_date'], $classAfterSave['day_of_week'], $makeupDate, $offDate);

                $ConfigTb = new ConfigTb();
                $config = $ConfigTb->getItem(array('id' => 1));

                if($config['teacher_off'] > 0) {
                    $result = $MemberController->checkTeacherConsecutiveOffDays($schedule, $offDate, $config['teacher_off']);
                    if ($result['has_absence'] && $classAfterSave['teacher_email']) {
                        if(empty($classAfterSave['sendmail']) || $classAfterSave['sendmail'] != 1) {
                            $detailAbsent = '';
                            foreach ($result['absent_sessions'] as $absent) {
                                $detailAbsent .= '<p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><strong>. '.$absent['label'].': '.$absent['date'].'</strong></span></span></em></p>';
                            }

                            $InfoTb = new InfoTb();
                            $data['info'] = $InfoTb->getItem();

                            $template = array(
                                'subject' => '[[[domain]]] Thông báo: Giáo viên [[ten-giao-vien]] đã OFF [[buoi]] buổi liên tiếp',
                                'key' => array('[[domain]]','[[ten-tu-van]]','[[ten-giao-vien]]','[[lop-hoc]]','[[buoi]]','[[thong-tin-off]]'),
                                'value' => array(
                                    DOMAIN,
                                    $classAfterSave['consultant_name'],
                                    $classAfterSave['teacher_name'],
                                    $classAfterSave['name'],
                                    $config['teacher_off'],
                                    $detailAbsent
                                ),
                                'body' => '<p style="border-bottom: 1px solid #eee;"><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank"><img height="43" src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'" style="width: 140px;" /></a></span></span></p>
                                    <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Chào bạn <strong>[[ten-tu-van]]</strong>,</span></span></p>
                                    <p style="margin-bottom: 10px;"><font color="#1f4e79" face="Times New Roman, Times, serif"><span style="font-size: 16px;"><b><i>Giáo viên [[ten-giao-vien]] thuộc lớp </i></b><strong><i>[[lop-hoc]] hiện đã OFF [[buoi]] buổi liên tiếp.&nbsp;</i></strong></span></font></p>
                                    <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Thông tin OFF của giáo viên:</span></span></em></strong></span></p>
                                    <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;">[[thong-tin-off]]</p>
                                    <p style="margin-top: 0;"><span style="font-family:Times New Roman,Times,serif;font-size:16px;"><em><strong>* <u>Ghi chú</u>:</strong> Đây là email thông báo tự động. Vui lòng không phản hồi lại email này!</em></span></p>'
                            );

                            $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                                'emailTo' => $classAfterSave['consultant_email'],
                                'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                                'body' => str_replace($template['key'], $template['value'], $template['body'])
                            ));

                            // Flag check đã sendmail
                            $ClassTb->saveData(array('id' => $classAfterSave['id'], 'post' => array('sendmail' => true)));
                        }
                    } else {
                        // Đặt lại biến sendmail
                        $ClassTb->saveData(array('id' => $classAfterSave['id'], 'post' => array('sendmail' => 2)));
                    }
                }

                echo json_encode(['offCount' => count($offDate)]);
            }

            //End code
        }

        return $this->getResponse();
    }

    public function ajax93Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {
            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());
            $session = new Container('frontend');

            if($params['teacher_id'] && $params['month']) {
                $SalariesTb = new SalariesTb();
                $postData['post'] = array(
                    'teacher_id' => $params['teacher_id'],
                    'month' => $params['month']
                );

                $salaries = $SalariesTb->getItem($postData['post']);

                if($salaries['id']) {
                    $postData['id'] = $salaries['id'];
                }

                $postData['post']['print'] = $params['print'];
                $postData['post']['zoom'] = $params['zoom'];
                $postData['post']['other'] = $params['other'];
                $postData['post']['note'] = $params['note'];
                $postData['post']['upsell'] = $params['upsell'];

                $SalariesTb->saveData($postData);
            }

            echo json_encode(array('params' => $params, 'salaries' => $salaries, 'postData' => $postData));

            //End code
        }

        return $this->getResponse();
    }

    public function ajax94Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());

            $MemberTb = new MemberTb();
            $ClassTb = new ClassTb();
            $TimekeepingTb = new TimekeepingTb();

            $array = array(
                'status' => 1,
                'role' => 1,
            );

            if(isset($params['keysearch'])) {
                $array['keysearch'] = $params['keysearch'];
            }

            $data['listTeacher'] = $MemberTb->listItem($array);

            // Lấy ngày, tháng, năm hiện tại
            $currentDay = date("j");
            $currentMonth = date("n");
            $currentYear = date("Y");

            // Giá trị mặc định
            $month = $currentMonth;
            $year = $currentYear;

            // Phân tích URL để lấy query string
            $parsedUrl = parse_url($params['link']);
            $queryString = $parsedUrl['query'] ?? '';

            // Chuyển query string thành mảng
            parse_str($queryString, $queryParams);

            // Kiểm tra nếu có `month` trong query string
            if (!empty($queryParams['month']) && preg_match('/^(0[1-9]|1[0-2])-\d{4}$/', $queryParams['month'])) {
                list($month, $year) = explode('-', $queryParams['month']);
                $month = (int)$month;
                $year = (int)$year;
            }

            // Xác định số ngày trong tháng
            $totalDays = ($month == 2) ? (($year % 4 == 0 && ($year % 100 != 0 || $year % 400 == 0)) ? 29 : 28)
                        : cal_days_in_month(CAL_GREGORIAN, $month, $year);

            // Tạo danh sách ngày trong tháng
            $data['daysArray'] = [];
            for ($i = 1; $i <= $totalDays; $i++) {
                $data['daysArray'][] = [
                    "date" => sprintf("%02d/%02d/%04d", $i, $month, $year), // Định dạng DD/MM/YYYY
                    "current" => ($i == $currentDay && $month == $currentMonth && $year == $currentYear),
                    "status" => "", // Mặc định rỗng
                    "checkin" => 0  // Mặc định chưa checkin
                ];
            }

            $data['qualifiedTeachers'] = 0;
            foreach ($data['listTeacher'] as $i => $teacher) {
                $data['listTeacher'][$i]['bank_full'] = $teacher['bank_number'].' - '.$teacher['bank_name'];

                // lấy danh sách lớp của gv đang dạy trong tháng
                $listClassMap = $ClassTb->listItem(array(
                    'teacher_id' => $teacher['id'],
                    'orderby' => 'class.id ASC',
                    'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                ));

                //  Lấy danh sách chấm công của GV
                $timekeeping = $TimekeepingTb->listItem(array(
                    'teacher_id' => $teacher['id'],
                    'columns' => array('class_id','teacher_id','date_checkin')
                ));

                // Danh sách id lớp đang map với GV
                $classIdMap = array_unique(array_column($listClassMap, 'id'));

                // Lấy danh sách lớp mà GV đó đã từng dạy (tính luôn trường hợp đang dạy mà ngừng hoặc chuyển lớp khác)
                $taughtClasses = array_unique(array_column($timekeeping, 'class_id'));

                // Gốp danh sách ID lại để có ds lớp cuối cùng bao gồm lớp đang map và lớp đã từng dạy
                $listIdClassFinal = array_unique(array_merge($classIdMap, $taughtClasses));

                if(!empty($listIdClassFinal)) {
                    // lấy danh sách lớp của gv đang dạy trong tháng
                    $listClass = $ClassTb->listItem(array(
                        'list_id' => $listIdClassFinal,
                        'orderby' => 'class.id ASC',
                        'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                    ));

                    // Lấy danh sách chấm công của gv đang dạy cho từng lớp
                    foreach ($listClass as $k => $value) {
                        $listCheckin = [];
                        foreach ($timekeeping as $item) {
                            if($item['class_id'] == $value['id']) {
                                $listCheckin[] = $item['date_checkin'];
                            }
                        }
                        $listClass[$k]['timekeeping'] = $listCheckin;
                    }

                    // Duyệt qua từng lớp và gán danh sách ngày
                    foreach ($listClass as &$class) {
                        $updatedDaysArray = [];

                        foreach ($data['daysArray'] as $day) {
                            $status = "";
                            $checkin = 0;

                            // Xác định trạng thái
                            $makeupDate = json_decode($class["makeup_date"], true);
                            $offDate = json_decode($class["off_date"], true);
                            if (in_array($day["date"], $makeupDate)) {
                                $status = "Học bù";
                            } elseif (in_array($day["date"], $offDate)) {
                                $status = "OFF";
                            }

                            // Kiểm tra checkin
                            if (in_array($day["date"], $class["timekeeping"])) {
                                $checkin = 1;
                            }

                            $updatedDaysArray[] = [
                                "date" => $day["date"],
                                "current" => $day["current"],
                                "status" => $status,
                                "checkin" => $checkin
                            ];
                        }

                        // Thêm danh sách ngày vào lớp học
                        $class["days"] = $updatedDaysArray;
                    }

                    // Lọc các lớp có thời gian học nằm trong tháng lấy từ $_GET['month']
                    $listClass = array_filter($listClass, function ($class) use ($month, $year) {
                        $startDate = \DateTime::createFromFormat('d/m/Y', $class["start_date"]);
                        $endDate = \DateTime::createFromFormat('d/m/Y', $class["end_date"]);

                        if (!$startDate || !$endDate) return false; // Bỏ qua nếu ngày không hợp lệ

                        // Lấy danh sách các ngày học bù
                        $makeupDays = isset($class["makeup_date"]) ? json_decode($class["makeup_date"], true) : [];

                        // Kiểm tra nếu có ngày học bù trong tháng đang xét
                        $hasMakeupInMonth = array_filter($makeupDays, function ($date) use ($month, $year) {
                            $makeupDate = \DateTime::createFromFormat('d/m/Y', $date);
                            return $makeupDate && $makeupDate->format('n') == $month && $makeupDate->format('Y') == $year;
                        });

                        // Xác định phạm vi tháng cần kiểm tra
                        $monthStart = new \DateTime("$year-$month-01");
                        $monthEnd = clone $monthStart;
                        $monthEnd->modify('last day of this month');

                        // Điều kiện lọc chính xác
                        return (
                            // Ngày bắt đầu hoặc ngày kết thúc nằm trong tháng
                            ($startDate->format('n') == $month && $startDate->format('Y') == $year) ||
                            ($endDate->format('n') == $month && $endDate->format('Y') == $year) ||
                            // Khoảng thời gian lớp học bao phủ ít nhất một ngày trong tháng
                            ($startDate <= $monthEnd && $endDate >= $monthStart) ||
                            // Có ít nhất một ngày học bù trong tháng
                            !empty($hasMakeupInMonth)
                        );
                    });

                    // Kiểm tra xem GV có đủ điều kiện chấm lương trong tháng
                    if($listClass) {
                        $data['qualifiedTeachers']++;
                        $data['listTeacher'][$i]['qualifiedTeachers'] = true;
                    }

                    // Duyệt qua từng lớp học
                    foreach ($listClass as &$class) {
                        $totalDaysTaught = 0;

                        // Duyệt qua danh sách ngày của lớp
                        foreach ($class['days'] as $day) {
                            $dateParts = explode("/", $day['date']); // Tách ngày/tháng/năm
                            $dayMonth = (int)$dateParts[1]; // Lấy tháng
                            $dayYear = (int)$dateParts[2]; // Lấy năm

                            // Kiểm tra nếu ngày thuộc tháng & năm cần tính và có checkin
                            if ($dayMonth == $month && $dayYear == $year && $day['checkin'] > 0) {
                                $totalDaysTaught++;
                            }
                        }

                        // Thêm số ngày đã dạy vào mảng dữ liệu của lớp
                        $class['total_days_taught'] = $totalDaysTaught;
                    }

                    $listClass = array_values($listClass);

                    // Tính lương cho từng giáo viên
                    $totalSalaries = $totalTeaching = $totalOfClass = 0;
                    foreach ($listClass as $value) {
                        $totalOfClass = $value['session_salaries'] * $value['total_days_taught'];
                        $totalTeaching += $totalOfClass;
                    }

                    $ConfigTb = new ConfigTb();
                    $config = $ConfigTb->getItem(array('id' => 1));

                    $SalariesTb = new SalariesTb();
                    $upsell = $SalariesTb->getItem(array(
                        'teacher_id' => $teacher['id'],
                        'month' => $month.'/'.$year
                    ));

                    if($teacher['time_work'] == 2 && $config['tax'] && $config['tax'] > 0) {
                        $totalTeaching = $totalTeaching * ((100 - $config['tax']) / 100);
                    }

                    $totalUpsell = $totalOther = 0;
                    foreach ($upsell['upsell'] as $value) {
                        $quantity = $value['quantity'] && $value['quantity'] > 0 ? $value['quantity'] : 1;
                        $money = str_replace('.','', $value['money']);
                        $totalUpsell += $money * $quantity;
                    }

                    $totalOther = str_replace('.','', $upsell['print']) + str_replace('.','', $upsell['zoom']) + str_replace('.','', $upsell['other']);
                    $totalSalaries = $totalTeaching + $totalUpsell + $totalOther;

                    $data['listTeacher'][$i]['totalTeaching'] = $totalTeaching;
                    $data['listTeacher'][$i]['totalUpsell'] = $totalUpsell;
                    $data['listTeacher'][$i]['totalOther'] = $totalOther;
                    $data['listTeacher'][$i]['totalSalaries'] = $totalSalaries;
                }
            }

            //End code
        }
        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax95Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());

            $MemberTb = new MemberTb();
            $ClassTb = new ClassTb();
            $TimekeepingTb = new TimekeepingTb();
            $StudentTb = new StudentTb();
            $SalariesTb = new SalariesTb();

            // Lấy ngày, tháng, năm hiện tại
            $currentDay = date("j");
            $currentMonth = date("n");
            $currentYear = date("Y");

            // Giá trị mặc định
            $month = $currentMonth;
            $year = $currentYear;

            // Phân tích URL để lấy query string
            $parsedUrl = parse_url($params['link']);
            $queryString = $parsedUrl['query'] ?? '';

            // Chuyển query string thành mảng
            parse_str($queryString, $queryParams);

            // Kiểm tra nếu có `month` trong query string
            if (!empty($queryParams['month']) && preg_match('/^(0[1-9]|1[0-2])-\d{4}$/', $queryParams['month'])) {
                list($month, $year) = explode('-', $queryParams['month']);
                $month = (int)$month;
                $year = (int)$year;
            }

            $data['month'] = $month;
            $data['year'] = $year;

            // Xác định số ngày trong tháng
            $totalDays = ($month == 2) ? (($year % 4 == 0 && ($year % 100 != 0 || $year % 400 == 0)) ? 29 : 28)
                        : cal_days_in_month(CAL_GREGORIAN, $month, $year);

            // Tạo danh sách ngày trong tháng
            $data['daysArray'] = [];
            for ($i = 1; $i <= $totalDays; $i++) {
                $data['daysArray'][] = [
                    "date" => sprintf("%02d/%02d/%04d", $i, $month, $year), // Định dạng DD/MM/YYYY
                    "current" => ($i == $currentDay && $month == $currentMonth && $year == $currentYear),
                    "status" => "", // Mặc định rỗng
                    "checkin" => 0  // Mặc định chưa checkin
                ];
            }

            $data['teacher'] = $MemberTb->getItem(array('id' => $params['teacher_id']));

            if($data['teacher']['id']) {
                // lấy danh sách lớp của gv đang dạy trong tháng
                $listClassMap = $ClassTb->listItem(array(
                    'teacher_id' => $data['teacher']['id'],
                    'orderby' => 'class.id ASC',
                    'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                ));

                //  Lấy danh sách chấm công của GV
                $timekeeping = $TimekeepingTb->listItem(array(
                    'teacher_id' => $data['teacher']['id'],
                    'columns' => array('class_id','teacher_id','date_checkin')
                ));

                // Danh sách id lớp đang map với GV
                $classIdMap = array_unique(array_column($listClassMap, 'id'));

                // Lấy danh sách lớp mà GV đó đã từng dạy (tính luôn trường hợp đang dạy mà ngừng hoặc chuyển lớp khác)
                $taughtClasses = array_unique(array_column($timekeeping, 'class_id'));

                // Gốp danh sách ID lại để có ds lớp cuối cùng bao gồm lớp đang map và lớp đã từng dạy
                $listIdClassFinal = array_unique(array_merge($classIdMap, $taughtClasses));

                if(!empty($listIdClassFinal)) {
                    // lấy danh sách lớp của gv đang dạy trong tháng
                    $data['listClass'] = $ClassTb->listItem(array(
                        'list_id' => $listIdClassFinal,
                        'orderby' => 'class.id ASC',
                        'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                    ));

                    // Lấy danh sách chấm công của gv đang dạy cho từng lớp
                    foreach ($data['listClass'] as $i => $value) {
                        $listCheckin = [];
                        foreach ($timekeeping as $j => $item) {
                            if($item['class_id'] == $value['id']) {
                                $listCheckin[] = $item['date_checkin'];
                            }
                        }
                        $data['listClass'][$i]['timekeeping'] = $listCheckin;
                    }

                    // Duyệt qua từng lớp và gán danh sách ngày
                    foreach ($data['listClass'] as &$class) {
                        $updatedDaysArray = [];

                        foreach ($data['daysArray'] as $day) {
                            $status = "";
                            $checkin = 0;

                            // Xác định trạng thái
                            $makeupDate = json_decode($class["makeup_date"], true);
                            $offDate = json_decode($class["off_date"], true);
                            if (in_array($day["date"], $makeupDate)) {
                                $status = "Học bù";
                            } elseif (in_array($day["date"], $offDate)) {
                                $status = "OFF";
                            }

                            // Kiểm tra checkin
                            if (in_array($day["date"], $class["timekeeping"])) {
                                $checkin = 1;
                            }

                            $updatedDaysArray[] = [
                                "date" => $day["date"],
                                "current" => $day["current"],
                                "status" => $status,
                                "checkin" => $checkin
                            ];
                        }

                        // Thêm danh sách ngày vào lớp học
                        $class["days"] = $updatedDaysArray;
                    }

                    // Lọc các lớp có thời gian học nằm trong tháng lấy từ $_GET['month']
                    $data['listClass'] = array_filter($data['listClass'], function ($class) use ($month, $year) {
                        $startDate = \DateTime::createFromFormat('d/m/Y', $class["start_date"]);
                        $endDate = \DateTime::createFromFormat('d/m/Y', $class["end_date"]);

                        if (!$startDate || !$endDate) return false; // Bỏ qua nếu ngày không hợp lệ

                        // Lấy danh sách các ngày học bù
                        $makeupDays = isset($class["makeup_date"]) ? json_decode($class["makeup_date"], true) : [];

                        // Kiểm tra nếu có ngày học bù trong tháng đang xét
                        $hasMakeupInMonth = array_filter($makeupDays, function ($date) use ($month, $year) {
                            $makeupDate = \DateTime::createFromFormat('d/m/Y', $date);
                            return $makeupDate && $makeupDate->format('n') == $month && $makeupDate->format('Y') == $year;
                        });

                        // Xác định phạm vi tháng cần kiểm tra
                        $monthStart = new \DateTime("$year-$month-01");
                        $monthEnd = clone $monthStart;
                        $monthEnd->modify('last day of this month');

                        // Điều kiện lọc chính xác
                        return (
                            // Ngày bắt đầu hoặc ngày kết thúc nằm trong tháng
                            ($startDate->format('n') == $month && $startDate->format('Y') == $year) ||
                            ($endDate->format('n') == $month && $endDate->format('Y') == $year) ||
                            // Khoảng thời gian lớp học bao phủ ít nhất một ngày trong tháng
                            ($startDate <= $monthEnd && $endDate >= $monthStart) ||
                            // Có ít nhất một ngày học bù trong tháng
                            !empty($hasMakeupInMonth)
                        );
                    });

                    // Duyệt qua từng lớp học
                    foreach ($data['listClass'] as &$class) {
                        $totalDaysTaught = 0;

                        // Duyệt qua danh sách ngày của lớp
                        foreach ($class['days'] as $day) {
                            $dateParts = explode("/", $day['date']); // Tách ngày/tháng/năm
                            $dayMonth = (int)$dateParts[1]; // Lấy tháng
                            $dayYear = (int)$dateParts[2]; // Lấy năm

                            // Kiểm tra nếu ngày thuộc tháng & năm cần tính và có checkin
                            if ($dayMonth == $month && $dayYear == $year && $day['checkin'] > 0) {
                                $totalDaysTaught++;
                            }
                        }

                        // Thêm số ngày đã dạy vào mảng dữ liệu của lớp
                        $class['total_days_taught'] = $totalDaysTaught;
                    }

                    $data['listClass'] = array_values($data['listClass']);
                }
            }

            $ConfigTb = new ConfigTb();
            $data['config'] = $ConfigTb->getItem(array('id' => 1));

            $data['upsell'] = $SalariesTb->getItem(array(
                'teacher_id' => $data['teacher']['id'],
                'month' => $month.'/'.$year
            ));

            // echo '<pre style="color:#f00;font-weight:bold;">'; print_r($data['listClass']); echo '</pre>';

            //End code
        }
        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax96Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());

            $MemberTb = new MemberTb();
            $ClassTb = new ClassTb();
            $TimekeepingTb = new TimekeepingTb();

            $array = array(
                'status' => 1,
                'role' => 1,
            );

            $data['listTeacher'] = $MemberTb->listItem($array);

            // Lấy ngày, tháng, năm hiện tại
            $currentDay = date("j");
            $currentMonth = date("n");
            $currentYear = date("Y");

            // Giá trị mặc định
            $month = $currentMonth;
            $year = $currentYear;

            // Phân tích URL để lấy query string
            $parsedUrl = parse_url($params['link']);
            $queryString = $parsedUrl['query'] ?? '';

            // Chuyển query string thành mảng
            parse_str($queryString, $queryParams);

            // Kiểm tra nếu có `month` trong query string
            if (!empty($queryParams['month']) && preg_match('/^(0[1-9]|1[0-2])-\d{4}$/', $queryParams['month'])) {
                list($month, $year) = explode('-', $queryParams['month']);
                $month = (int)$month;
                $year = (int)$year;
            }

            // Xác định số ngày trong tháng
            $totalDays = ($month == 2) ? (($year % 4 == 0 && ($year % 100 != 0 || $year % 400 == 0)) ? 29 : 28)
                        : cal_days_in_month(CAL_GREGORIAN, $month, $year);

            // Tạo danh sách ngày trong tháng
            $data['daysArray'] = [];
            for ($i = 1; $i <= $totalDays; $i++) {
                $data['daysArray'][] = [
                    "date" => sprintf("%02d/%02d/%04d", $i, $month, $year), // Định dạng DD/MM/YYYY
                    "current" => ($i == $currentDay && $month == $currentMonth && $year == $currentYear),
                    "status" => "", // Mặc định rỗng
                    "checkin" => 0  // Mặc định chưa checkin
                ];
            }

            $data['qualifiedTeachers'] = 0;
            foreach ($data['listTeacher'] as $i => $teacher) {
                $data['listTeacher'][$i]['bank_full'] = $teacher['bank_number'].' - '.$teacher['bank_name'];

                // lấy danh sách lớp của gv đang dạy trong tháng
                $listClassMap = $ClassTb->listItem(array(
                    'teacher_id' => $teacher['id'],
                    'orderby' => 'class.id ASC',
                    'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                ));

                //  Lấy danh sách chấm công của GV
                $timekeeping = $TimekeepingTb->listItem(array(
                    'teacher_id' => $teacher['id'],
                    'columns' => array('class_id','teacher_id','date_checkin')
                ));

                // Danh sách id lớp đang map với GV
                $classIdMap = array_unique(array_column($listClassMap, 'id'));

                // Lấy danh sách lớp mà GV đó đã từng dạy (tính luôn trường hợp đang dạy mà ngừng hoặc chuyển lớp khác)
                $taughtClasses = array_unique(array_column($timekeeping, 'class_id'));

                // Gốp danh sách ID lại để có ds lớp cuối cùng bao gồm lớp đang map và lớp đã từng dạy
                $listIdClassFinal = array_unique(array_merge($classIdMap, $taughtClasses));

                if(!empty($listIdClassFinal)) {
                    // lấy danh sách lớp của gv đang dạy trong tháng
                    $listClass = $ClassTb->listItem(array(
                        'list_id' => $listIdClassFinal,
                        'orderby' => 'class.id ASC',
                        'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                    ));

                    // Lấy danh sách chấm công của gv đang dạy cho từng lớp
                    foreach ($listClass as $k => $value) {
                        $listCheckin = [];
                        foreach ($timekeeping as $item) {
                            if($item['class_id'] == $value['id']) {
                                $listCheckin[] = $item['date_checkin'];
                            }
                        }
                        $listClass[$k]['timekeeping'] = $listCheckin;
                    }

                    // Duyệt qua từng lớp và gán danh sách ngày
                    foreach ($listClass as &$class) {
                        $updatedDaysArray = [];

                        foreach ($data['daysArray'] as $day) {
                            $status = "";
                            $checkin = 0;

                            // Xác định trạng thái
                            $makeupDate = json_decode($class["makeup_date"], true);
                            $offDate = json_decode($class["off_date"], true);
                            if (in_array($day["date"], $makeupDate)) {
                                $status = "Học bù";
                            } elseif (in_array($day["date"], $offDate)) {
                                $status = "OFF";
                            }

                            // Kiểm tra checkin
                            if (in_array($day["date"], $class["timekeeping"])) {
                                $checkin = 1;
                            }

                            $updatedDaysArray[] = [
                                "date" => $day["date"],
                                "current" => $day["current"],
                                "status" => $status,
                                "checkin" => $checkin
                            ];
                        }

                        // Thêm danh sách ngày vào lớp học
                        $class["days"] = $updatedDaysArray;
                    }

                    // Lọc các lớp có thời gian học nằm trong tháng lấy từ $_GET['month']
                    $listClass = array_filter($listClass, function ($class) use ($month, $year) {
                        $startDate = \DateTime::createFromFormat('d/m/Y', $class["start_date"]);
                        $endDate = \DateTime::createFromFormat('d/m/Y', $class["end_date"]);

                        if (!$startDate || !$endDate) return false; // Bỏ qua nếu ngày không hợp lệ

                        // Lấy danh sách các ngày học bù
                        $makeupDays = isset($class["makeup_date"]) ? json_decode($class["makeup_date"], true) : [];

                        // Kiểm tra nếu có ngày học bù trong tháng đang xét
                        $hasMakeupInMonth = array_filter($makeupDays, function ($date) use ($month, $year) {
                            $makeupDate = \DateTime::createFromFormat('d/m/Y', $date);
                            return $makeupDate && $makeupDate->format('n') == $month && $makeupDate->format('Y') == $year;
                        });

                        // Xác định phạm vi tháng cần kiểm tra
                        $monthStart = new \DateTime("$year-$month-01");
                        $monthEnd = clone $monthStart;
                        $monthEnd->modify('last day of this month');

                        // Điều kiện lọc chính xác
                        return (
                            // Ngày bắt đầu hoặc ngày kết thúc nằm trong tháng
                            ($startDate->format('n') == $month && $startDate->format('Y') == $year) ||
                            ($endDate->format('n') == $month && $endDate->format('Y') == $year) ||
                            // Khoảng thời gian lớp học bao phủ ít nhất một ngày trong tháng
                            ($startDate <= $monthEnd && $endDate >= $monthStart) ||
                            // Có ít nhất một ngày học bù trong tháng
                            !empty($hasMakeupInMonth)
                        );
                    });

                    // Kiểm tra xem GV có đủ điều kiện chấm lương trong tháng
                    if($listClass) {
                        $data['qualifiedTeachers']++;
                        $data['listTeacher'][$i]['qualifiedTeachers'] = true;
                    }

                    // Duyệt qua từng lớp học
                    foreach ($listClass as &$class) {
                        $totalDaysTaught = 0;

                        // Duyệt qua danh sách ngày của lớp
                        foreach ($class['days'] as $day) {
                            $dateParts = explode("/", $day['date']); // Tách ngày/tháng/năm
                            $dayMonth = (int)$dateParts[1]; // Lấy tháng
                            $dayYear = (int)$dateParts[2]; // Lấy năm

                            // Kiểm tra nếu ngày thuộc tháng & năm cần tính và có checkin
                            if ($dayMonth == $month && $dayYear == $year && $day['checkin'] > 0) {
                                $totalDaysTaught++;
                            }
                        }

                        // Thêm số ngày đã dạy vào mảng dữ liệu của lớp
                        $class['total_days_taught'] = $totalDaysTaught;
                    }

                    $listClass = array_values($listClass);

                    // Tính lương cho từng giáo viên
                    $totalSalaries = $totalTeaching = $totalTeachingAfterTax = $totalOfClass = 0;
                    foreach ($listClass as $value) {
                        $totalOfClass = $value['session_salaries'] * $value['total_days_taught'];
                        $totalTeaching += $totalOfClass;
                    }

                    $ConfigTb = new ConfigTb();
                    $config = $ConfigTb->getItem(array('id' => 1));

                    $SalariesTb = new SalariesTb();
                    $upsell = $SalariesTb->getItem(array(
                        'teacher_id' => $teacher['id'],
                        'month' => $month.'/'.$year
                    ));

                    if($teacher['time_work'] == 2 && $config['tax'] && $config['tax'] > 0) {
                        $totalTeachingAfterTax = $totalTeaching * ((100 - $config['tax']) / 100);
                        $data['listTeacher'][$i]['tax'] = $config['tax'];
                    }

                    $totalUpsell = $totalOther = 0;
                    foreach ($upsell['upsell'] as $value) {
                        $quantity = $value['quantity'] && $value['quantity'] > 0 ? $value['quantity'] : 1;
                        $money = str_replace('.','', $value['money']);
                        $totalUpsell += $money * $quantity;
                    }

                    $totalOther = str_replace('.','', $upsell['print']) + str_replace('.','', $upsell['zoom']) + str_replace('.','', $upsell['other']);
                    $totalSalaries = ($totalTeachingAfterTax ? $totalTeachingAfterTax : $totalTeaching) + $totalUpsell + $totalOther;

                    $data['listTeacher'][$i]['totalTeaching'] = $totalTeaching;
                    $data['listTeacher'][$i]['totalTeachingAfterTax'] = $totalTeachingAfterTax;
                    $data['listTeacher'][$i]['totalUpsell'] = $totalUpsell;
                    $data['listTeacher'][$i]['totalOther'] = $totalOther;
                    $data['listTeacher'][$i]['totalSalaries'] = $totalSalaries;
                }
            }

            if($data['qualifiedTeachers'] > 0) {
                $exportArray[] = ['Họ và tên','Số tài khoản','Hình thức','Lương dạy','Thuế','Lương sau thuế','Tiền upsell','Tiền khác','Tổng lương'];
                foreach ($data['listTeacher'] as $i => $teacher) {
                    if($teacher['qualifiedTeachers']) {
                        $exportArray[] = [
                            $teacher['fullname'],
                            $teacher['bank_full'],
                            $teacher['time_work'] == 2 ? 'Part time':'Full time',
                            $teacher['totalTeaching'],
                            $teacher['tax'] ? (int)$teacher['tax'] : 0,
                            $teacher['totalTeachingAfterTax'],
                            $teacher['totalUpsell'],
                            $teacher['totalOther'],
                            $teacher['totalSalaries']
                        ];
                    }
                }
            }

            echo json_encode(array(
                'fileName' => 'Lương-Giáo-Viên-Tháng-'.($month > 10 ? $month : '0'.$month).'-'.$year.'.xlsx',
                'sheetName' => 'Tháng '.($month > 10 ? $month : '0'.$month).'-'.$year,
                'exportArray' => $exportArray
            ));

            return $this->getResponse();

            //End code
        }
        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }

    public function ajax97Action()
    {
        $data = array();
        $params = $this->params()->fromRoute();
        if ($this->getRequest()->isPost()) {

            //Begin code

            $params = array_merge($params, $this->getRequest()->getPost()->toArray());

            $MemberTb = new MemberTb();
            $ClassTb = new ClassTb();
            $StudentTb = new StudentTb();

            $StudentTb->saveData(array(
                'id' => $params['student_id'],
                'post' => array('complete_course' => $params['complete_course'])
            ));

            return $this->getResponse();

            //End code
        }
        $view = new ViewModel($data);
        return $view->setTerminal(true);
    }
}

?>