<?php
namespace Frontend\Controller;

use Frontend\Model\ContactTb;
use Frontend\Model\InfoTb;
use Frontend\Model\MemberTb;
use Frontend\Model\ClassTb;
use Frontend\Model\StudentAttendancesTb;
use Frontend\Controller\MemberController;
use Frontend\View\Helper\WriteLog;
use Zend\Mvc\Controller\AbstractRestfulController;
use Zend\Session\Container;
use Zend\View\Model\ViewModel;

class CronJobController extends AbstractRestfulController
{
    public function get($id)
    {
        $response = $this->getResponseWithHeader()
                         ->setContent( __METHOD__.' get current data with id =  '.$id);
        return $response;
    }

    public function getList()
    {
        if($_REQUEST['code'] == 'ebed149e32ef956d361245d7b34c98a6') {
            $ClassTb = new ClassTb();
            $MemberController = new MemberController();
            $listClass = $ClassTb->listItem(array('status' => 1));

            // lưu lại log Class
            $logCheck = array();

            foreach ($listClass as $classItem) {
                // tạo ra các buổi học
                $dateOfWeek = json_decode($classItem['day_of_week'], true) ? json_decode($classItem['day_of_week'], true) : [];
                $makeupDate = json_decode($classItem['makeup_date'], true) ? json_decode($classItem['makeup_date'], true) : [];
                $offDate = json_decode($classItem['off_date'], true) ? json_decode($classItem['off_date'], true) : [];

                $scheduleList = $MemberController->generateSchedule($classItem['start_date'], $classItem['end_date'], $dateOfWeek, $makeupDate, $offDate);

                $studentList = $MemberController->sortStudentsByName($MemberController->listStudent(array(
                    'class_id' => $classItem['id'],
                    'status' => 1
                )));

                $log = array(
                    'classID' => $classItem['id'],
                    'className' => $classItem['name'],
                );

                if($studentList) {
                    $StudentAttendancesTb = new StudentAttendancesTb();
                    foreach ($studentList as $i => $student) {
                        $studentList[$i]['checkin'] = [];
                        foreach ($scheduleList as $j => $item) {
                            $studentAttendances = $StudentAttendancesTb->getItem(array(
                                'student_id' => $student['id'],
                                'class_id' => $classItem['id'],
                                'session_date' => $item['date']
                            ));

                            $studentList[$i]['checkin'][str_replace('/','-', $item['date'])] = array(
                                'label' => $item['label'],
                                'date' => $item['date'],
                                'active' => $item['active'],
                                'active_next' => $item['active_next'],
                                'off' => $item['off']
                            );

                            if($studentAttendances['id']) {
                                $studentList[$i]['checkin'][str_replace('/','-', $item['date'])]['checkInName'] = $studentAttendances['checkin'];
                            }
                        }
                    }

                    foreach ($scheduleList as $i => $item) {
                        $checkin = [];
                        foreach ($studentList as $j => $student) {
                            $checkin[] = array(
                                'id' => $student['id'],
                                'fullname' => $student['fullname'],
                                'checkInName' => $student['checkin'][str_replace('/','-', $item['date'])]['checkInName'],
                                'off' => $item['off']
                            );
                        }

                        $countTotalAbsent = 0;
                        foreach ($checkin as $value) {
                            if($value['checkInName'] && !$value['off'])
                                $countTotalAbsent++;
                        }
                        $scheduleList[$i]['totalAbsent'] = $countTotalAbsent;
                        $scheduleList[$i]['totalStudent'] = count($studentList);
                    }

                    // lấy ra ngày active và ngày đó không OFF
                    $indexActive = array_search(1, array_column($scheduleList, 'active'));

                    if($indexActive) {
                        if($scheduleList[$indexActive]['totalAbsent'] != $scheduleList[$indexActive]['totalStudent'] && !$scheduleList[$indexActive]['off']) {

                            $InfoTb = new InfoTb();
                            $data['info'] = $InfoTb->getItem();

                            $template = array(
                                'subject' => '[[[domain]]] Thông báo: Lớp học [[lop-hoc]] của bạn chưa hoàn tất điểm danh học viên',
                                'key' => array('[[domain]]','[[ten-giao-vien]]','[[lop-hoc]]'),
                                'value' => array(
                                    DOMAIN,
                                    $classItem['teacher_name'],
                                    $classItem['name']
                                ),
                                'body' => '<p style="border-bottom: 1px solid #eee;"><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank"><img height="43" src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'" style="width: 140px;" /></a></span></span></p>
                                    <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Chào bạn <strong>[[ten-giao-vien]]</strong>,</span></span></p>
                                    <p style="margin-bottom: 10px;"><font color="#1f4e79" face="Times New Roman, Times, serif"><span style="font-size: 16px;"><b><i>Lớp học [[lop-hoc]] của bạn chưa hoàn tất điểm danh ngày hôm nay.</i></b></span></font></p>
                                    <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Vui lòng đăng nhập tài khoản của bạn vào hệ thống <a href="[[domain]]" target="_blank">'.$data['info']['name'].'</a> hoàn tất việc điểm danh cho học viên <br> để hệ thống thực hiện chấm công cho buổi học của bạn ngày '.$scheduleList[$indexActive]['date'].' <span style="color: #f00">trước 23 giờ 30 phút</span> hôm nay nhé.</span></span></em></strong></span></p>
                                    <p style="margin-top: 0;"><span style="font-family:Times New Roman,Times,serif;font-size:16px;"><em><strong>* <u>Ghi chú</u>:</strong> Đây là email thông báo tự động. Vui lòng không phản hồi lại email này!</em></span></p>'
                            );

                            $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                                'emailTo' => $classItem['teacher_email'],
                                'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                                'body' => str_replace($template['key'], $template['value'], $template['body'])
                            ));

                            $log['check'] = $scheduleList[$indexActive];
                        } else {
                            $log['check'] = 'Lớp đã điểm danh hết';
                        }
                    } else {
                        $log['check'] = 'Không có buổi học hôm nay';
                    }
                }

                $logCheck[] = $log;
            }

            $WriteLog = new WriteLog();
            $WriteLog->Write($logCheck);
        } else if($_REQUEST['code'] == 'ebed149e32ef956d361245d7b34c98a6class') {
            $ClassTb = new ClassTb();
            $listClass = $ClassTb->listItem(array('status' => 1));
            $logCheck = array();

            date_default_timezone_set('Asia/Ho_Chi_Minh'); // đảm bảo đúng timezone
            $today = \DateTime::createFromFormat('d/m/Y', date('d/m/Y'));

            foreach ($listClass as $class) {
                $endDate = \DateTime::createFromFormat('d/m/Y', $class['end_date']);
                $makeupDates = json_decode($class['makeup_date'], true) ?? [];

                $latestMakeupDate = null;
                $hasFutureMakeup = false;

                foreach ($makeupDates as $date) {
                    $makeupDate = \DateTime::createFromFormat('d/m/Y', $date);
                    if ($makeupDate && $makeupDate > $today) {
                        $hasFutureMakeup = true;
                    }

                    if ($latestMakeupDate === null || $makeupDate > $latestMakeupDate) {
                        $latestMakeupDate = $makeupDate;
                    }
                }

                if ($today < $endDate) {
                    $logCheck[] = "Lớp {$class['name']} chưa hoàn thành (chưa đến ngày kết thúc: " . $endDate->format('d/m/Y') . ")";
                } elseif ($today > $endDate) {
                    if ($hasFutureMakeup) {
                        $logCheck[] = "Lớp {$class['name']} chưa hoàn thành (còn học bù vào: " . $latestMakeupDate->format('d/m/Y') . ")";
                    } else {
                        $logCheck[] = "Lớp {$class['name']} đã hoàn thành vào ngày " . $endDate->format('d/m/Y') . "[update status = 2]";

                        // Cập nhật trạng thái Hoàn thành cho lớp đó
                        $ClassTb->saveData(array('id' => $class['id'], 'post' => ['status' => 2, 'system' => true]));
                    }
                } else {
                    // nếu hôm nay đúng bằng ngày kết thúc
                    $logCheck[] = "Lớp {$class['name']} kết thúc hôm nay (" . $endDate->format('d/m/Y') . "), chờ cập nhật học bù nếu có.";
                }
            }

            $WriteLog = new WriteLog();
            $WriteLog->Write($logCheck);
        } else {
            $response = $this->getResponseWithHeader()
            ->setContent(json_encode(array('error' => 'Invalid data')));
        }

        return $this->getResponse();
    }

    public function create($data)
    {
        $response = $this->getResponseWithHeader()
                         ->setContent( __METHOD__.' create new item of data :
                                                    <b>'.$data['name'].'</b>');
        return $response;
    }

    public function update($id, $data)
    {
       $response = $this->getResponseWithHeader()
                        ->setContent(__METHOD__.' update current data with id =  '.$id.
                                            ' with data of name is '.$data['name']) ;
       return $response;
    }

    public function delete($id)
    {
        $response = $this->getResponseWithHeader()
                        ->setContent(__METHOD__.' delete current data with id =  '.$id) ;
        return $response;
    }

    // configure response
    public function getResponseWithHeader()
    {
        $response = $this->getResponse();
        $response->getHeaders()
                 //make can accessed by *
                 ->addHeaderLine('Access-Control-Allow-Origin','*')
                 //set allow methods
                 ->addHeaderLine('Access-Control-Allow-Methods','POST PUT DELETE GET');

        return $response;
    }

    public function isAllowed($ip){
        $whitelist = array( '113.160.92.202', '113.52.45.78','42.118.107.252','113.20.97.250','203.171.19.146','103.220.87.4', '116.97.245.130','103.220.86.4');

        // If the ip is matched, return true
        if(in_array($ip, $whitelist)) {
            return true;
        }

        foreach($whitelist as $i){
            $wildcardPos = strpos($i, "*");

            // Check if the ip has a wildcard
            if($wildcardPos !== false && substr($ip, 0, $wildcardPos) . "*" == $i) {
                return true;
            }
        }

        return false;
    }
}

?>