<?php

namespace Frontend\Controller;

use Frontend\Model\BannerTb;
use Frontend\Model\InfoTb;
use Frontend\Model\MenuPublicTb;
use Zend\Mvc\Controller\AbstractActionController;
use Zend\View\Model\ViewModel;
use Zend\Session\Container;

class IndexController extends AbstractActionController
{
	public function indexAction()
    {
        if ($this->getResponse()->getContent()) {
            return new ViewModel($this->getResponse()->getContent());
        }

        //Begin code

        $data = array(
            'action' => 'home',
            'active' => 'home',
        );

        $this->_session = new Container('frontend');
        if ($this->_session->logged) {
            switch ($this->_session->logged['role']) {
                case 1:
                    $redirect = URL.'master-consultant-77.html';
                    break;
                case 2:
                case 3:
                    $redirect = URL.'consultant-78.html';
                    break;
                case 4:
                    $redirect = URL.'accountant-79.html';
                    break;
                default:
                    $redirect = URL.'teacher-76.html';
                    break;
            }
            return $this->redirect()->toUrl($redirect);
        }

        //End code

        // SEO || SNIPPET
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = $MenuPublicTb->getItem(array('active' => $data['active'], 'columns' => array('name','title','keyword','description','link','active','detail')));

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'name' => $data['menu']['name'],
            'title' => $data['menu']['title'],
            'keyword' => $data['menu']['keyword'],
            'description' => $data['menu']['description'],
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => array($data['menu']),
        ));

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = array('vi' => '','en' => 'en/'); // Nếu có ngôn ngữ LANG

        $this->getResponse()->setContent($data);
    	return new ViewModel($data);
    }
}

?>