<?php

namespace Frontend\Controller;

use Frontend\Model\ConfigTb;
use Frontend\Model\RoleTb;
use Frontend\Model\InfoTb;
use Frontend\Model\MemberTb;
use Frontend\Model\ClassTb;
use Frontend\Model\TimekeepingTb;
use Frontend\Model\NotificationTb;
use Frontend\Model\StudentTb;
use Frontend\Model\SalariesTb;
use Frontend\Model\StudentAttendancesTb;
use Frontend\Model\MenuPublicTb;
use Frontend\View\Helper\generateSchedule;
use Zend\Authentication\AuthenticationService;
use Zend\Mvc\Controller\AbstractActionController;
use Zend\Session\Container;
use Zend\View\Model\ViewModel;

class MemberController extends AbstractActionController
{
    protected $_session = '';
    protected $_listSidebar;

    public function onDispatch(\Zend\Mvc\MvcEvent $e)
    {
        $this->_session = new Container('frontend');
        if (!$this->_session->logged && !$_POST['email']) {
            return $this->redirect()->toUrl(URL_LANG);
        } else {
            $MemberTb = new MemberTb();
            $member = $MemberTb->getItem(array(
                'id' => $this->_session->logged['id'],
                'columns' => array('status')
            ));

            if($member['status'] != 1) {
                $this->_session->offsetSet('logged', '');
            }

            $pathCurrent = explode('/',$_SERVER['REDIRECT_URL'])[count(explode('/',$_SERVER['REDIRECT_URL']))-1];
            if(!in_array($pathCurrent, array('profile-71.html','login-73.html','logout-74.html','password-75.html','check-80.html','download-70.html'))) {
                switch ($this->_session->logged['role']) {
                    case 2:
                        $pathRedirect = 'master-consultant-77.html';
                        break;
                    case 3:
                    case 4:
                        $pathRedirect = 'consultant-78.html';
                        break;
                    case 5:
                        $pathRedirect = 'accountant-79.html';
                        break;
                    default:
                        $pathRedirect = 'teacher-76.html';
                        break;
                }

                if($pathCurrent != $pathRedirect) {
                    return $this->redirect()->toUrl(URL.$pathRedirect);
                }
            }
        }

        $this->_listSidebar = array(
            1 => [
                'class' => ['icon' => 'fa-book', 'name' => 'Danh sách lớp học', 'link' => 'teacher-76.html?action=class'],
                'wage' => ['icon' => 'fa-table', 'name' => 'Bảng công', 'link' => 'teacher-76.html?action=wage'],
                'support' => ['icon' => 'fa-pencil-square-o', 'name' => 'Hỗ trợ', 'link' => 'teacher-76.html?action=support'],
                'notify' => ['icon' => 'fa-flag-o', 'name' => 'Thông báo', 'link' => 'teacher-76.html?action=notify']
            ],
            2 => [
                'class' => ['icon' => 'fa-book', 'name' => 'Danh sách lớp học', 'link' => 'master-consultant-77.html?action=class'],
                'teacher' => ['icon' => 'fa-address-book-o', 'name' => 'Danh sách giáo viên', 'link' => 'master-consultant-77.html?action=teacher'],
                'student' => ['icon' => 'fa-users', 'name' => 'Danh sách học viên', 'link' => 'master-consultant-77.html?action=student'],
                'account' => ['icon' => 'fa-user-plus', 'name' => 'Danh sách tài khoản', 'link' => 'master-consultant-77.html?action=account'],
                'notify' => ['icon' => 'fa-flag-o', 'name' => 'Tất cả thông báo', 'link' => 'master-consultant-77.html?action=notify'],
                'config' => ['icon' => 'fa-cog', 'name' => 'Cấu hình thông tin', 'link' => 'master-consultant-77.html?action=config'],
            ],
            3 => [
                'class' => ['icon' => 'fa-book', 'name' => 'Danh sách lớp học', 'link' => 'consultant-78.html?action=class'],
                'teacher' => ['icon' => 'fa-address-book-o', 'name' => 'Danh sách giáo viên', 'link' => 'consultant-78.html?action=teacher'],
                'student' => ['icon' => 'fa-users', 'name' => 'Danh sách học viên', 'link' => 'consultant-78.html?action=student'],
                'notify' => ['icon' => 'fa-flag-o', 'name' => 'Thông báo', 'link' => 'consultant-78.html?action=notify']
            ],
            4 => [
                'class' => ['icon' => 'fa-book', 'name' => 'Danh sách lớp học', 'link' => 'consultant-78.html?action=class'],
                'teacher' => ['icon' => 'fa-address-book-o', 'name' => 'Danh sách giáo viên', 'link' => 'consultant-78.html?action=teacher'],
                'student' => ['icon' => 'fa-users', 'name' => 'Danh sách học viên', 'link' => 'consultant-78.html?action=student'],
                'notify' => ['icon' => 'fa-flag-o', 'name' => 'Thông báo', 'link' => 'consultant-78.html?action=notify']
            ],
            5 => [
                'payment' => ['icon' => 'fa-money', 'name' => 'Thanh toán công', 'link' => 'accountant-79.html'],
            ]
        );

        return parent::onDispatch($e);
    }

    public function profileAction() // 71.html
    {
        $params = $this->params()->fromRoute();
        $translator = $this->getServiceLocator()->get('translator');
        $data = array('action' => 'profile');

        $session = new Container('frontend');
        $MemberTb = new MemberTb();
        $data['member'] = $MemberTb->getItem(array(
            'id' => $this->_session->logged['id'],
            'columns' => array('id','email','fullname','thumbnail','phone','address','birthday','sex','role','bank_number','bank_name','bank_owner')
        ));

        $data['listSidebar'] = $this->_listSidebar[$data['member']['role']];

        if ($this->getRequest()->isPost()) {
            $params['id'] = $this->_session->logged['id'];
            $params['post'] = $this->getRequest()->getPost()->toArray();
            $params['post']['email'] = $this->_session->logged['email'];

            // lưu thumbnail
            $time = strtotime(date('Y-m-d H:i:s'));
            if (!empty($_FILES['thumbnail']['name'])) {
                $filename = $time.'-'.$_FILES['thumbnail']['name'];

                //Tạo thư mục chứa hình ảnh theo Năm
                $pathFolder = ROOT_PUBLIC.'/'.UPLOAD_IMAGES.date('Y',time());
                mkdir($pathFolder);
                // Tạo thư mục chứa hình ảnh theo Tháng
                $pathFolder = $pathFolder.'/'.date('m',time());
                mkdir($pathFolder);

                move_uploaded_file($_FILES['thumbnail']['tmp_name'], ROOT_PUBLIC.'/'.UPLOAD_IMAGES.date('Y/m',explode('-', $filename)[0]).'/'.$filename);
                $params['post']['thumbnail'] = $filename;
            }

            // xóa ảnh cũ
            if($params['post']['thumbnail'] && $data['member']['thumbnail']) {
                if(file_exists(ROOT_PUBLIC.'/'.UPLOAD_IMAGES.date('Y/m',explode('-', $data['member']['thumbnail'])[0]).'/'.$data['member']['thumbnail']) && is_file(ROOT_PUBLIC.'/'.UPLOAD_IMAGES.date('Y/m',explode('-', $data['member']['thumbnail'])[0]).'/'.$data['member']['thumbnail'])) {
                    unlink(ROOT_PUBLIC.'/'.UPLOAD_IMAGES.date('Y/m',explode('-', $data['member']['thumbnail'])[0]).'/'.$data['member']['thumbnail']);
                }
            }

            $MemberTb->saveData($params);
            $this->_session->logged = array_merge($this->_session->logged, $params['post']);

            echo json_encode(array('redirect' => URL.'profile-71.html?ifchanged'));
            return $this->response;
        }

        // SEO || SNIPPET
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = array(
            'action' => 'profile',
            'name' => $translator->translate("Thông tin tài khoản"),
            'title' => $translator->translate("Thông tin tài khoản")
        );

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'title' => $translator->translate("Thông tin tài khoản"),
            'keyword' => $translator->translate("Thông tin tài khoản"),
            'description' => $translator->translate("Thông tin tài khoản"),
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => $data['menu'],
            'noindex' => true
        ));

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = array('vi' => 'thong-tin-tai-khoan', 'en' => 'en/account-info'); // Nếu có ngôn ngữ LANG

        return new ViewModel($data);
    }

    public function teacherAction() // 76.html
    {
        $params = $this->params()->fromRoute();
        $translator = $this->getServiceLocator()->get('translator');
        $data = array('action' => 'teacher');

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $session = new Container('frontend');
        $MemberTb = new MemberTb();
        $ClassTb = new ClassTb();
        $StudentTb = new StudentTb();
        $SalariesTb = new SalariesTb();
        $TimekeepingTb = new TimekeepingTb();
        $NotificationTb = new NotificationTb();
        $data['member'] = $MemberTb->getItem(array(
            'id' => $this->_session->logged['id'],
            'columns' => array('id','email','fullname','thumbnail','phone','address','birthday','sex','role','bank_number','bank_name','bank_owner')
        ));

        $data['listSidebar'] = $this->_listSidebar[$data['member']['role']];

        switch ($_GET['action']) {
            case 'wage':
                // Lấy ngày hiện tại
                $currentDay = date("j");
                $currentMonth = date("n");
                $currentYear = date("Y");

                // Lấy tháng & năm từ URL hoặc dùng tháng hiện tại
                $month = $currentMonth;
                $year = $currentYear;

                if (isset($_GET['month']) && preg_match('/^(0[1-9]|1[0-2])-\d{4}$/', $_GET['month'])) {
                    list($month, $year) = explode('-', $_GET['month']);
                    $month = (int)$month;
                    $year = (int)$year;
                }

                // Xác định số ngày trong tháng
                $totalDays = ($month == 2) ? (($year % 4 == 0 && ($year % 100 != 0 || $year % 400 == 0)) ? 29 : 28)
                            : cal_days_in_month(CAL_GREGORIAN, $month, $year);

                // Tạo danh sách ngày trong tháng
                $data['daysArray'] = [];
                for ($i = 1; $i <= $totalDays; $i++) {
                    $data['daysArray'][] = [
                        "date" => sprintf("%02d/%02d/%04d", $i, $month, $year), // Định dạng DD/MM/YYYY
                        "current" => ($i == $currentDay && $month == $currentMonth && $year == $currentYear),
                        "status" => "", // Mặc định rỗng
                        "checkin" => 0  // Mặc định chưa checkin
                    ];
                }

                $data['teacher'] = $MemberTb->getItem(array('id' => $data['member']['id']));

                if($data['teacher']['id']) {
                    // lấy danh sách lớp của gv đang dạy trong tháng
                    $listClassMap = $ClassTb->listItem(array(
                        'teacher_id' => $data['teacher']['id'],
                        'orderby' => 'class.id ASC',
                        'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                    ));

                    //  Lấy danh sách chấm công của GV
                    $timekeeping = $TimekeepingTb->listItem(array(
                        'teacher_id' => $data['teacher']['id'],
                        'columns' => array('class_id','teacher_id','date_checkin')
                    ));

                    // Danh sách id lớp đang map với GV
                    $classIdMap = array_unique(array_column($listClassMap, 'id'));

                    // Lấy danh sách lớp mà GV đó đã từng dạy (tính luôn trường hợp đang dạy mà ngừng hoặc chuyển lớp khác)
                    $taughtClasses = array_unique(array_column($timekeeping, 'class_id'));

                    // Gốp danh sách ID lại để có ds lớp cuối cùng bao gồm lớp đang map và lớp đã từng dạy
                    $listIdClassFinal = array_unique(array_merge($classIdMap, $taughtClasses));

                    if(!empty($listIdClassFinal)) {
                        // lấy danh sách lớp của gv đang dạy trong tháng
                        $data['listClass'] = $ClassTb->listItem(array(
                            'list_id' => $listIdClassFinal,
                            'orderby' => 'class.id ASC',
                            'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                        ));

                        // Lấy danh sách chấm công của gv đang dạy cho từng lớp
                        foreach ($data['listClass'] as $i => $value) {
                            $listCheckin = [];
                            foreach ($timekeeping as $j => $item) {
                                if($item['class_id'] == $value['id']) {
                                    $listCheckin[] = $item['date_checkin'];
                                }
                            }
                            $data['listClass'][$i]['timekeeping'] = $listCheckin;
                        }

                        // Duyệt qua từng lớp và gán danh sách ngày
                        foreach ($data['listClass'] as &$class) {
                            $updatedDaysArray = [];

                            foreach ($data['daysArray'] as $day) {
                                $status = "";
                                $checkin = 0;

                                // Xác định trạng thái
                                $makeupDate = json_decode($class["makeup_date"], true);
                                $offDate = json_decode($class["off_date"], true);
                                if (in_array($day["date"], $makeupDate)) {
                                    $status = "Học bù";
                                } elseif (in_array($day["date"], $offDate)) {
                                    $status = "OFF";
                                }

                                // Kiểm tra checkin
                                if (in_array($day["date"], $class["timekeeping"])) {
                                    $checkin = 1;
                                }

                                $updatedDaysArray[] = [
                                    "date" => $day["date"],
                                    "current" => $day["current"],
                                    "status" => $status,
                                    "checkin" => $checkin
                                ];
                            }

                            // Thêm danh sách ngày vào lớp học
                            $class["days"] = $updatedDaysArray;
                        }

                        // Lọc các lớp có thời gian học nằm trong tháng lấy từ $_GET['month']
                        $data['listClass'] = array_filter($data['listClass'], function ($class) use ($month, $year) {
                            $startDate = \DateTime::createFromFormat('d/m/Y', $class["start_date"]);
                            $endDate = \DateTime::createFromFormat('d/m/Y', $class["end_date"]);

                            if (!$startDate || !$endDate) return false; // Bỏ qua nếu ngày không hợp lệ

                            // Lấy danh sách các ngày học bù
                            $makeupDays = isset($class["makeup_date"]) ? json_decode($class["makeup_date"], true) : [];

                            // Kiểm tra nếu có ngày học bù trong tháng đang xét
                            $hasMakeupInMonth = array_filter($makeupDays, function ($date) use ($month, $year) {
                                $makeupDate = \DateTime::createFromFormat('d/m/Y', $date);
                                return $makeupDate && $makeupDate->format('n') == $month && $makeupDate->format('Y') == $year;
                            });

                            // Xác định phạm vi tháng cần kiểm tra
                            $monthStart = new \DateTime("$year-$month-01");
                            $monthEnd = clone $monthStart;
                            $monthEnd->modify('last day of this month');

                            // Điều kiện lọc chính xác
                            return (
                                // Ngày bắt đầu hoặc ngày kết thúc nằm trong tháng
                                ($startDate->format('n') == $month && $startDate->format('Y') == $year) ||
                                ($endDate->format('n') == $month && $endDate->format('Y') == $year) ||
                                // Khoảng thời gian lớp học bao phủ ít nhất một ngày trong tháng
                                ($startDate <= $monthEnd && $endDate >= $monthStart) ||
                                // Có ít nhất một ngày học bù trong tháng
                                !empty($hasMakeupInMonth)
                            );
                        });

                        // Duyệt qua từng lớp học
                        foreach ($data['listClass'] as &$class) {
                            $totalDaysTaught = 0;

                            // Duyệt qua danh sách ngày của lớp
                            foreach ($class['days'] as $day) {
                                $dateParts = explode("/", $day['date']); // Tách ngày/tháng/năm
                                $dayMonth = (int)$dateParts[1]; // Lấy tháng
                                $dayYear = (int)$dateParts[2]; // Lấy năm

                                // Kiểm tra nếu ngày thuộc tháng & năm cần tính và có checkin
                                if ($dayMonth == $month && $dayYear == $year && $day['checkin'] > 0) {
                                    $totalDaysTaught++;
                                }
                            }

                            // Thêm số ngày đã dạy vào mảng dữ liệu của lớp
                            $class['total_days_taught'] = $totalDaysTaught;
                        }

                        $data['listClass'] = array_values($data['listClass']);
                    }
                }

                $ConfigTb = new ConfigTb();
                $data['config'] = $ConfigTb->getItem(array('id' => 1));

                $data['upsell'] = $SalariesTb->getItem(array(
                    'teacher_id' => $data['teacher']['id'],
                    'month' => $month.'/'.$year
                ));

                break;
            case 'support':
                    $data['class'] = $ClassTb->listItem(array('teacher_id' => $data['member']['id']));
                break;
            case 'notify':
                    $data['listNotify'] = $NotificationTb->listItem(array(
                        'user_open' => $data['member']['id'],
                        'status' => $_GET['status'] == 1 ? 1 : 2
                    ));

                    foreach ($data['listNotify'] as $i => $value) {
                        $reply = $NotificationTb->listItem(array('parent' => $value['id'], 'orderby' => 'notify.id ASC'));
                        $data['listNotify'][$i]['reply'] = $reply;
                    }
                break;
            default:
                if($_GET['id']) {
                    $arrayClass = array(
                        'id' => $_GET['id'],
                        'teacher_id' => $data['member']['id']
                    );

                    $data['class'] = $ClassTb->getItem($arrayClass);

                    // tạo ra các buổi học
                    $makeupDate = json_decode($data['class']['makeup_date'], true) ? json_decode($data['class']['makeup_date'], true) : [];
                    $offDate = $data['class']['off_date'] ? $data['class']['off_date'] : [];
                    $data['schedule'] = $this->generateSchedule($data['class']['start_date'], $data['class']['end_date'], $data['class']['day_of_week'], $makeupDate, $offDate);

                    if($data['class']['id']) {
                        $data['student'] = $this->sortStudentsByName($this->listStudent(array(
                            'class_id' => $data['class']['id'],
                            'status' => 1
                        )));

                        if($data['student']) {
                            $StudentAttendancesTb = new StudentAttendancesTb();
                            foreach ($data['student'] as $i => $student) {
                                $data['student'][$i]['checkin'] = [];
                                foreach ($data['schedule'] as $j => $schedule) {
                                    $studentAttendances = $StudentAttendancesTb->getItem(array(
                                        'student_id' => $student['id'],
                                        'class_id' => $data['class']['id'],
                                        'session_date' => $schedule['date']
                                    ));

                                    $data['student'][$i]['checkin'][str_replace('/','-', $schedule['date'])] = array(
                                        'label' => $schedule['label'],
                                        'date' => $schedule['date'],
                                        'active' => $schedule['active'],
                                        'active_next' => $schedule['active_next'],
                                        'off' => $schedule['off']
                                    );

                                    if($studentAttendances['id']) {
                                        switch ($studentAttendances['checkin']) {
                                            case 'ĐH':
                                                $classNameHTML = 'present-color';
                                                break;
                                            case 'CP':
                                                $classNameHTML = 'cp-color';
                                                break;
                                            default:
                                                $classNameHTML = 'absence-color';
                                                break;
                                        }

                                        $data['student'][$i]['checkin'][str_replace('/','-', $schedule['date'])]['checkInName'] = $studentAttendances['checkin'];
                                        $data['student'][$i]['checkin'][str_replace('/','-', $schedule['date'])]['className'] = $classNameHTML;
                                    }
                                }

                                $listCheckin = $data['student'][$i]['checkin'];
                                $countAbsent = 0;
                                foreach ($listCheckin as $value) {
                                    if($value['checkInName']) {
                                        if($value['checkInName'] != 'ĐH' && !$value['off'])
                                            $countAbsent++;
                                    }
                                }

                                $data['student'][$i]['totalAbsent'] = $countAbsent;
                            }

                            foreach ($data['schedule'] as $i => $schedule) {
                                $checkin = [];
                                foreach ($data['student'] as $j => $student) {
                                    $checkin[] = array(
                                        'id' => $student['id'],
                                        'fullname' => $student['fullname'],
                                        'checkInName' => $student['checkin'][str_replace('/','-', $schedule['date'])]['checkInName'],
                                        'off' => $schedule['off']
                                    );
                                }

                                $countTotalAbsent = 0;
                                foreach ($checkin as $value) {
                                    if($value['checkInName'] && $value['checkInName'] != 'ĐH' && !$value['off'])
                                        $countTotalAbsent++;
                                }
                                $data['schedule'][$i]['totalAbsent'] = $countTotalAbsent;
                            }
                        }
                    }
                }

                $array = array(
                    'teacher_id' => $data['member']['id'],
                    'status' => $_GET['status'] == 2 ? 2 : 1,
                    'page' => isset($_GET['page']) ? $_GET['page'] : '',
                );

                // Xóa session khi truy cập vào link
                if (!isset($_GET['page']) || $_GET['page'] == 1) {
                    $session->offsetSet('keysearch', '');
                    $session->offsetSet('teacher_id', '');
                }

                if ($session->keysearch) {
                    $data['keysearch'] = $array['keysearch'] = $session->keysearch;
                }

                if ($session->teacher_id) {
                    $data['teacher_id'] = $array['teacher_id'] = $session->teacher_id;
                }

                $list = $this->listPageClass($array);
                $data['listClass'] = $list['list'];
                $data['paginator'] = $list['paginator'];
                $data['page'] = $list['params']['page'];

                break;
        }

        if ($this->getRequest()->isPost()) {
            $params['post'] = $this->getRequest()->getPost()->toArray();

            if($params['post']['type']) {
                switch ($params['post']['type']) {
                    case 'support':
                        $params['post']['user_open'] = $data['member']['id'];
                        $NotificationTb->saveData($params);

                        break;
                    case 'notify':
                        if($params['post']['action'] == 'reply') {
                            $params['post']['user_reply'] = $data['member']['id'];
                            $NotificationTb->saveData($params);

                            $roleName = in_array($data['member']['role'], [2,3,4]) ? '<span class="role">Tư vấn</span>':'';
                            $htmlReply = '<div class="noti-list_item-reply">
                                <h3>'.$data['member']['fullname'].$roleName.'</h3>
                                <p class="reply">'.$params['post']['content'].'</p>
                            </div>';

                            echo json_encode(array('addReply' => true, 'htmlReply' => $htmlReply, 'parent' => $params['post']['parent']));
                            return $this->response;
                        }

                        if($params['post']['action'] == 'close') {
                            $params['id'] = $params['post']['ticket'];
                            $params['post']['status'] = 1;
                            $NotificationTb->saveData($params);
                        }

                        break;
                    default:
                        if($params['post']['action'] == 'create' && $data['class']['id']) {
                            $params['post']['class_id'] = $data['class']['id'];
                            $params['post']['user_open'] = $data['member']['id'];
                            $NotificationTb->saveData($params);
                        }

                        break;
                }
            }

            echo json_encode(array('redirect' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'].(isset($_GET['action']) ? '&changed=true'.($params['post']['action'] ? '&support='.$params['post']['action']:'') : '?changed=true')));
            return $this->response;
        }

        // SEO || SNIPPET
        $name = $data['listSidebar'][($_GET['action'] ? $_GET['action'] : 'class')]['name'] ? $data['listSidebar'][($_GET['action'] ? $_GET['action'] : 'class')]['name'] : $data['listSidebar']['class']['name'];
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = array(
            'name' => $name,
            'title' => $name,
            'link' => 'teacher-76.html'
        );

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'title' => $name,
            'keyword' => $name,
            'description' => $name,
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => $data['menu'],
            'noindex' => true
        ));

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = array('vi' => 'thong-tin-tai-khoan', 'en' => 'en/account-info'); // Nếu có ngôn ngữ LANG

        return new ViewModel($data);
    }

    public function masterAction() // 77.html
    {
        $params = $this->params()->fromRoute();
        $translator = $this->getServiceLocator()->get('translator');
        $data = array('action' => 'master');

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $session = new Container('frontend');
        $MemberTb = new MemberTb();
        $ClassTb = new ClassTb();
        $TimekeepingTb = new TimekeepingTb();
        $StudentTb = new StudentTb();
        $SalariesTb = new SalariesTb();
        $NotificationTb = new NotificationTb();
        $data['member'] = $MemberTb->getItem(array(
            'id' => $this->_session->logged['id'],
            'columns' => array('id','email','fullname','thumbnail','phone','address','birthday','sex','role','bank_number','bank_name','bank_owner')
        ));

        $data['listSidebar'] = $this->_listSidebar[$data['member']['role']];

        switch ($_GET['action']) {
            case 'student':
                $array = array(
                    'limit' => 10,
                    'page' => isset($_GET['page']) ? $_GET['page'] : '',
                );

                // Xóa session khi truy cập vào link
                if (!isset($_GET['page']) || $_GET['page'] == 1) {
                    $session->offsetSet('keysearch', '');
                    $session->offsetSet('teacher_id', '');
                }

                if ($session->keysearch) {
                    $data['keysearch'] = $array['keysearch'] = $session->keysearch;
                }

                $list = $this->listPageStudent($array);
                $data['listStudent'] = $list['list'];
                $data['paginator'] = $list['paginator'];
                $data['page'] = $list['params']['page'];

                $data['class'] = $this->listClass();

                break;
            case 'teacher':
                if($_GET['wage']) {
                    // Lấy ngày hiện tại
                    $currentDay = date("j");
                    $currentMonth = date("n");
                    $currentYear = date("Y");

                    // Lấy tháng & năm từ URL hoặc dùng tháng hiện tại
                    $month = $currentMonth;
                    $year = $currentYear;

                    if (isset($_GET['month']) && preg_match('/^(0[1-9]|1[0-2])-\d{4}$/', $_GET['month'])) {
                        list($month, $year) = explode('-', $_GET['month']);
                        $month = (int)$month;
                        $year = (int)$year;
                    }

                    // Xác định số ngày trong tháng
                    $totalDays = ($month == 2) ? (($year % 4 == 0 && ($year % 100 != 0 || $year % 400 == 0)) ? 29 : 28)
                                : cal_days_in_month(CAL_GREGORIAN, $month, $year);

                    // Tạo danh sách ngày trong tháng
                    $data['daysArray'] = [];
                    for ($i = 1; $i <= $totalDays; $i++) {
                        $data['daysArray'][] = [
                            "date" => sprintf("%02d/%02d/%04d", $i, $month, $year), // Định dạng DD/MM/YYYY
                            "current" => ($i == $currentDay && $month == $currentMonth && $year == $currentYear),
                            "status" => "", // Mặc định rỗng
                            "checkin" => 0  // Mặc định chưa checkin
                        ];
                    }

                    $data['teacher'] = $MemberTb->getItem(array('id' => $_GET['wage']));

                    if($data['teacher']['id']) {
                        // lấy danh sách lớp của gv đang dạy trong tháng
                        $listClassMap = $ClassTb->listItem(array(
                            'teacher_id' => $data['teacher']['id'],
                            'orderby' => 'class.id ASC',
                            'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                        ));

                        //  Lấy danh sách chấm công của GV
                        $timekeeping = $TimekeepingTb->listItem(array(
                            'teacher_id' => $data['teacher']['id'],
                            'columns' => array('class_id','teacher_id','date_checkin')
                        ));

                        // Danh sách id lớp đang map với GV
                        $classIdMap = array_unique(array_column($listClassMap, 'id'));

                        // Lấy danh sách lớp mà GV đó đã từng dạy (tính luôn trường hợp đang dạy mà ngừng hoặc chuyển lớp khác)
                        $taughtClasses = array_unique(array_column($timekeeping, 'class_id'));

                        // Gốp danh sách ID lại để có ds lớp cuối cùng bao gồm lớp đang map và lớp đã từng dạy
                        $listIdClassFinal = array_unique(array_merge($classIdMap, $taughtClasses));

                        if(!empty($listIdClassFinal)) {
                            // lấy danh sách lớp của gv đang dạy trong tháng
                            $data['listClass'] = $ClassTb->listItem(array(
                                'list_id' => $listIdClassFinal,
                                'orderby' => 'class.id ASC',
                                'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                            ));

                            // Lấy danh sách chấm công của gv đang dạy cho từng lớp
                            foreach ($data['listClass'] as $i => $value) {
                                $listCheckin = [];
                                foreach ($timekeeping as $j => $item) {
                                    if($item['class_id'] == $value['id']) {
                                        $listCheckin[] = $item['date_checkin'];
                                    }
                                }
                                $data['listClass'][$i]['timekeeping'] = $listCheckin;
                            }

                            // Duyệt qua từng lớp và gán danh sách ngày
                            foreach ($data['listClass'] as &$class) {
                                $updatedDaysArray = [];

                                foreach ($data['daysArray'] as $day) {
                                    $status = "";
                                    $checkin = 0;

                                    // Xác định trạng thái
                                    $makeupDate = json_decode($class["makeup_date"], true);
                                    $offDate = json_decode($class["off_date"], true);
                                    if (in_array($day["date"], $makeupDate)) {
                                        $status = "Học bù";
                                    } elseif (in_array($day["date"], $offDate)) {
                                        $status = "OFF";
                                    }

                                    // Kiểm tra checkin
                                    if (in_array($day["date"], $class["timekeeping"])) {
                                        $checkin = 1;
                                    }

                                    $updatedDaysArray[] = [
                                        "date" => $day["date"],
                                        "current" => $day["current"],
                                        "status" => $status,
                                        "checkin" => $checkin
                                    ];
                                }

                                // Thêm danh sách ngày vào lớp học
                                $class["days"] = $updatedDaysArray;
                            }

                            // Lọc các lớp có thời gian học nằm trong tháng lấy từ $_GET['month']
                            $data['listClass'] = array_filter($data['listClass'], function ($class) use ($month, $year) {
                                $startDate = \DateTime::createFromFormat('d/m/Y', $class["start_date"]);
                                $endDate = \DateTime::createFromFormat('d/m/Y', $class["end_date"]);

                                if (!$startDate || !$endDate) return false; // Bỏ qua nếu ngày không hợp lệ

                                // Lấy danh sách các ngày học bù
                                $makeupDays = isset($class["makeup_date"]) ? json_decode($class["makeup_date"], true) : [];

                                // Kiểm tra nếu có ngày học bù trong tháng đang xét
                                $hasMakeupInMonth = array_filter($makeupDays, function ($date) use ($month, $year) {
                                    $makeupDate = \DateTime::createFromFormat('d/m/Y', $date);
                                    return $makeupDate && $makeupDate->format('n') == $month && $makeupDate->format('Y') == $year;
                                });

                                // Xác định phạm vi tháng cần kiểm tra
                                $monthStart = new \DateTime("$year-$month-01");
                                $monthEnd = clone $monthStart;
                                $monthEnd->modify('last day of this month');

                                // Điều kiện lọc chính xác
                                return (
                                    // Ngày bắt đầu hoặc ngày kết thúc nằm trong tháng
                                    ($startDate->format('n') == $month && $startDate->format('Y') == $year) ||
                                    ($endDate->format('n') == $month && $endDate->format('Y') == $year) ||
                                    // Khoảng thời gian lớp học bao phủ ít nhất một ngày trong tháng
                                    ($startDate <= $monthEnd && $endDate >= $monthStart) ||
                                    // Có ít nhất một ngày học bù trong tháng
                                    !empty($hasMakeupInMonth)
                                );
                            });

                            // Duyệt qua từng lớp học
                            foreach ($data['listClass'] as &$class) {
                                $totalDaysTaught = 0;

                                // Duyệt qua danh sách ngày của lớp
                                foreach ($class['days'] as $day) {
                                    $dateParts = explode("/", $day['date']); // Tách ngày/tháng/năm
                                    $dayMonth = (int)$dateParts[1]; // Lấy tháng
                                    $dayYear = (int)$dateParts[2]; // Lấy năm

                                    // Kiểm tra nếu ngày thuộc tháng & năm cần tính và có checkin
                                    if ($dayMonth == $month && $dayYear == $year && $day['checkin'] > 0) {
                                        $totalDaysTaught++;
                                    }
                                }

                                // Thêm số ngày đã dạy vào mảng dữ liệu của lớp
                                $class['total_days_taught'] = $totalDaysTaught;
                            }

                            $data['listClass'] = array_values($data['listClass']);
                        }
                    }

                    $ConfigTb = new ConfigTb();
                    $data['config'] = $ConfigTb->getItem(array('id' => 1));

                    $data['upsell'] = $SalariesTb->getItem(array(
                        'teacher_id' => $data['teacher']['id'],
                        'month' => $month.'/'.$year
                    ));
                }

                $array = array(
                    'role' => 1,
                    'limit' => 10,
                    'page' => isset($_GET['page']) ? $_GET['page'] : '',
                );

                // Xóa session khi truy cập vào link
                if (!isset($_GET['page']) || $_GET['page'] == 1) {
                    $session->offsetSet('keysearch', '');
                }

                if ($session->keysearch) {
                    $data['keysearch'] = $array['keysearch'] = $session->keysearch;
                }

                $list = $this->listPageTeacher($array);
                $data['listTeacher'] = $list['list'];
                $data['paginator'] = $list['paginator'];
                $data['page'] = $list['params']['page'];

                break;
            case 'account':
                $RoleTb = new RoleTb();
                $data['listRole'] = $RoleTb->listItem(array('deny_id' => [1]));
                $data['listAccount'] = $MemberTb->listItem(array('deny_role' => [1], 'deny_id' => [$data['member']['id']]));
                break;
            case 'config':
                $ConfigTb = new ConfigTb();
                $data['config'] = $ConfigTb->getItem(array('id' => 1));
                break;
            case 'notify':
                // lấy danh sách tất cả ticket
                $data['listNotify'] = $NotificationTb->listItem(array(
                    'parent' => 0,
                    'status' => $_GET['status'] == 1 ? 1 : 2
                ));

                foreach ($data['listNotify'] as $i => $value) {
                    $reply = $NotificationTb->listItem(array('parent' => $value['id'], 'orderby' => 'notify.id ASC'));
                    $data['listNotify'][$i]['reply'] = $reply;
                }

                break;
            default:
                if($_GET['id']) {
                    $data['class'] = $ClassTb->getItem(array('id' => $_GET['id']));

                    // tạo ra các buổi học
                    $makeupDate = json_decode($data['class']['makeup_date'], true) ? json_decode($data['class']['makeup_date'], true) : [];
                    $offDate = $data['class']['off_date'] ? $data['class']['off_date'] : [];
                    $data['schedule'] = $this->generateSchedule($data['class']['start_date'], $data['class']['end_date'], $data['class']['day_of_week'], $makeupDate, $offDate);

                    if($data['class']['id']) {
                        $data['student'] = $this->sortStudentsByName($this->listStudent(array(
                            'class_id' => $data['class']['id'],
                            'status' => 1
                        )));

                        if($data['student']) {
                            $StudentAttendancesTb = new StudentAttendancesTb();
                            foreach ($data['student'] as $i => $student) {
                                $data['student'][$i]['checkin'] = [];
                                foreach ($data['schedule'] as $j => $schedule) {
                                    $studentAttendances = $StudentAttendancesTb->getItem(array(
                                        'student_id' => $student['id'],
                                        'class_id' => $data['class']['id'],
                                        'session_date' => $schedule['date']
                                    ));

                                    $data['student'][$i]['checkin'][str_replace('/','-', $schedule['date'])] = array(
                                        'label' => $schedule['label'],
                                        'date' => $schedule['date'],
                                        'active' => $schedule['active'],
                                        'active_next' => $schedule['active_next'],
                                        'off' => $schedule['off']
                                    );

                                    if($studentAttendances['id']) {
                                        switch ($studentAttendances['checkin']) {
                                            case 'ĐH':
                                                $classNameHTML = 'present-color';
                                                break;
                                            case 'CP':
                                                $classNameHTML = 'cp-color';
                                                break;
                                            default:
                                                $classNameHTML = 'absence-color';
                                                break;
                                        }

                                        $data['student'][$i]['checkin'][str_replace('/','-', $schedule['date'])]['checkInName'] = $studentAttendances['checkin'];
                                        $data['student'][$i]['checkin'][str_replace('/','-', $schedule['date'])]['className'] = $classNameHTML;
                                    }
                                }

                                $listCheckin = $data['student'][$i]['checkin'];
                                $countAbsent = 0;
                                foreach ($listCheckin as $value) {
                                    if($value['checkInName']) {
                                        if($value['checkInName'] != 'ĐH' && !$value['off'])
                                            $countAbsent++;
                                    }
                                }

                                $data['student'][$i]['totalAbsent'] = $countAbsent;
                            }

                            foreach ($data['schedule'] as $i => $schedule) {
                                $checkin = [];
                                foreach ($data['student'] as $j => $student) {
                                    $checkin[] = array(
                                        'id' => $student['id'],
                                        'fullname' => $student['fullname'],
                                        'checkInName' => $student['checkin'][str_replace('/','-', $schedule['date'])]['checkInName'],
                                        'off' => $schedule['off']
                                    );
                                }

                                $countTotalAbsent = 0;
                                foreach ($checkin as $value) {
                                    if($value['checkInName'] && $value['checkInName'] != 'ĐH' && !$value['off'])
                                        $countTotalAbsent++;
                                }
                                $data['schedule'][$i]['totalAbsent'] = $countTotalAbsent;
                            }
                        }
                    }
                }

                $data['listTeacher'] = $MemberTb->listItem(array('role' => 1));
                $data['listConsultants'] = $MemberTb->listItem(array('role' => [2,3,4]));

                $array = array(
                    'status' => $_GET['status'] == 2 ? 2 : 1,
                    'limit' => 10,
                    'page' => isset($_GET['page']) ? $_GET['page'] : '',
                );

                // Xóa session khi truy cập vào link
                if (!isset($_GET['page']) || $_GET['page'] == 1) {
                    $session->offsetSet('keysearch', '');
                    $session->offsetSet('teacher_id', '');
                }

                if ($session->keysearch) {
                    $data['keysearch'] = $array['keysearch'] = $session->keysearch;
                }

                if ($session->teacher_id) {
                    $data['teacher_id'] = $array['teacher_id'] = $session->teacher_id;
                }

                $list = $this->listPageClass($array);
                $data['listClass'] = $list['list'];
                $data['paginator'] = $list['paginator'];
                $data['page'] = $list['params']['page'];

                break;
        }

        if ($this->getRequest()->isPost()) {
            $params['post'] = $this->getRequest()->getPost()->toArray();

            if($params['post']['type']) {
                switch ($params['post']['type']) {
                    case 'student':
                        if($params['post']['action'] == 'create') {
                            if($params['post']['student_id']) {
                                $params['id'] = $params['post']['student_id'];
                            }
                        } else if($params['post']['action'] == 'del') { // Xoá học viên
                            if($params['post']['student_id']) {
                                $params['id'] = $params['post']['student_id'];
                                $params['post']['status'] = 3;
                                $StudentTb->saveData($params);

                                $StudentAttendancesTb = new StudentAttendancesTb();
                                $StudentAttendancesTb->saveData(array(
                                    'student_id' => $params['id'],
                                    'post' => $params['post']
                                ));
                            }
                            return $this->response;
                        }

                        // save data
                        $StudentTb->saveData($params);

                        break;
                    case 'teacher':
                        if($params['post']['action'] == 'create') { // add/edit giáo viên
                            $params['post']['status'] = $params['post']['status'] == 2 ? 2 : 1;
                            $params['post']['role'] = 1;

                            if($params['post']['teacher_id']) {
                                $params['id'] = $params['post']['teacher_id'];
                                if($params['post']['email']) {
                                    unset($params['post']['email']);
                                }
                            }

                            if($params['post']['email']) {
                                // src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'"
                                // src="https://demo3103.seomarketing.edu.vn/test/public_html/uploads/images/2025/03/1742438903-single_info36-logo.png"
                                $template = array(
                                    'subject' => '[[[domain]]] Thông báo kích hoạt tài khoản',
                                    'key' => array('[[domain]]','[[ho-ten]]','[[email]]','[[mat-khau]]','[[role]]'),
                                    'value' => array(
                                        DOMAIN,
                                        $params['post']['fullname'],
                                        $params['post']['email'],
                                        $params['post']['password'],
                                        'Giáo viên',
                                    ),
                                    'body' => '<p style="border-bottom: 1px solid #eee;"><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank"><img alt="Kích hoạt tài khoản" height="43" src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'" style="width: 140px;" /></a></span></span></p>
                                        <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Chào bạn <strong>[[ho-ten]]</strong>,</span></span></p>
                                        <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Tài khoản của bạn đã được kích hoạt trên hệ thống <a href="[[domain]]" target="_blank">[[domain]]</a></span></span></em></strong></span></p>
                                        <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Thông tin tài khoản:</span></span></em></strong></span></p>
                                        <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Email đăng nhập: <strong>[[email]]</strong></span></span></em></p>
                                        <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Mật khẩu: <strong>[[mat-khau]]</strong></span></span></em></p>
                                        <p style="margin-left: 15px;margin-bottom: 15px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Quyền truy cập: <strong>[[role]]</strong></span></span></em></p>
                                        <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Vui lòng đổi mật khẩu cho lần đăng nhập đầu tiên.</span></span></p>
                                        <p style="margin-top: 0;"><span style="font-family:Times New Roman,Times,serif;font-size:16px;"><em><strong>* <u>Ghi chú</u>:</strong> Đây là email thông báo tự động. Vui lòng không phản hồi lại email này!</em></span></p>'
                                );

                                $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                                    'emailTo' => $params['post']['email'],
                                    'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                                    'body' => str_replace($template['key'], $template['value'], $template['body'])
                                ));
                            }
                        } else if($params['post']['action'] == 'del') { // Xoá giáo viên
                            if($params['post']['teacher_id']) {
                                $params['id'] = $params['post']['teacher_id'];
                                $params['post']['status'] = 3;
                                $MemberTb->saveData($params);
                            }
                            return $this->response;
                        }

                        // save data
                        $MemberTb->saveData($params);

                        break;
                    case 'account':
                        $indexRole = array_search($params['post']['role'], array_column($data['listRole'], 'id'));
                        $roleName = $data['listRole'][$indexRole]['name'];

                        if($params['post']['action'] == 'create') { // add/edit tài khoản
                            $params['post']['status'] = $params['post']['status'] ? $params['post']['status'] : 1;
                            $params['post']['role'] = $params['post']['role'] ? $params['post']['role'] : 1;

                            if($params['post']['member_id']) {
                                $params['id'] = $params['post']['member_id'];
                                if($params['post']['email']) {
                                    unset($params['post']['email']);
                                }
                            }

                            if($params['post']['email']) {
                                // src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'"
                                $template = array(
                                    'subject' => '[[[domain]]] Thông báo kích hoạt tài khoản',
                                    'key' => array('[[domain]]','[[ho-ten]]','[[email]]','[[mat-khau]]','[[role]]'),
                                    'value' => array(
                                        DOMAIN,
                                        $params['post']['fullname'],
                                        $params['post']['email'],
                                        $params['post']['password'],
                                        $roleName,
                                    ),
                                    'body' => '<p style="border-bottom: 1px solid #eee;"><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank"><img alt="Kích hoạt tài khoản" height="43" src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'" style="width: 140px;" /></a></span></span></p>
                                        <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Chào bạn <strong>[[ho-ten]]</strong>,</span></span></p>
                                        <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Tài khoản của bạn đã được kích hoạt trên hệ thống <a href="[[domain]]" target="_blank">[[domain]]</a></span></span></em></strong></span></p>
                                        <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Thông tin tài khoản:</span></span></em></strong></span></p>
                                        <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Email đăng nhập: <strong>[[email]]</strong></span></span></em></p>
                                        <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Mật khẩu: <strong>[[mat-khau]]</strong></span></span></em></p>
                                        <p style="margin-left: 15px;margin-bottom: 15px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Quyền truy cập: <strong>[[role]]</strong></span></span></em></p>
                                        <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Vui lòng đổi mật khẩu cho lần đăng nhập đầu tiên.</span></span></p>
                                        <p style="margin-top: 0;"><span style="font-family:Times New Roman,Times,serif;font-size:16px;"><em><strong>* <u>Ghi chú</u>:</strong> Đây là email thông báo tự động. Vui lòng không phản hồi lại email này!</em></span></p>'
                                );

                                $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                                    'emailTo' => $params['post']['email'],
                                    'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                                    'body' => str_replace($template['key'], $template['value'], $template['body'])
                                ));
                            }
                        } else if($params['post']['action'] == 'pw') {
                            // Đổi mật khẩu
                            $params['id'] = $params['post']['member_id'];
                            $MemberTb->saveData($params);

                            // Gửi mail thông báo
                            $member = $MemberTb->getItem(array(
                                'id' => $params['post']['member_id'],
                                'columns' => array('id','email','fullname','thumbnail','phone','address','birthday','sex','role','bank_number','bank_name','bank_owner')
                            ));

                            if($member['email']) {
                                $template = array(
                                    'subject' => '[[[domain]]] Thông báo cấp lại mật khẩu mới',
                                    'key' => array('[[domain]]','[[ho-ten]]','[[email]]','[[mat-khau]]'),
                                    'value' => array(
                                        DOMAIN,
                                        $member['fullname'],
                                        $member['email'],
                                        $params['post']['password']
                                    ),
                                    'body' => '<p style="border-bottom: 1px solid #eee;"><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank"><img alt="Kích hoạt tài khoản" height="43" src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'" style="width: 140px;" /></a></span></span></p>
                                        <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Chào bạn <strong>[[ho-ten]]</strong>,</span></span></p>
                                        <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Tài khoản của bạn đã được cấp lại mật khẩu mới trên hệ thống <a href="[[domain]]" target="_blank">[[domain]]</a></span></span></em></strong></span></p>
                                        <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Thông tin tài khoản:</span></span></em></strong></span></p>
                                        <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Email đăng nhập: <strong>[[email]]</strong></span></span></em></p>
                                        <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Mật khẩu: <strong>[[mat-khau]]</strong></span></span></em></p>
                                        <p style="margin-top: 0;"><span style="font-family:Times New Roman,Times,serif;font-size:16px;"><em><strong>* <u>Ghi chú</u>:</strong> Đây là email thông báo tự động. Vui lòng không phản hồi lại email này!</em></span></p>'
                                );

                                $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                                    'emailTo' => $member['email'],
                                    'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                                    'body' => str_replace($template['key'], $template['value'], $template['body'])
                                ));
                            }

                            echo json_encode(array('closeModel' => true));
                            return $this->response;
                        } else if($params['post']['action'] == 'del') { // Xoá tài khoản
                            if($params['post']['member_id']) {
                                $params['id'] = $params['post']['member_id'];
                                $params['post']['status'] = 3;
                                $MemberTb->saveData($params);
                            }
                            return $this->response;
                        }

                        // save data
                        $MemberTb->saveData($params);

                        break;
                    case 'config':
                        $ConfigTb = new ConfigTb();
                        $ConfigTb->saveData(array('id' => 1, 'post' => $params['post']));
                        break;
                    case 'notify':
                        if($params['post']['action'] == 'reply') {
                            $params['post']['user_reply'] = $data['member']['id'];
                            $NotificationTb->saveData($params);

                            $roleName = in_array($data['member']['role'], [2,3,4]) ? '<span class="role">Tư vấn</span>':'';
                            $htmlReply = '<div class="noti-list_item-reply">
                                <h3>'.$data['member']['fullname'].$roleName.'</h3>
                                <p class="reply">'.$params['post']['content'].'</p>
                            </div>';

                            echo json_encode(array('addReply' => true, 'htmlReply' => $htmlReply, 'parent' => $params['post']['parent']));
                            return $this->response;
                        }

                        if($params['post']['action'] == 'close') {
                            $params['id'] = $params['post']['ticket'];
                            $params['post']['status'] = 1;
                            $NotificationTb->saveData($params);
                        }

                        break;
                    default:
                        if($params['post']['action'] == 'create') { // add/edit lớp
                            $errorsImport = array();
                            $dataItem = array();
                            if ($_FILES['import_excel']) {
                                $extension = strtolower(substr($_FILES['import_excel']['name'],(strrpos($_FILES['import_excel']['name'], "."))));
                                $filename = 'import-excel-' . time() . $extension;
                                $path = ROOT_PUBLIC.'/'.UPLOAD_FILES;
                                move_uploaded_file($_FILES['import_excel']['tmp_name'], $path.$filename);

                                if (file_exists($path.$filename)) {
                                    $render = \PHPExcel_IOFactory::createReaderForFile($path.$filename);
                                    $objPHPExcel = $render->load($path.$filename);
                                    $rows = $objPHPExcel->getActiveSheet()->toArray();
                                    $headersTemplate = $this->headersTemplate();

                                    // check sku file excel
                                    // $check_sku = $this->hasDuplicatedValues($objPHPExcel);
                                    // $line_sku = $this->lineDuplicateRows($objPHPExcel);
                                    // if($line_sku){
                                    //     $errorsImport[] = array(
                                    //         'line' => $line_sku,
                                    //         'label' => 'Mã sản phẩm',
                                    //         'code' => 'DUPLICATE_CHECK'
                                    //     );
                                    // }

                                    // Validate header
                                    $headers = array_shift($rows);
                                    foreach($headers as $columnIndex => $header) {
                                        $columnLetter = \PHPExcel_Cell::stringFromColumnIndex($columnIndex) . '1';
                                        if ($header != $headersTemplate[$columnLetter]['title']) {
                                            $errorsImport[] = array('message' => 'File nhập liệu không đúng. Vui lòng <b>Tải File Mẫu nhập liệu Học viên</b> và thực hiện lại!');
                                            array_map('unlink', glob($path.'/import-*'));
                                            echo json_encode(array('errorsImport' => $errorsImport));
                                            return $this->response;
                                        }
                                    }

                                    // Empty data
                                    if (count($rows) == 0) {
                                        $errorsImport[] = array('message' => 'Danh sách chưa có dữ liệu để thêm');
                                        array_map('unlink', glob($path.'/import-*'));
                                        echo json_encode(array('errorsImport' => $errorsImport));
                                        return $this->response;
                                    }

                                    // Validate content

                                    $headerTitle = array_reduce($headersTemplate, function($carry = array(), $item) {
                                        $carry[$item['field'].$item['name']] = $item['title'];
                                        return $carry;
                                    });


                                    foreach($rows as $rowIndex => $row) {
                                        $line = $rowIndex + 2; // 2 is begin of row data
                                        if(empty($row[0]) && empty($row[1]) && empty($row[2]))
                                            continue;
                                        if(empty($row[0])) {
                                            $errorsImport[] = array('label' => $headerTitle['fullname'], 'line' => $line, 'message' => 'Thông tin bắt buộc nhập');
                                        } if (empty($row[1])) {
                                            $errorsImport[] = array('label' => $headerTitle['phone'], 'line' => $line, 'message' => 'Thông tin bắt buộc nhập');
                                        } if (empty($row[2])) {
                                            $errorsImport[] = array('label' => $headerTitle['email'], 'line' => $line, 'message' => 'Thông tin bắt buộc nhập');
                                        }

                                        $student['post'] = $this->dataTemplate($headersTemplate, $row);
                                        $dataItem[] = $student['post'];
                                    }

                                    // check errors
                                    if (!empty($errorsImport)) {
                                        echo json_encode(array('errorsImport' => $errorsImport));
                                        array_map('unlink', glob($path.'/import-*'));
                                        return $this->response;
                                    }

                                    // Delete file after upload
                                    array_map('unlink', glob($path.'/import-*'));
                                }
                            }

                            $params['post']['status'] = $params['post']['status'] == 2 ? 2 : 1;

                            if($params['post']['class_id']) {
                                $params['id'] = $params['post']['class_id'];
                            } else {
                                if($params['post']['teacher_id']) {
                                    // Gửi mail cho giáo viên
                                    $teacher = $MemberTb->getItem(array('id' => $params['post']['teacher_id'], 'column' => array('id','email')));
                                    if($teacher['email']) {
                                        $days = $params['post']['day_of_week'];
                                        sort($days);

                                        $mapDay = [
                                            2 => 'Thứ 2',
                                            3 => 'Thứ 3',
                                            4 => 'Thứ 4',
                                            5 => 'Thứ 5',
                                            6 => 'Thứ 6',
                                            7 => 'Thứ 7',
                                            8 => 'Chủ Nhật',
                                        ];

                                        $dayNames = [];
                                        foreach ($days as $day) {
                                            if (isset($mapDay[$day])) {
                                                $dayNames[] = $mapDay[$day];
                                            }
                                        }

                                        $buoiHoc = implode(', ', $dayNames);

                                        $template = array(
                                            'subject' => '[[[domain]]] Bạn vừa được phân công dạy lớp [[ten-lop]]',
                                            'key' => array('[[domain]]','[[ho-ten]]','[[ten-lop]]','[[ngay-bat-dau]]','[[ngay-ket-thuc]]','[[buoi-hoc]]','[[so-buoi-day]]','[[gio-hoc]]'),
                                            'value' => array(
                                                DOMAIN,
                                                $teacher['fullname'],
                                                $params['post']['name'],
                                                $params['post']['start_date'],
                                                $params['post']['end_date_auto'] ? $params['post']['end_date_auto'] : $params['post']['end_date'],
                                                $buoiHoc,
                                                $params['post']['soBuoi'],
                                                $params['post']['session_times'],
                                            ),
                                            'body' => '<p style="border-bottom: 1px solid #eee;"><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank"><img alt="Kích hoạt tài khoản" height="43" src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'" style="width: px; height: 43px;" /></a></span></span></p>
                                                <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Chào bạn <strong>[[ho-ten]]</strong>,</span></span></p>
                                                <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Bạn vừa được phân công làm giáo viên của lớp [[ten-lop]] trên hệ thống <a href="[[domain]]" target="_blank">[[domain]]</a></span></span></em></strong></span></p>
                                                <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Thông tin chi tiết:</span></span></em></strong></span></p>
                                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Tên lớp học: <strong>[[ten-lop]]</strong></span></span></em></p>
                                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Ngày bắt đầu: <strong>[[ngay-bat-dau]]</strong></span></span></em></p>
                                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Ngày kết thúc: <strong>[[ngay-ket-thuc]]</strong></span></span></em></p>
                                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Số buổi dạy: <strong>[[so-buoi-day]] buổi</strong></span></span></em></p>
                                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Buổi học: <strong>[[buoi-hoc]]</strong></span></span></em></p>
                                                <p style="margin-left: 15px;margin-bottom: 15px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Giờ học: <strong>[[gio-hoc]]</strong></span></span></em></p>
                                                <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Vui lòng đăng nhập vào tài khoản giáo viên của bạn vào hệ thống&nbsp;</span></span><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank">[[domain]]</a></span></span></em></strong></span><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"> để xem chi tiết.</span></span></p>
                                                <p style="margin-top: 0;"><span style="font-family:Times New Roman,Times,serif;font-size:16px;"><em><strong>* <u>Ghi chú</u>:</strong> Đây là email thông báo tự động. Vui lòng không phản hồi lại email này!</em></span></p>'
                                        );

                                        $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                                            'emailTo' => $teacher['email'],
                                            'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                                            'body' => str_replace($template['key'], $template['value'], $template['body'])
                                        ));
                                    }
                                }
                            }

                            if($params['post']['teacher_id'] && $params['post']['consultant_id']) {
                                $classId = $ClassTb->saveData($params);

                                // Insert data
                                if ($dataItem && empty($errorsImport)) {
                                    foreach($dataItem as $row) {
                                        $post = $row;
                                        $post['class_id'] = $classId;
                                        $StudentTb->saveData(array('post' => $post));
                                    }
                                }
                            } else {
                                echo json_encode(array('errorAdd' => true));
                                return $this->response;
                            }

                            // if($classId && $params['post']['teacher_id']) {
                            //     $array = array(
                            //         'class_id' => $classId,
                            //         'teacher_id' => $params['post']['teacher_id']
                            //     );

                            //     $searchTimekeeping = $TimekeepingTb->getItem($array);
                            //     $searchSalaries = $SalariesTb->getItem($array);

                            //     if($searchTimekeeping['id']) {
                            //         $paramsTimekeeping['id'] = $searchTimekeeping['id'];
                            //         $array['class_id'] = $searchTimekeeping['class_id'];
                            //     }

                            //     if($searchSalaries['id']) {
                            //         $paramsSalaries['id'] = $searchSalaries['id'];
                            //     }

                            //     // add/edit item chấm công & lương cho GV tương ứng
                            //     $paramsTimekeeping['post'] = $paramsSalaries['post'] = $array;
                            //     $TimekeepingTb->saveData($paramsTimekeeping);
                            //     $SalariesTb->saveData($paramsSalaries);
                            // }
                        } else if($params['post']['action'] == 'del') { // Xoá lớp
                            if($params['post']['class_id']) {
                                $params['id'] = $params['post']['class_id'];
                                $params['post']['status'] = 3;
                                $ClassTb->saveData($params);
                            }
                            return $this->response;
                        }

                        break;
                }
            }

            echo json_encode(array('redirect' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'].(isset($_GET['action']) ? '&changed=true':'?changed=true')));
            return $this->response;
        }

        // SEO || SNIPPET
        $name = $data['listSidebar'][($_GET['action'] ? $_GET['action'] : 'class')]['name'] ? $data['listSidebar'][($_GET['action'] ? $_GET['action'] : 'class')]['name'] : $data['listSidebar']['class']['name'];
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = array(
            'name' => $name,
            'title' => $name,
            'link' => 'master-consultant-77.html'
        );

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'title' => $name,
            'keyword' => $name,
            'description' => $name,
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => $data['menu'],
            'noindex' => true
        ));

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = array('vi' => 'thong-tin-tai-khoan', 'en' => 'en/account-info'); // Nếu có ngôn ngữ LANG

        return new ViewModel($data);
    }

    public function consultantAction() // 78.html
    {
        $params = $this->params()->fromRoute();
        $translator = $this->getServiceLocator()->get('translator');
        $data = array('action' => 'master');

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $session = new Container('frontend');
        $MemberTb = new MemberTb();
        $ClassTb = new ClassTb();
        $TimekeepingTb = new TimekeepingTb();
        $StudentTb = new StudentTb();
        $SalariesTb = new SalariesTb();
        $NotificationTb = new NotificationTb();
        $data['member'] = $MemberTb->getItem(array(
            'id' => $this->_session->logged['id'],
            'columns' => array('id','email','fullname','thumbnail','phone','address','birthday','sex','role','bank_number','bank_name','bank_owner')
        ));

        $data['listSidebar'] = $this->_listSidebar[$data['member']['role']];

        switch ($_GET['action']) {
            case 'student':
                $array = array(
                    'limit' => 10,
                    'page' => isset($_GET['page']) ? $_GET['page'] : '',
                );

                if(in_array($data['member']['role'], [4])) {
                    $listClass = array_column($this->listClass(array('consultant_id' => $data['member']['id'])), 'id');
                    $array['class_id'] = $listClass ? $listClass : '-1';
                }

                // Xóa session khi truy cập vào link
                if (!isset($_GET['page']) || $_GET['page'] == 1) {
                    $session->offsetSet('keysearch', '');
                    $session->offsetSet('teacher_id', '');
                }

                if ($session->keysearch) {
                    $data['keysearch'] = $array['keysearch'] = $session->keysearch;
                }

                $list = $this->listPageStudent($array);
                $data['listStudent'] = $list['list'];
                $data['paginator'] = $list['paginator'];
                $data['page'] = $list['params']['page'];

                $data['class'] = $this->listClass();

                break;
            case 'teacher':
                if($_GET['wage']) {
                    // Lấy ngày hiện tại
                    $currentDay = date("j");
                    $currentMonth = date("n");
                    $currentYear = date("Y");

                    // Lấy tháng & năm từ URL hoặc dùng tháng hiện tại
                    $month = $currentMonth;
                    $year = $currentYear;

                    if (isset($_GET['month']) && preg_match('/^(0[1-9]|1[0-2])-\d{4}$/', $_GET['month'])) {
                        list($month, $year) = explode('-', $_GET['month']);
                        $month = (int)$month;
                        $year = (int)$year;
                    }

                    // Xác định số ngày trong tháng
                    $totalDays = ($month == 2) ? (($year % 4 == 0 && ($year % 100 != 0 || $year % 400 == 0)) ? 29 : 28)
                                : cal_days_in_month(CAL_GREGORIAN, $month, $year);

                    // Tạo danh sách ngày trong tháng
                    $data['daysArray'] = [];
                    for ($i = 1; $i <= $totalDays; $i++) {
                        $data['daysArray'][] = [
                            "date" => sprintf("%02d/%02d/%04d", $i, $month, $year), // Định dạng DD/MM/YYYY
                            "current" => ($i == $currentDay && $month == $currentMonth && $year == $currentYear),
                            "status" => "", // Mặc định rỗng
                            "checkin" => 0  // Mặc định chưa checkin
                        ];
                    }

                    $data['teacher'] = $MemberTb->getItem(array('id' => $_GET['wage']));

                    if($data['teacher']['id']) {
                        // lấy danh sách lớp của gv đang dạy trong tháng
                        $listClassMap = $ClassTb->listItem(array(
                            'teacher_id' => $data['teacher']['id'],
                            'orderby' => 'class.id ASC',
                            'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                        ));

                        //  Lấy danh sách chấm công của GV
                        $timekeeping = $TimekeepingTb->listItem(array(
                            'teacher_id' => $data['teacher']['id'],
                            'columns' => array('class_id','teacher_id','date_checkin')
                        ));

                        // Danh sách id lớp đang map với GV
                        $classIdMap = array_unique(array_column($listClassMap, 'id'));

                        // Lấy danh sách lớp mà GV đó đã từng dạy (tính luôn trường hợp đang dạy mà ngừng hoặc chuyển lớp khác)
                        $taughtClasses = array_unique(array_column($timekeeping, 'class_id'));

                        // Gốp danh sách ID lại để có ds lớp cuối cùng bao gồm lớp đang map và lớp đã từng dạy
                        $listIdClassFinal = array_unique(array_merge($classIdMap, $taughtClasses));

                        if(!empty($listIdClassFinal)) {
                            // lấy danh sách lớp của gv đang dạy trong tháng
                            $data['listClass'] = $ClassTb->listItem(array(
                                'list_id' => $listIdClassFinal,
                                'orderby' => 'class.id ASC',
                                'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                            ));

                            // Lấy danh sách chấm công của gv đang dạy cho từng lớp
                            foreach ($data['listClass'] as $i => $value) {
                                $listCheckin = [];
                                foreach ($timekeeping as $j => $item) {
                                    if($item['class_id'] == $value['id']) {
                                        $listCheckin[] = $item['date_checkin'];
                                    }
                                }
                                $data['listClass'][$i]['timekeeping'] = $listCheckin;
                            }

                            // Duyệt qua từng lớp và gán danh sách ngày
                            foreach ($data['listClass'] as &$class) {
                                $updatedDaysArray = [];

                                foreach ($data['daysArray'] as $day) {
                                    $status = "";
                                    $checkin = 0;

                                    // Xác định trạng thái
                                    $makeupDate = json_decode($class["makeup_date"], true);
                                    $offDate = json_decode($class["off_date"], true);
                                    if (in_array($day["date"], $makeupDate)) {
                                        $status = "Học bù";
                                    } elseif (in_array($day["date"], $offDate)) {
                                        $status = "OFF";
                                    }

                                    // Kiểm tra checkin
                                    if (in_array($day["date"], $class["timekeeping"])) {
                                        $checkin = 1;
                                    }

                                    $updatedDaysArray[] = [
                                        "date" => $day["date"],
                                        "current" => $day["current"],
                                        "status" => $status,
                                        "checkin" => $checkin
                                    ];
                                }

                                // Thêm danh sách ngày vào lớp học
                                $class["days"] = $updatedDaysArray;
                            }

                            // Lọc các lớp có thời gian học nằm trong tháng lấy từ $_GET['month']
                            $data['listClass'] = array_filter($data['listClass'], function ($class) use ($month, $year) {
                                $startDate = \DateTime::createFromFormat('d/m/Y', $class["start_date"]);
                                $endDate = \DateTime::createFromFormat('d/m/Y', $class["end_date"]);

                                if (!$startDate || !$endDate) return false; // Bỏ qua nếu ngày không hợp lệ

                                // Lấy danh sách các ngày học bù
                                $makeupDays = isset($class["makeup_date"]) ? json_decode($class["makeup_date"], true) : [];

                                // Kiểm tra nếu có ngày học bù trong tháng đang xét
                                $hasMakeupInMonth = array_filter($makeupDays, function ($date) use ($month, $year) {
                                    $makeupDate = \DateTime::createFromFormat('d/m/Y', $date);
                                    return $makeupDate && $makeupDate->format('n') == $month && $makeupDate->format('Y') == $year;
                                });

                                // Xác định phạm vi tháng cần kiểm tra
                                $monthStart = new \DateTime("$year-$month-01");
                                $monthEnd = clone $monthStart;
                                $monthEnd->modify('last day of this month');

                                // Điều kiện lọc chính xác
                                return (
                                    // Ngày bắt đầu hoặc ngày kết thúc nằm trong tháng
                                    ($startDate->format('n') == $month && $startDate->format('Y') == $year) ||
                                    ($endDate->format('n') == $month && $endDate->format('Y') == $year) ||
                                    // Khoảng thời gian lớp học bao phủ ít nhất một ngày trong tháng
                                    ($startDate <= $monthEnd && $endDate >= $monthStart) ||
                                    // Có ít nhất một ngày học bù trong tháng
                                    !empty($hasMakeupInMonth)
                                );
                            });

                            // Duyệt qua từng lớp học
                            foreach ($data['listClass'] as &$class) {
                                $totalDaysTaught = 0;

                                // Duyệt qua danh sách ngày của lớp
                                foreach ($class['days'] as $day) {
                                    $dateParts = explode("/", $day['date']); // Tách ngày/tháng/năm
                                    $dayMonth = (int)$dateParts[1]; // Lấy tháng
                                    $dayYear = (int)$dateParts[2]; // Lấy năm

                                    // Kiểm tra nếu ngày thuộc tháng & năm cần tính và có checkin
                                    if ($dayMonth == $month && $dayYear == $year && $day['checkin'] > 0) {
                                        $totalDaysTaught++;
                                    }
                                }

                                // Thêm số ngày đã dạy vào mảng dữ liệu của lớp
                                $class['total_days_taught'] = $totalDaysTaught;
                            }

                            $data['listClass'] = array_values($data['listClass']);
                        }
                    }

                    $ConfigTb = new ConfigTb();
                    $data['config'] = $ConfigTb->getItem(array('id' => 1));

                    $data['upsell'] = $SalariesTb->getItem(array(
                        'teacher_id' => $data['teacher']['id'],
                        'month' => $month.'/'.$year
                    ));
                }

                $array = array(
                    'role' => 1,
                    'limit' => 10,
                    'page' => isset($_GET['page']) ? $_GET['page'] : '',
                );

                // Xóa session khi truy cập vào link
                if (!isset($_GET['page']) || $_GET['page'] == 1) {
                    $session->offsetSet('keysearch', '');
                }

                if ($session->keysearch) {
                    $data['keysearch'] = $array['keysearch'] = $session->keysearch;
                }

                $list = $this->listPageTeacher($array);
                $data['listTeacher'] = $list['list'];
                $data['paginator'] = $list['paginator'];
                $data['page'] = $list['params']['page'];


                break;
            case 'notify':
                // lấy danh sách lớp mà tư vấn trực tiếp quản lý
                $listClass = $this->listClass(array('consultant_id' => $data['member']['id']));

                if($listClass) {
                    $data['listNotify'] = $NotificationTb->listItem(array(
                        'parent' => 0,
                        'class_id' => array_column($listClass, 'id'),
                        'status' => $_GET['status'] == 1 ? 1 : 2
                    ));

                    foreach ($data['listNotify'] as $i => $value) {
                        $reply = $NotificationTb->listItem(array('parent' => $value['id'], 'orderby' => 'notify.id ASC'));
                        $data['listNotify'][$i]['reply'] = $reply;
                    }
                }

                break;
            default:
                if($_GET['id']) {
                    $data['class'] = $ClassTb->getItem(array('id' => $_GET['id']));

                    // tạo ra các buổi học
                    $makeupDate = json_decode($data['class']['makeup_date'], true) ? json_decode($data['class']['makeup_date'], true) : [];
                    $offDate = $data['class']['off_date'] ? $data['class']['off_date'] : [];
                    $data['schedule'] = $this->generateSchedule($data['class']['start_date'], $data['class']['end_date'], $data['class']['day_of_week'], $makeupDate, $offDate);

                    if($data['class']['id']) {
                        $data['student'] = $this->sortStudentsByName($this->listStudent(array(
                            'class_id' => $data['class']['id'],
                            'status' => 1
                        )));

                        if($data['student']) {
                            $StudentAttendancesTb = new StudentAttendancesTb();
                            foreach ($data['student'] as $i => $student) {
                                $data['student'][$i]['checkin'] = [];
                                foreach ($data['schedule'] as $j => $schedule) {
                                    $studentAttendances = $StudentAttendancesTb->getItem(array(
                                        'student_id' => $student['id'],
                                        'class_id' => $data['class']['id'],
                                        'session_date' => $schedule['date']
                                    ));

                                    $data['student'][$i]['checkin'][str_replace('/','-', $schedule['date'])] = array(
                                        'label' => $schedule['label'],
                                        'date' => $schedule['date'],
                                        'active' => $schedule['active'],
                                        'active_next' => $schedule['active_next'],
                                        'off' => $schedule['off']
                                    );

                                    if($studentAttendances['id']) {
                                        switch ($studentAttendances['checkin']) {
                                            case 'ĐH':
                                                $classNameHTML = 'present-color';
                                                break;
                                            case 'CP':
                                                $classNameHTML = 'cp-color';
                                                break;
                                            default:
                                                $classNameHTML = 'absence-color';
                                                break;
                                        }

                                        $data['student'][$i]['checkin'][str_replace('/','-', $schedule['date'])]['checkInName'] = $studentAttendances['checkin'];
                                        $data['student'][$i]['checkin'][str_replace('/','-', $schedule['date'])]['className'] = $classNameHTML;
                                    }
                                }

                                $listCheckin = $data['student'][$i]['checkin'];
                                $countAbsent = 0;
                                foreach ($listCheckin as $value) {
                                    if($value['checkInName']) {
                                        if($value['checkInName'] != 'ĐH' && !$value['off'])
                                            $countAbsent++;
                                    }
                                }

                                $data['student'][$i]['totalAbsent'] = $countAbsent;
                            }

                            foreach ($data['schedule'] as $i => $schedule) {
                                $checkin = [];
                                foreach ($data['student'] as $j => $student) {
                                    $checkin[] = array(
                                        'id' => $student['id'],
                                        'fullname' => $student['fullname'],
                                        'checkInName' => $student['checkin'][str_replace('/','-', $schedule['date'])]['checkInName'],
                                        'off' => $schedule['off']
                                    );
                                }

                                $countTotalAbsent = 0;
                                foreach ($checkin as $value) {
                                    if($value['checkInName'] && $value['checkInName'] != 'ĐH' && !$value['off'])
                                        $countTotalAbsent++;
                                }
                                $data['schedule'][$i]['totalAbsent'] = $countTotalAbsent;
                            }
                        }
                        // echo '<pre style="color:#f00;font-weight:bold;">'; print_r($data['student']); echo '</pre>';
                    }
                }

                $data['listTeacher'] = $MemberTb->listItem(array('role' => 1));
                $data['listConsultants'] = $MemberTb->listItem(array('role' => [2,3,4]));

                $array = array(
                    'status' => $_GET['status'] == 2 ? 2 : 1,
                    'limit' => 10,
                    'page' => isset($_GET['page']) ? $_GET['page'] : '',
                );

                if(in_array($data['member']['role'], [4])) {
                    $array['consultant_id'] = $data['member']['id'];
                }

                // Xóa session khi truy cập vào link
                if (!isset($_GET['page']) || $_GET['page'] == 1) {
                    $session->offsetSet('keysearch', '');
                    $session->offsetSet('teacher_id', '');
                }

                if ($session->keysearch) {
                    $data['keysearch'] = $array['keysearch'] = $session->keysearch;
                }

                if ($session->teacher_id) {
                    $data['teacher_id'] = $array['teacher_id'] = $session->teacher_id;
                }

                $list = $this->listPageClass($array);
                $data['listClass'] = $list['list'];
                $data['paginator'] = $list['paginator'];
                $data['page'] = $list['params']['page'];

                break;
        }

        if ($this->getRequest()->isPost()) {
            $params['post'] = $this->getRequest()->getPost()->toArray();

            if($params['post']['type']) {
                switch ($params['post']['type']) {
                    case 'student':
                        if($params['post']['action'] == 'create') {
                            if($params['post']['student_id']) {
                                $params['id'] = $params['post']['student_id'];
                            }
                        } else if($params['post']['action'] == 'del') { // Xoá học viên
                            if($params['post']['student_id']) {
                                $params['id'] = $params['post']['student_id'];
                                $params['post']['status'] = 3;
                                $StudentTb->saveData($params);

                                $StudentAttendancesTb = new StudentAttendancesTb();
                                $StudentAttendancesTb->saveData(array(
                                    'student_id' => $params['id'],
                                    'post' => $params['post']
                                ));
                            }
                            return $this->response;
                        }

                        // save data
                        $StudentTb->saveData($params);

                        break;
                    case 'teacher':
                        if($params['post']['action'] == 'create') { // add/edit giáo viên
                            $params['post']['status'] = $params['post']['status'] == 2 ? 2 : 1;
                            $params['post']['role'] = 1;

                            if($params['post']['teacher_id']) {
                                $params['id'] = $params['post']['teacher_id'];
                                if($params['post']['email']) {
                                    unset($params['post']['email']);
                                }
                            }

                            if($params['post']['email']) {
                                // src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'"
                                // src="https://demo3103.seomarketing.edu.vn/test/public_html/uploads/images/2025/03/1742438903-single_info36-logo.png"
                                $template = array(
                                    'subject' => '[[[domain]]] Thông báo kích hoạt tài khoản',
                                    'key' => array('[[domain]]','[[ho-ten]]','[[email]]','[[mat-khau]]','[[role]]'),
                                    'value' => array(
                                        DOMAIN,
                                        $params['post']['fullname'],
                                        $params['post']['email'],
                                        $params['post']['password'],
                                        'Giáo viên',
                                    ),
                                    'body' => '<p style="border-bottom: 1px solid #eee;"><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank"><img alt="Kích hoạt tài khoản" height="43" src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'" style="width: 140px;" /></a></span></span></p>
                                        <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Chào bạn <strong>[[ho-ten]]</strong>,</span></span></p>
                                        <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Tài khoản của bạn đã được kích hoạt trên hệ thống <a href="[[domain]]" target="_blank">[[domain]]</a></span></span></em></strong></span></p>
                                        <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Thông tin tài khoản:</span></span></em></strong></span></p>
                                        <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Email đăng nhập: <strong>[[email]]</strong></span></span></em></p>
                                        <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Mật khẩu: <strong>[[mat-khau]]</strong></span></span></em></p>
                                        <p style="margin-left: 15px;margin-bottom: 15px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Quyền truy cập: <strong>[[role]]</strong></span></span></em></p>
                                        <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Vui lòng đổi mật khẩu cho lần đăng nhập đầu tiên.</span></span></p>
                                        <p style="margin-top: 0;"><span style="font-family:Times New Roman,Times,serif;font-size:16px;"><em><strong>* <u>Ghi chú</u>:</strong> Đây là email thông báo tự động. Vui lòng không phản hồi lại email này!</em></span></p>'
                                );

                                $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                                    'emailTo' => $params['post']['email'],
                                    'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                                    'body' => str_replace($template['key'], $template['value'], $template['body'])
                                ));
                            }
                        } else if($params['post']['action'] == 'del') { // Xoá giáo viên
                            if($params['post']['teacher_id']) {
                                $params['id'] = $params['post']['teacher_id'];
                                $params['post']['status'] = 3;
                                $MemberTb->saveData($params);
                            }
                            return $this->response;
                        }

                        // save data
                        $MemberTb->saveData($params);

                        break;
                    case 'notify':
                        if($params['post']['action'] == 'reply') {
                            $params['post']['user_reply'] = $data['member']['id'];
                            $NotificationTb->saveData($params);

                            $roleName = in_array($data['member']['role'], [2,3,4]) ? '<span class="role">Tư vấn</span>':'';
                            $htmlReply = '<div class="noti-list_item-reply">
                                <h3>'.$data['member']['fullname'].$roleName.'</h3>
                                <p class="reply">'.$params['post']['content'].'</p>
                            </div>';

                            echo json_encode(array('addReply' => true, 'htmlReply' => $htmlReply, 'parent' => $params['post']['parent']));
                            return $this->response;
                        }

                        if($params['post']['action'] == 'close') {
                            $params['id'] = $params['post']['ticket'];
                            $params['post']['status'] = 1;
                            $NotificationTb->saveData($params);
                        }

                        break;
                    default:
                        if($params['post']['action'] == 'create') { // add/edit lớp
                            $errorsImport = array();
                            $dataItem = array();
                            if ($_FILES['import_excel']) {
                                $extension = strtolower(substr($_FILES['import_excel']['name'],(strrpos($_FILES['import_excel']['name'], "."))));
                                $filename = 'import-excel-' . time() . $extension;
                                $path = ROOT_PUBLIC.'/'.UPLOAD_FILES;
                                move_uploaded_file($_FILES['import_excel']['tmp_name'], $path.$filename);

                                if (file_exists($path.$filename)) {
                                    $render = \PHPExcel_IOFactory::createReaderForFile($path.$filename);
                                    $objPHPExcel = $render->load($path.$filename);
                                    $rows = $objPHPExcel->getActiveSheet()->toArray();
                                    $headersTemplate = $this->headersTemplate();

                                    // check sku file excel
                                    // $check_sku = $this->hasDuplicatedValues($objPHPExcel);
                                    // $line_sku = $this->lineDuplicateRows($objPHPExcel);
                                    // if($line_sku){
                                    //     $errorsImport[] = array(
                                    //         'line' => $line_sku,
                                    //         'label' => 'Mã sản phẩm',
                                    //         'code' => 'DUPLICATE_CHECK'
                                    //     );
                                    // }

                                    // Validate header
                                    $headers = array_shift($rows);
                                    foreach($headers as $columnIndex => $header) {
                                        $columnLetter = \PHPExcel_Cell::stringFromColumnIndex($columnIndex) . '1';
                                        if ($header != $headersTemplate[$columnLetter]['title']) {
                                            $errorsImport[] = array('message' => 'File nhập liệu không đúng. Vui lòng <b>Tải File Mẫu nhập liệu Học viên</b> và thực hiện lại!');
                                            array_map('unlink', glob($path.'/import-*'));
                                            echo json_encode(array('errorsImport' => $errorsImport));
                                            return $this->response;
                                        }
                                    }

                                    // Empty data
                                    if (count($rows) == 0) {
                                        $errorsImport[] = array('message' => 'Danh sách chưa có dữ liệu để thêm');
                                        array_map('unlink', glob($path.'/import-*'));
                                        echo json_encode(array('errorsImport' => $errorsImport));
                                        return $this->response;
                                    }

                                    // Validate content

                                    $headerTitle = array_reduce($headersTemplate, function($carry = array(), $item) {
                                        $carry[$item['field'].$item['name']] = $item['title'];
                                        return $carry;
                                    });


                                    foreach($rows as $rowIndex => $row) {
                                        $line = $rowIndex + 2; // 2 is begin of row data
                                        if(empty($row[0]) && empty($row[1]) && empty($row[2]))
                                            continue;
                                        if(empty($row[0])) {
                                            $errorsImport[] = array('label' => $headerTitle['fullname'], 'line' => $line, 'message' => 'Thông tin bắt buộc nhập');
                                        } if (empty($row[1])) {
                                            $errorsImport[] = array('label' => $headerTitle['email'], 'line' => $line, 'message' => 'Thông tin bắt buộc nhập');
                                        } if (empty($row[2])) {
                                            $errorsImport[] = array('label' => $headerTitle['phone'], 'line' => $line, 'message' => 'Thông tin bắt buộc nhập');
                                        }

                                        $student['post'] = $this->dataTemplate($headersTemplate, $row);
                                        if($student['post']['birthday']) {
                                            $student['post']['birthday'] = date('d/m/Y', strtotime(str_replace('-', '/', $student['post']['birthday'])));
                                        }
                                        $dataItem[] = $student['post'];
                                    }

                                    // check errors
                                    if (!empty($errorsImport)) {
                                        echo json_encode(array('errorsImport' => $errorsImport));
                                        array_map('unlink', glob($path.'/import-*'));
                                        return $this->response;
                                    }

                                    // Delete file after upload
                                    array_map('unlink', glob($path.'/import-*'));
                                }
                            }

                            $params['post']['status'] = $params['post']['status'] == 2 ? 2 : 1;

                            if($params['post']['class_id']) {
                                $params['id'] = $params['post']['class_id'];
                            } else {
                                if($params['post']['teacher_id']) {
                                    // Gửi mail cho giáo viên
                                    $teacher = $MemberTb->getItem(array('id' => $params['post']['teacher_id'], 'column' => array('id','email')));
                                    if($teacher['email']) {
                                        $days = $params['post']['day_of_week'];
                                        sort($days);

                                        $mapDay = [
                                            2 => 'Thứ 2',
                                            3 => 'Thứ 3',
                                            4 => 'Thứ 4',
                                            5 => 'Thứ 5',
                                            6 => 'Thứ 6',
                                            7 => 'Thứ 7',
                                            8 => 'Chủ Nhật',
                                        ];

                                        $dayNames = [];
                                        foreach ($days as $day) {
                                            if (isset($mapDay[$day])) {
                                                $dayNames[] = $mapDay[$day];
                                            }
                                        }

                                        $buoiHoc = implode(', ', $dayNames);

                                        $template = array(
                                            'subject' => '[[[domain]]] Bạn vừa được phân công dạy lớp [[ten-lop]]',
                                            'key' => array('[[domain]]','[[ho-ten]]','[[ten-lop]]','[[ngay-bat-dau]]','[[ngay-ket-thuc]]','[[buoi-hoc]]','[[so-buoi-day]]','[[gio-hoc]]'),
                                            'value' => array(
                                                DOMAIN,
                                                $teacher['fullname'],
                                                $params['post']['name'],
                                                $params['post']['start_date'],
                                                $params['post']['end_date_auto'] ? $params['post']['end_date_auto'] : $params['post']['end_date'],
                                                $buoiHoc,
                                                $params['post']['soBuoi'],
                                                $params['post']['session_times'],
                                            ),
                                            'body' => '<p style="border-bottom: 1px solid #eee;"><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank"><img alt="Kích hoạt tài khoản" height="43" src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'" style="width: px; height: 43px;" /></a></span></span></p>
                                                <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Chào bạn <strong>[[ho-ten]]</strong>,</span></span></p>
                                                <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Bạn vừa được phân công làm giáo viên của lớp [[ten-lop]] trên hệ thống <a href="[[domain]]" target="_blank">[[domain]]</a></span></span></em></strong></span></p>
                                                <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Thông tin chi tiết:</span></span></em></strong></span></p>
                                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Tên lớp học: <strong>[[ten-lop]]</strong></span></span></em></p>
                                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Ngày bắt đầu: <strong>[[ngay-bat-dau]]</strong></span></span></em></p>
                                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Ngày kết thúc: <strong>[[ngay-ket-thuc]]</strong></span></span></em></p>
                                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Số buổi dạy: <strong>[[so-buoi-day]] buổi</strong></span></span></em></p>
                                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Buổi học: <strong>[[buoi-hoc]]</strong></span></span></em></p>
                                                <p style="margin-left: 15px;margin-bottom: 15px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Giờ học: <strong>[[gio-hoc]]</strong></span></span></em></p>
                                                <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Vui lòng đăng nhập vào tài khoản giáo viên của bạn vào hệ thống&nbsp;</span></span><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank">[[domain]]</a></span></span></em></strong></span><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"> để xem chi tiết.</span></span></p>
                                                <p style="margin-top: 0;"><span style="font-family:Times New Roman,Times,serif;font-size:16px;"><em><strong>* <u>Ghi chú</u>:</strong> Đây là email thông báo tự động. Vui lòng không phản hồi lại email này!</em></span></p>'
                                        );

                                        $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                                            'emailTo' => $teacher['email'],
                                            'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                                            'body' => str_replace($template['key'], $template['value'], $template['body'])
                                        ));
                                    }
                                }
                            }

                            if($params['post']['teacher_id'] && $params['post']['consultant_id']) {
                                $classId = $ClassTb->saveData($params);

                                // Insert data
                                if ($dataItem && empty($errorsImport)) {
                                    foreach($dataItem as $row) {
                                        $post = $row;
                                        $post['class_id'] = $classId;
                                        $StudentTb->saveData(array('post' => $post));
                                    }
                                }
                            } else {
                                echo json_encode(array('errorAdd' => true));
                                return $this->response;
                            }

                            // if($classId && $params['post']['teacher_id']) {
                            //     $array = array(
                            //         'class_id' => $classId,
                            //         'teacher_id' => $params['post']['teacher_id']
                            //     );

                            //     $searchTimekeeping = $TimekeepingTb->getItem($array);
                            //     $searchSalaries = $SalariesTb->getItem($array);

                            //     if($searchTimekeeping['id']) {
                            //         $paramsTimekeeping['id'] = $searchTimekeeping['id'];
                            //         $array['class_id'] = $searchTimekeeping['class_id'];
                            //     }

                            //     if($searchSalaries['id']) {
                            //         $paramsSalaries['id'] = $searchSalaries['id'];
                            //     }

                            //     // add/edit item chấm công & lương cho GV tương ứng
                            //     $paramsTimekeeping['post'] = $paramsSalaries['post'] = $array;
                            //     $TimekeepingTb->saveData($paramsTimekeeping);
                            //     $SalariesTb->saveData($paramsSalaries);
                            // }
                        } else if($params['post']['action'] == 'del') { // Xoá lớp
                            if($params['post']['class_id']) {
                                $params['id'] = $params['post']['class_id'];
                                $params['post']['status'] = 3;
                                $ClassTb->saveData($params);
                            }
                            return $this->response;
                        }

                        break;
                }
            }

            echo json_encode(array('redirect' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'].(isset($_GET['action']) ? '&changed=true':'?changed=true')));
            return $this->response;
        }

        // SEO || SNIPPET
        $name = $data['listSidebar'][($_GET['action'] ? $_GET['action'] : 'class')]['name'] ? $data['listSidebar'][($_GET['action'] ? $_GET['action'] : 'class')]['name'] : $data['listSidebar']['class']['name'];
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = array(
            'name' => $name,
            'title' => $name,
            'link' => 'consultant-78.html'
        );

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'title' => $name,
            'keyword' => $name,
            'description' => $name,
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => $data['menu'],
            'noindex' => true
        ));

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = array('vi' => 'thong-tin-tai-khoan', 'en' => 'en/account-info'); // Nếu có ngôn ngữ LANG

        return new ViewModel($data);
    }

    public function accountantAction() // 79.html
    {
        $params = $this->params()->fromRoute();
        $translator = $this->getServiceLocator()->get('translator');
        $data = array('action' => 'accountant');

        $session = new Container('frontend');
        $data['logged'] = $session->logged;
        $data['listSidebar'] = $this->_listSidebar[$data['logged']['role']];

        // lấy danh sách giáo viên

        $MemberTb = new MemberTb();
        $ClassTb = new ClassTb();
        $TimekeepingTb = new TimekeepingTb();

        $data['listTeacher'] = $MemberTb->listItem(array(
            'status' => 1,
            'role' => 1,
        ));

        // Lấy ngày hiện tại
        $currentDay = date("j");
        $currentMonth = date("n");
        $currentYear = date("Y");

        // Lấy tháng & năm từ URL hoặc dùng tháng hiện tại
        $month = $currentMonth;
        $year = $currentYear;

        if (isset($_GET['month']) && preg_match('/^(0[1-9]|1[0-2])-\d{4}$/', $_GET['month'])) {
            list($month, $year) = explode('-', $_GET['month']);
            $month = (int)$month;
            $year = (int)$year;
        }

        // Xác định số ngày trong tháng
        $totalDays = ($month == 2) ? (($year % 4 == 0 && ($year % 100 != 0 || $year % 400 == 0)) ? 29 : 28)
                    : cal_days_in_month(CAL_GREGORIAN, $month, $year);

        // Tạo danh sách ngày trong tháng
        $data['daysArray'] = [];
        for ($i = 1; $i <= $totalDays; $i++) {
            $data['daysArray'][] = [
                "date" => sprintf("%02d/%02d/%04d", $i, $month, $year), // Định dạng DD/MM/YYYY
                "current" => ($i == $currentDay && $month == $currentMonth && $year == $currentYear),
                "status" => "", // Mặc định rỗng
                "checkin" => 0  // Mặc định chưa checkin
            ];
        }

        $data['qualifiedTeachers'] = 0;
        foreach ($data['listTeacher'] as $i => $teacher) {
            $data['listTeacher'][$i]['bank_full'] = $teacher['bank_number'].' - '.$teacher['bank_name'];

            // lấy danh sách lớp của gv đang dạy trong tháng
            $listClassMap = $ClassTb->listItem(array(
                'teacher_id' => $teacher['id'],
                'orderby' => 'class.id ASC',
                'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
            ));

            //  Lấy danh sách chấm công của GV
            $timekeeping = $TimekeepingTb->listItem(array(
                'teacher_id' => $teacher['id'],
                'columns' => array('class_id','teacher_id','date_checkin')
            ));

            // Danh sách id lớp đang map với GV
            $classIdMap = array_unique(array_column($listClassMap, 'id'));

            // Lấy danh sách lớp mà GV đó đã từng dạy (tính luôn trường hợp đang dạy mà ngừng hoặc chuyển lớp khác)
            $taughtClasses = array_unique(array_column($timekeeping, 'class_id'));

            // Gốp danh sách ID lại để có ds lớp cuối cùng bao gồm lớp đang map và lớp đã từng dạy
            $listIdClassFinal = array_unique(array_merge($classIdMap, $taughtClasses));

            if(!empty($listIdClassFinal)) {
                // lấy danh sách lớp của gv đang dạy trong tháng
                $listClass = $ClassTb->listItem(array(
                    'list_id' => $listIdClassFinal,
                    'orderby' => 'class.id ASC',
                    'columns' => array('id','name','makeup_date','off_date','start_date','end_date','session_salaries')
                ));

                // Lấy danh sách chấm công của gv đang dạy cho từng lớp
                foreach ($listClass as $k => $value) {
                    $listCheckin = [];
                    foreach ($timekeeping as $item) {
                        if($item['class_id'] == $value['id']) {
                            $listCheckin[] = $item['date_checkin'];
                        }
                    }
                    $listClass[$k]['timekeeping'] = $listCheckin;
                }

                // Duyệt qua từng lớp và gán danh sách ngày
                foreach ($listClass as &$class) {
                    $updatedDaysArray = [];

                    foreach ($data['daysArray'] as $day) {
                        $status = "";
                        $checkin = 0;

                        // Xác định trạng thái
                        $makeupDate = json_decode($class["makeup_date"], true);
                        $offDate = json_decode($class["off_date"], true);
                        if (in_array($day["date"], $makeupDate)) {
                            $status = "Học bù";
                        } elseif (in_array($day["date"], $offDate)) {
                            $status = "OFF";
                        }

                        // Kiểm tra checkin
                        if (in_array($day["date"], $class["timekeeping"])) {
                            $checkin = 1;
                        }

                        $updatedDaysArray[] = [
                            "date" => $day["date"],
                            "current" => $day["current"],
                            "status" => $status,
                            "checkin" => $checkin
                        ];
                    }

                    // Thêm danh sách ngày vào lớp học
                    $class["days"] = $updatedDaysArray;
                }

                // Lọc các lớp có thời gian học nằm trong tháng lấy từ $_GET['month']
                $listClass = array_filter($listClass, function ($class) use ($month, $year) {
                    $startDate = \DateTime::createFromFormat('d/m/Y', $class["start_date"]);
                    $endDate = \DateTime::createFromFormat('d/m/Y', $class["end_date"]);

                    if (!$startDate || !$endDate) return false; // Bỏ qua nếu ngày không hợp lệ

                    // Lấy danh sách các ngày học bù
                    $makeupDays = isset($class["makeup_date"]) ? json_decode($class["makeup_date"], true) : [];

                    // Kiểm tra nếu có ngày học bù trong tháng đang xét
                    $hasMakeupInMonth = array_filter($makeupDays, function ($date) use ($month, $year) {
                        $makeupDate = \DateTime::createFromFormat('d/m/Y', $date);
                        return $makeupDate && $makeupDate->format('n') == $month && $makeupDate->format('Y') == $year;
                    });

                    // Xác định phạm vi tháng cần kiểm tra
                    $monthStart = new \DateTime("$year-$month-01");
                    $monthEnd = clone $monthStart;
                    $monthEnd->modify('last day of this month');

                    // Điều kiện lọc chính xác
                    return (
                        // Ngày bắt đầu hoặc ngày kết thúc nằm trong tháng
                        ($startDate->format('n') == $month && $startDate->format('Y') == $year) ||
                        ($endDate->format('n') == $month && $endDate->format('Y') == $year) ||
                        // Khoảng thời gian lớp học bao phủ ít nhất một ngày trong tháng
                        ($startDate <= $monthEnd && $endDate >= $monthStart) ||
                        // Có ít nhất một ngày học bù trong tháng
                        !empty($hasMakeupInMonth)
                    );
                });

                // Kiểm tra xem GV có đủ điều kiện chấm lương trong tháng
                if($listClass) {
                    $data['qualifiedTeachers']++;
                    $data['listTeacher'][$i]['qualifiedTeachers'] = true;
                }

                // Duyệt qua từng lớp học
                foreach ($listClass as &$class) {
                    $totalDaysTaught = 0;

                    // Duyệt qua danh sách ngày của lớp
                    foreach ($class['days'] as $day) {
                        $dateParts = explode("/", $day['date']); // Tách ngày/tháng/năm
                        $dayMonth = (int)$dateParts[1]; // Lấy tháng
                        $dayYear = (int)$dateParts[2]; // Lấy năm

                        // Kiểm tra nếu ngày thuộc tháng & năm cần tính và có checkin
                        if ($dayMonth == $month && $dayYear == $year && $day['checkin'] > 0) {
                            $totalDaysTaught++;
                        }
                    }

                    // Thêm số ngày đã dạy vào mảng dữ liệu của lớp
                    $class['total_days_taught'] = $totalDaysTaught;
                }

                $listClass = array_values($listClass);

                // Tính lương cho từng giáo viên
                $totalSalaries = $totalTeaching = $totalOfClass = 0;
                foreach ($listClass as $value) {
                    $totalOfClass = $value['session_salaries'] * $value['total_days_taught'];
                    $totalTeaching += $totalOfClass;
                }

                $ConfigTb = new ConfigTb();
                $config = $ConfigTb->getItem(array('id' => 1));

                $SalariesTb = new SalariesTb();
                $upsell = $SalariesTb->getItem(array(
                    'teacher_id' => $teacher['id'],
                    'month' => $month.'/'.$year
                ));

                if($teacher['time_work'] == 2 && $config['tax'] && $config['tax'] > 0) {
                    $totalTeaching = $totalTeaching * ((100 - $config['tax']) / 100);
                }

                $totalUpsell = $totalOther = 0;
                foreach ($upsell['upsell'] as $value) {
                    $quantity = $value['quantity'] && $value['quantity'] > 0 ? $value['quantity'] : 1;
                    $money = str_replace('.','', $value['money']);
                    $totalUpsell += $money * $quantity;
                }

                $totalOther = str_replace('.','', $upsell['print']) + str_replace('.','', $upsell['zoom']) + str_replace('.','', $upsell['other']);
                $totalSalaries = $totalTeaching + $totalUpsell + $totalOther;

                $data['listTeacher'][$i]['totalTeaching'] = $totalTeaching;
                $data['listTeacher'][$i]['totalUpsell'] = $totalUpsell;
                $data['listTeacher'][$i]['totalOther'] = $totalOther;
                $data['listTeacher'][$i]['totalSalaries'] = $totalSalaries;
            }
        }

        // SEO || SNIPPET
        $name = $data['listSidebar'][($_GET['action'] ? $_GET['action'] : 'class')]['name'] ? $data['listSidebar'][($_GET['action'] ? $_GET['action'] : 'payment')]['name'] : $data['listSidebar']['payment']['name'];
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = array(
            'name' => $name,
            'title' => $name,
            'link' => 'accountant-79.html'
        );

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'title' => $name,
            'keyword' => $name,
            'description' => $name,
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => $data['menu'],
            'noindex' => true
        ));

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = array('vi' => 'thong-tin-tai-khoan', 'en' => 'en/account-info'); // Nếu có ngôn ngữ LANG

        return new ViewModel($data);
    }

    public function signUpAction() // 72.html
    {
        $params = $this->params()->fromRoute();
        $translator = $this->getServiceLocator()->get('translator');
        if ($this->getRequest()->isPost()) {
            $params['post'] = $this->getRequest()->getPost()->toArray();
            $MemberTb = new MemberTb();
            $member = $MemberTb->getItem(array('email' => $params['post']['email']));
            if ($member) {
                $data['setTemplate'] = array(
                    'notify' => $translator->translate('Tài khoản đã tồn tại.<br/>Vui lòng đăng ký tài khoản khác.'),
                    'reload' => false
                );
            } else {
                $params['post']['status'] = 1;
                $MemberTb->saveData($params);
                $data['setTemplate'] = array(
                    'notify' => $translator->translate('Bạn đã đăng ký tài khoản thành công.'),
                    'reload' => true
                );
            }
            echo json_encode($data['setTemplate']);
        }
        return $this->getResponse();
    }

    public function signInAction() // 73.html
    {
        $params = $this->params()->fromRoute();
        $translator = $this->getServiceLocator()->get('translator');
        if ($this->getRequest()->isPost()) {
            $params['post'] = $this->getRequest()->getPost()->toArray();
            $MemberTb = new MemberTb();
            $member = $MemberTb->login($params);
            if ($member) {
                $this->_session->logged = $member;
                if (isset($params['post']['rememberPW'])) {
                    setcookie('logged', $params['post']['email'], time() + 720000,'/', DOMAIN);
                }

                switch ($member['role']) {
                    case 1:
                        $redirect = URL.'master-consultant-77.html';
                        break;
                    case 2:
                    case 3:
                        $redirect = URL.'consultant-78.html';
                        break;
                    case 4:
                        $redirect = URL.'accountant-79.html';
                        break;
                    default:
                        $redirect = URL.'teacher-76.html';
                        break;
                }

                echo json_encode(array('redirect' => $redirect));
            } else {
                echo json_encode(array('redirect' => URL.'?failed'));
            }
        }
        return $this->getResponse();
    }

    public function signOutAction() // 74.html
    {
        $this->_session->offsetSet('logged', '');
        if ($_COOKIE["logged"]) {
            setcookie('logged', null, time() - 1, '/', DOMAIN);
            unset($_COOKIE['logged']);
        }
        return $this->redirect()->toUrl(URL);
    }

    public function passwordAction() // 75.html
    {
        $params = $this->params()->fromRoute();
        $translator = $this->getServiceLocator()->get('translator');
        $request = $this->getRequest();
        if ($request->isPost()) {
            $params['post'] = $request->getPost()->toArray();
            $MemberTb = new MemberTb();
            if ($this->_session->logged){ // thay đổi mật khẩu khi đã đăng nhập
                $params['post']['email'] = $this->_session->logged['email'];
                $MemberTb->changePassword($params);
                echo json_encode(array('redirect' => URL.'profile-71.html?pwchanged'));
            } else { // Thay đổi mật khẩu ngẫu nhiên khi quên mật khẩu
                $member = $MemberTb->getItem(array('email' => $params['post']['email'], 'status' => 1));
                if (!$member) {
                    $data['error'] = true;
                    echo json_encode($data['error']);
                } else if (!$params['post']['checkAjax']){
                    $params['post']['password'] = \Backend\View\Helper\Rand::string();
                    $MemberTb->changePassword($params);
                    if ($params['post']['email']) {
                        $InfoTb = new InfoTb();
                        $data['info'] = $InfoTb->getItem();
                        $template = array(
                            'subject' => '[[[domain]]] Thông báo cấp lại mật khẩu mới',
                            'key' => array('[[domain]]','[[ho-ten]]','[[email]]','[[mat-khau]]'),
                            'value' => array(
                                DOMAIN,
                                $member['fullname'],
                                $member['email'],
                                $params['post']['password']
                            ),
                            'body' => '<p style="border-bottom: 1px solid #eee;"><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;"><a href="[[domain]]" target="_blank"><img alt="Kích hoạt tài khoản" height="43" src="'.URL.UPLOAD_IMAGES.date('Y/m',explode('-',$data['info']['logo'])[0]).'/'.$data['info']['logo'].'" style="width: 140px;" /></a></span></span></p>
                                <p><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Chào bạn <strong>[[ho-ten]]</strong>,</span></span></p>
                                <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Tài khoản của bạn đã được cấp lại mật khẩu mới trên hệ thống <a href="[[domain]]" target="_blank">[[domain]]</a></span></span></em></strong></span></p>
                                <p style="margin-bottom: 10px;"><span style="color:#1f4e79;"><strong><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">Thông tin tài khoản:</span></span></em></strong></span></p>
                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Email đăng nhập: <strong>[[email]]</strong></span></span></em></p>
                                <p style="margin-left: 15px;margin-bottom: 7px;margin-top: 7px;"><em><span style="font-size:16px;"><span style="font-family:Times New Roman,Times,serif;">. Mật khẩu: <strong>[[mat-khau]]</strong></span></span></em></p>
                                <p style="margin-top: 0;"><span style="font-family:Times New Roman,Times,serif;font-size:16px;"><em><strong>* <u>Ghi chú</u>:</strong> Đây là email thông báo tự động. Vui lòng không phản hồi lại email này!</em></span></p>'
                        );

                        $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                            'emailTo' => $member['email'],
                            'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                            'body' => str_replace($template['key'], $template['value'], $template['body'])
                        ));
                    }
                    echo json_encode(array('redirect' => URL.'?success'));
                } else {
                    echo json_encode(false);
                }
            }
        }
        return $this->getResponse();
    }

    public function checkAction() // 80.html
    {
        $params = $this->params()->fromRoute();
        $translator = $this->getServiceLocator()->get('translator');
        $request = $this->getRequest();
        if ($request->isPost()) {
            $params['post'] = $request->getPost()->toArray();
            $MemberTb = new MemberTb();

            $member = $MemberTb->getItem(array('email' => $params['post']['email']));
            if ($member) {
                $data['error'] = true;
                echo json_encode($data['error']);
            } else {
                echo json_encode(false);
            }
        }
        return $this->getResponse();
    }

    // Lấy danh sách dữ liệu Teacher không phân trang
    public function listTeacher($params = null)
    {
        $MemberTb = new MemberTb();
        return $MemberTb->listItem($params);
    }

    // Lấy dang sách dữ liệu Teacher có phân trang
    public function listPageTeacher($params = null)
    {
        if (empty($params['limit'])) {
            $params['limit'] = 0;
        }
        if (empty($params['number_page'])) {
            $params['number_page'] = 5;
        }
        if ($params['page']) {
            $params['offset'] = ($params['page'] - 1) * $params['limit'];
        } else {
            $params['page'] = 1;
        }

        $paginator = new \Zend\Paginator\Paginator(new \Zend\Paginator\Adapter\ArrayAdapter($this->listTeacher(array_merge($params, array('limit' => 0)))));
        $paginator->setCurrentPageNumber($params['page']);
        $paginator->setItemCountPerPage($params['limit']);
        $paginator->setPageRange($params['number_page']);

        return array(
            'params' => $params,
            'paginator' => $paginator,
            'list' => $paginator->getCurrentItems()
        );
    }

    // Lấy danh sách dữ liệu Class không phân trang
    public function listClass($params = null)
    {
        $ClassTb = new ClassTb();
        return $ClassTb->listItem($params);
    }

    // Lấy dang sách dữ liệu Class có phân trang
    public function listPageClass($params = null)
    {
        if (empty($params['limit'])) {
            $params['limit'] = 0;
        }
        if (empty($params['number_page'])) {
            $params['number_page'] = 5;
        }
        if ($params['page']) {
            $params['offset'] = ($params['page'] - 1) * $params['limit'];
        } else {
            $params['page'] = 1;
        }

        $paginator = new \Zend\Paginator\Paginator(new \Zend\Paginator\Adapter\ArrayAdapter($this->listClass(array_merge($params, array('limit' => 0)))));
        $paginator->setCurrentPageNumber($params['page']);
        $paginator->setItemCountPerPage($params['limit']);
        $paginator->setPageRange($params['number_page']);

        return array(
            'params' => $params,
            'paginator' => $paginator,
            'list' => $paginator->getCurrentItems()
        );
    }

    // Lấy danh sách dữ liệu Student không phân trang
    public function listStudent($params = null)
    {
        $StudentTb = new StudentTb();
        return $StudentTb->listItem($params);
    }

    // Lấy dang sách dữ liệu Student có phân trang
    public function listPageStudent($params = null)
    {
        if (empty($params['limit'])) {
            $params['limit'] = 0;
        }
        if (empty($params['number_page'])) {
            $params['number_page'] = 5;
        }
        if ($params['page']) {
            $params['offset'] = ($params['page'] - 1) * $params['limit'];
        } else {
            $params['page'] = 1;
        }

        $paginator = new \Zend\Paginator\Paginator(new \Zend\Paginator\Adapter\ArrayAdapter($this->listStudent(array_merge($params, array('limit' => 0)))));
        $paginator->setCurrentPageNumber($params['page']);
        $paginator->setItemCountPerPage($params['limit']);
        $paginator->setPageRange($params['number_page']);

        return array(
            'params' => $params,
            'paginator' => $paginator,
            'list' => $paginator->getCurrentItems()
        );
    }

    public function lineDuplicateRows($objPHPExcel, $columns = 'A', $separator = '|') {
        $worksheet = $objPHPExcel->getActiveSheet();

        $cells = array();
        $line = array();

        foreach ($worksheet->getRowIterator() as $row) {
            $rowIndex = $row->getRowIndex();
            if (is_array($columns)) {
                $cellValue = '';
                foreach ($columns as $column) {
                    $cellValue .= $worksheet->getCell($column.$rowIndex)->getValue() . $separator;
                }
            } else {
                $cellValue = $worksheet->getCell($columns.$rowIndex)->getValue();
            }
            array_push($cells, $cellValue);
        }

        $toRemove = array_keys(array_diff_assoc($cells, array_unique($cells)));

        for ($i = count($toRemove)-1; $i > -1; $i--) {
            array_unshift($line, $toRemove[$i]+1);
        }

        return $line;
    }

    public function normalizeNumber($input) {
        return is_numeric($input) ? intval(str_replace(',', '', ceil($input))) : intval(str_replace(',', '', trim($input)));
    }

    public function dataTemplate($headers, $row)
    {
        $data = array();

        foreach($row as $columnIndex => $columnValue) {
            $columnLetter = \PHPExcel_Cell::stringFromColumnIndex($columnIndex) . '1';
            $header = $headers[$columnLetter];
            $value = $columnValue ?? '';
            switch ($header['field']) {
                case 'multi_input':
                case 'list_select_id':
                    $data[$header['field']][$header['name']] = $value;
                break;
                default:
                    $data[$header['field']] = $value;
                break;
            }
        }

        return $data;
    }

    public function headersTemplate()
    {
        $headers = array(
            array('order' => 1, 'field' => 'fullname', 'title' => 'Tên khách hàng'),
            array('order' => 2, 'field' => 'phone', 'title' => 'Điện thoại'),
            array('order' => 3, 'field' => 'email', 'title' => 'Email'),
            array('order' => 4, 'field' => 'note', 'title' => 'Ghi chú mới nhất'),
        );

        usort($headers, function ($item1, $item2) {
            return $item1['order'] <=> $item2['order'];
        });

        $actualHeaders = array();
        foreach($headers as $i => $header) {
            $columnLetter = \PHPExcel_Cell::stringFromColumnIndex($i) . '1';
            $actualHeaders[$columnLetter] = $header;
        }

        return $actualHeaders;
    }

    public function downloadAction()
    {
        // Create new PHPExcel object
        $objPHPExcel = new \PHPExcel();

        // Add some data
        $headers = $this->headersTemplate();
        foreach ($headers as $columnLetter => $column) {
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($columnLetter, $column['title'])->getStyle($columnLetter)->getFont()->setBold(true);
        }

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Sheet1');


        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="01simple.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_start();
        $objWriter->save('php://output');
        $xlsData = ob_get_contents();
        ob_end_clean();

        $response =  array(
            'op' => 'ok',
            'name' => 'Mẫu nhập dữ liệu Học viên.xlsx',
            'file' => "data:application/vnd.ms-excel;base64,".base64_encode($xlsData)
        );

        echo json_encode($response);

        return $this->getResponse();
    }

    public function sortStudentsByName($students) {
        if (empty($students)) {
            return [];
        }

        usort($students, function ($a, $b) {
            // Tách tên cuối cùng
            $lastNameA = trim(substr(strrchr($a['fullname'], ' '), 1)); // Lấy phần sau khoảng trắng cuối cùng
            $lastNameB = trim(substr(strrchr($b['fullname'], ' '), 1));

            // So sánh tên theo thứ tự bảng chữ cái
            return strcasecmp($lastNameA, $lastNameB);
        });

        return $students;
    }

    public function generateSchedule($startDate, $endDate, $weekdays, $makeupDays = [], $offDays = []) {
        // Lấy ngày hiện tại theo định dạng d/m/Y
        $today = date('d/m/Y');
        $todayObj = \DateTime::createFromFormat('d/m/Y', $today); // Chuyển `$today` thành DateTime để so sánh
        $activeNext = null; // Biến để lưu ngày học tiếp theo

        // Chuyển đổi ngày bắt đầu & kết thúc thành DateTime
        $start = \DateTime::createFromFormat('d/m/Y', $startDate);
        $end = \DateTime::createFromFormat('d/m/Y', $endDate);

        // Chuyển đổi danh sách thứ từ chuỗi sang số nguyên và sắp xếp
        $validDays = array_map('intval', $weekdays);
        sort($validDays);

        // Chuyển đổi danh sách ngày học bù và ngày nghỉ thành định dạng d/m/Y
        $makeupDays = array_map(function ($date) {
            return \DateTime::createFromFormat('d/m/Y', $date)->format('d/m/Y');
        }, $makeupDays);

        $offDays = array_map(function ($date) {
            return \DateTime::createFromFormat('d/m/Y', $date)->format('d/m/Y');
        }, $offDays);

        $schedule = [];
        $sessionCount = 1;
        $foundActive = false; // Biến kiểm tra xem có ngày học nào trùng hôm nay không

        // Tìm ngày hợp lệ đầu tiên
        while ($start <= $end && !in_array((int)$start->format('N') + 1, $validDays)) {
            $start->modify('+1 day');
        }

        // Lặp từ ngày hợp lệ đầu tiên đến ngày kết thúc
        while ($start <= $end) {
            $currentDate = $start->format('d/m/Y'); // Lấy ngày tháng hiện tại
            $currentDateObj = clone $start; // Chỉ dùng để check `done`
            $dayOfWeek = (int)$start->format('N') + 1; // Chuyển đổi thứ

            // Kiểm tra nếu ngày này có trong danh sách nghỉ
            $isOffDay = in_array($currentDate, $offDays);

            // Xác định loại buổi học
            if (in_array($currentDate, $makeupDays)) {
                $schedule[] = [
                    'label' => "Học bù",
                    'date' => $currentDate,
                    'active' => ($currentDate === $today),
                    'active_next' => false,
                    'done' => ($currentDateObj < $todayObj), // So sánh chính xác bằng DateTime
                    'off' => $isOffDay // Đánh dấu ngày nghỉ nếu có
                ];
                if ($currentDate === $today) $foundActive = true;
            } elseif (in_array($dayOfWeek, $validDays)) {
                $schedule[] = [
                    'label' => "Buổi " . $sessionCount,
                    'date' => $currentDate,
                    'active' => ($currentDate === $today),
                    'active_next' => false,
                    'done' => ($currentDateObj < $todayObj), // So sánh chính xác bằng DateTime
                    'off' => $isOffDay // Đánh dấu ngày nghỉ nếu có
                ];
                if ($currentDate === $today) $foundActive = true;
                $sessionCount++;
            }

            // Tìm ngày hợp lệ tiếp theo
            do {
                $start->modify('+1 day');
                $nextDay = (int)$start->format('N') + 1;
                $nextDate = $start->format('d/m/Y');
            } while (!in_array($nextDay, $validDays) && !in_array($nextDate, $makeupDays) && $start <= $end);
        }

        // Thêm các ngày học bù vượt quá endDate
        foreach ($makeupDays as $makeupDay) {
            $makeupDateObj = \DateTime::createFromFormat('d/m/Y', $makeupDay);
            if ($makeupDateObj > $end) {
                $schedule[] = [
                    'label' => "Học bù",
                    'date' => $makeupDay,
                    'active' => ($makeupDay === $today),
                    'active_next' => false,
                    'done' => ($makeupDateObj < $todayObj),
                    'off' => in_array($makeupDay, $offDays)
                ];
            }
        }

        // Nếu hôm nay không có trong danh sách, tìm ngày học tiếp theo để set active_next
        $setNext = !$foundActive; // Nếu hôm nay không có active, sẽ set active_next cho buổi học kế tiếp
        foreach ($schedule as $index => $session) {
            $sessionDateObj = \DateTime::createFromFormat('d/m/Y', $session['date']);
            if ($sessionDateObj > $todayObj) {
                if ($setNext) {
                    while (isset($schedule[$index]) && $schedule[$index]['off']) {
                        $index++;
                    }
                    if (isset($schedule[$index])) {
                        $schedule[$index]['active_next'] = true;
                    }
                    break;
                }
            }
        }

        return $schedule;
    }

    public function checkContinuousAbsence($schedule, $attendanceRecords, $thresholdDays = 3) {
        // Chuyển danh sách điểm danh thành mảng với key là ngày
        $attendanceMap = [];
        foreach ($attendanceRecords as $record) {
            $attendanceMap[$record['session_date']] = $record['checkin'];
        }

        $absentCount = 0;
        $absentSessions = [];

        foreach ($schedule as $session) {
            $sessionDate = $session['date']; // Lấy ngày từ lịch học

            // Kiểm tra nếu có điểm danh ngày này không
            if (isset($attendanceMap[$sessionDate])) {
                $checkinStatus = $attendanceMap[$sessionDate];

                // Nếu là CP hoặc KP thì tăng biến đếm
                if ($checkinStatus === 'CP' || $checkinStatus === 'KP') {
                    $absentCount++;
                    $absentSessions[] = $session; // Lưu lại buổi vắng

                    // Nếu vắng đủ số ngày liên tiếp theo ngưỡng truyền vào thì trả về danh sách
                    if ($absentCount >= $thresholdDays) {
                        return [
                            'has_absence' => true,
                            'absent_sessions' => $absentSessions
                        ];
                    }
                } else {
                    // Nếu có mặt (ĐH) thì reset biến đếm và xóa danh sách buổi vắng
                    $absentCount = 0;
                    $absentSessions = [];
                }
            } else {
                // Nếu không có điểm danh thì reset biến đếm
                $absentCount = 0;
                $absentSessions = [];
            }
        }

        return [
            'has_absence' => false,
            'absent_sessions' => []
        ];
    }

    public function checkTeacherConsecutiveOffDays($schedule, $teacherOffDays, $maxConsecutiveOff = 3) {
        // Chuyển danh sách ngày OFF của giáo viên về định dạng d/m/Y
        $teacherOffDays = array_map(function ($date) {
            return \DateTime::createFromFormat('d/m/Y', $date)->format('d/m/Y');
        }, $teacherOffDays);

        $consecutiveCount = 0; // Đếm số ngày nghỉ liên tiếp
        $absentSessions = []; // Lưu danh sách buổi học bị ảnh hưởng tạm thời
        $finalAbsentSessions = []; // Danh sách kết quả cuối cùng

        foreach ($schedule as $session) {
            $date = $session['date'];

            if (in_array($date, $teacherOffDays)) {
                $consecutiveCount++;
                $absentSessions[] = $session; // Thêm buổi bị ảnh hưởng

                if ($consecutiveCount >= $maxConsecutiveOff) {
                    // Nếu đạt ngưỡng, lưu vào danh sách kết quả cuối
                    $finalAbsentSessions = $absentSessions;
                }
            } else {
                // Nếu gặp ngày không nghỉ, reset lại bộ đếm
                $consecutiveCount = 0;
                $absentSessions = [];
            }
        }

        return [
            'has_absence' => !empty($finalAbsentSessions),
            'absent_sessions' => $finalAbsentSessions
        ];
    }
}
?>