<?php

namespace Frontend\Controller;
use Frontend\Model\InfoTb;
use Frontend\Model\MemberTb;
use Frontend\Model\MenuPublicTb;
use Frontend\Model\OrderDetailTb;
use Frontend\Model\OrderTb;
use Frontend\Model\ProductDiscountTb;
use Frontend\Model\ProductTb;
use Zend\Mvc\Controller\AbstractActionController;
use Zend\Session\Container;
use Zend\View\Model\ViewModel;

class OrderController extends AbstractActionController
{
    public function cartAction() // 61.html
    {
        $translator = $this->getServiceLocator()->get('translator');
        $params = $this->params()->fromRoute();
        $data = array('action' => 'order-cart');
        $session = new Container('frontend');
        // $session->offsetSet('cart', ''); // Xóa session

        $data['cart'] = $session->cart;

        // Lấy định nghĩa hiển thị trong menu_code_tb
        $OrderDetailTb = new OrderDetailTb();
        $data['config'] = $OrderDetailTb->config();

        // Xử lý thông qua ajax
        if ($this->getRequest()->isPost()) {
            $params['post'] = $this->getRequest()->getPost()->toArray();
            if (isset($params['post']['product_id'])) {
                $product_id = $params['post']['product_id'];
                $sub_id = $params['post']['sub_id'];
                if ($sub_id) {
                    $session->cart[$product_id]['quantity'] = $session->cart[$product_id]['quantity'] - $session->cart[$product_id]['product_sub'][$sub_id]['quantity'] + $params['post']['quantity'];
                    $session->cart[$product_id]['product_sub'][$sub_id]['quantity'] = $params['post']['quantity'];
                    $session->cart[$product_id]['product_sub'][$sub_id]['price'] = $params['post']['price'];
                } else {
                    $session->cart[$product_id]['price'] = $params['post']['price'];
                    $session->cart[$product_id]['quantity'] = $params['post']['quantity'];
                }
            }
            switch ($params['post']['type']) {
                case 'delete':
                    if ($sub_id) {
                        $session->cart[$product_id]['quantity'] -= $session->cart[$product_id]['product_sub'][$sub_id]['quantity'];
                        unset($session->cart[$product_id]['product_sub'][$sub_id]);
                    }
                    if (empty($session->cart[$product_id]['product_sub'])) {
                        unset($session->cart[$product_id]);
                    }
                break;
                case '': // Thêm sp vào giỏ hàng
                    $session->cart = ($session->cart) ? $session->cart : array();
                    $session->cart[$params['post']['id']] = $params['post'];
                    if ($params['post']['product_sub']) {
                        $session->cart[$params['post']['id']]['quantity'] = 0;
                        foreach ($session->cart[$params['post']['id']]['product_sub'] as $value) {
                            $session->cart[$params['post']['id']]['quantity'] += $value['quantity'];
                        }
                    }
                break;
            }
            return $this->getResponse();
        }

        // SEO || SNIPPET
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = array(
            $MenuPublicTb->getItem(array('active' => 'home', 'columns' => array('title','link'))),
            array('title' => $translator->translate("Thông tin đơn hàng của bạn"))
        );

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'title' => $translator->translate("Thông tin đơn hàng của bạn"),
            'keyword' => $translator->translate("giỏ hàng, đơn hàng"),
            'description' => $translator->translate("Vui lòng kiểm tra lại thông tin đơn hàng trong giỏ hàng của bạn. Bạn có thể tiếp tục mua hàng hoặc tiến hành gửi đặt hàng"),
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => $data['menu'],
            'noindex' => true
        ));

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = array('vi' => 'gio-hang', 'en' => 'en/shopping-cart'); // Nếu có ngôn ngữ LANG

        return new ViewModel($data);
    }

    public function bookingAction() // 62.html
    {
        $translator = $this->getServiceLocator()->get('translator');
        $url = explode('/',$_SERVER['REDIRECT_URL'])[count(explode('/',$_SERVER['REDIRECT_URL']))-1];
        $params = $this->params()->fromRoute();
        $data = array('action' => 'order-booking');
        $session = new Container('frontend');
        if (!$session->cart && $url == $translator->translate('dat-hang-62.html')) {
            return $this->redirect()->toUrl(URL_LANG);
        }
        $MemberTb = new MemberTb();

        if ($url == $translator->translate('dat-hang-62.html')) {
            $data['cart'] = $session->cart;
            $ProductDiscountTb = new ProductDiscountTb();
            $data['discount'] = $ProductDiscountTb->getItem(array('auto' => true));
            if ($data['discount'] && (($data['discount']['expired_number'] >= $data['discount']['remain']))) {
                $data['discount'] = array();
            }
        }
        if ($session->logged) {
            $data['member'] = $session->logged;
        }

        $OrderDetailTb = new OrderDetailTb();
        $data['config'] = $OrderDetailTb->config();

        if ($this->getRequest()->isPost()) {
            $params['post'] = $this->getRequest()->getPost()->toArray();
            if ($url != $translator->translate('dat-hang-62.html')) {
                $params['post']['product_meta'] = json_decode($params['post']['product_meta'], true);
                if (isset($params['post']['quantity'])) {
                    $params['post']['product_meta']['quantity'] = $params['post']['quantity'];
                }
                $data['cart'][] = $params['post']['product_meta'];
            }

            // Tạo tài khoản nếu không phải member
            if ($params['post']['email']) {
                $data['member'] = $MemberTb->getItem(array('email' => $params['post']['email']));
            } else {
                $data['member'] = $MemberTb->getItem(array('phone' => $params['post']['phone']));
            }

            // Lưu lại thông tin khách hàng / member
            if ($data['member']['id']) {
                $params['id'] = $data['member']['id'];
            }
            $MemberTb->saveData($params);

            $data['member'] = $MemberTb->getItem(array('email' => ($data['member']['email']) ? $data['member']['email'] : $params['post']['email']));
            if (!$params['post']['recipient_data']['fullname']) {
                $params['post']['recipient_data'] = array(
                    'fullname' => $data['member']['fullname'],
                    'phone' => $data['member']['phone'],
                    'address' => $data['member']['address']
                );
            }
            $params['post'] = array(
                'member_id' => $data['member']['id'],
                'discount_id' => $params['post']['discount_id'],
                'total_price' => $params['post']['total_price'],
                'comment' => $params['post']['comment'],
                'recipient_data' => $params['post']['recipient_data'],
                'multi_data' => $params['post']['multi_data']
            );
            $OrderTb = new OrderTb();
            $OrderTb->saveData($params);

            // ghi dữ liệu chi tiết đơn hàng
            $OrderDetailTb = new OrderDetailTb();
            $order = $OrderTb->listItem(array('columns' => array('id')));
            $params['post']['orders_id'] = $order[0]['id'];

            // vòng lặp để insert theo từng sp
            foreach ($data['cart'] as $value) {
                $params['post']['product_id'] = $value['id'];
                $params['post']['quantity'] = $value['quantity'];
                $params['post']['product_meta'] = json_encode($value);
                $OrderDetailTb->saveData($params);
            }
            // Gửi mail thông báo
            $InfoTb = new InfoTb();
            $data['info'] = $InfoTb->getItem();
            if ($data['info']['email']) {
                $EmailTemplateTb = new \Backend\Model\EmailTemplateTb();
                $template = $EmailTemplateTb->getItem(array('id' => 2, 'sendmail' => true));
                $template['value'] = array(DOMAIN,$params['post']['orders_id'],$data['member']['fullname'],$data['member']['phone'],$data['member']['address'],URL.'admin');
                $SendMail = new \Backend\View\Helper\Api\SendMail(array(
                    'emailTo' => $data['info']['email'],
                    'subject' => str_replace($template['key'], $template['value'], $template['subject']),
                    'body' => str_replace($template['key'], $template['value'], $template['body'])
                ));
            }

            // Xóa session và xuất thông báo
            if ($url == $translator->translate('dat-hang-62.html')) {
                $session->offsetSet('cart', '');
            }
            return $this->getResponse();
        }

        // SEO || SNIPPET
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = array(
            $MenuPublicTb->getItem(array('active' => 'home', 'columns' => array('title','link'))),
            array('title' => $translator->translate("Nhập thông tin đặt hàng"))
        );

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'title' => $translator->translate("Nhập thông tin đặt hàng"),
            'keyword' => $translator->translate("đặt hàng, mua hàng"),
            'description' => $translator->translate("Vui lòng nhập thông tin đặt mua hàng của bạn vào form đặt hàng của chúng tôi"),
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => $data['menu'],
            'noindex' => true
        ));

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = array('vi' => 'dat-hang', 'en' => 'en/purchase'); // Nếu có ngôn ngữ LANG

        return new ViewModel($data);
    }

    public function listAction() // 63.html
    {
        $translator = $this->getServiceLocator()->get('translator');
        $params = $this->params()->fromRoute();
        $data = array('action' => 'order-list');
        $session = new Container('frontend');
        if (!$session->logged) { return $this->redirect()->toUrl(URL_LANG); }

        $OrderTb = new OrderTb();
        $data['list'] = $OrderTb->listItem(array(
            'member_id' => $session->logged['id'],
            'orderby' => array('status ASC')
        ));

        // SEO || SNIPPET
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = array(
            $MenuPublicTb->getItem(array('active' => 'home', 'columns' => array('title','link'))),
            array('title' => $translator->translate("Danh sách đơn hàng"))
        );

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'title' => $translator->translate("Danh sách đơn hàng"),
            'keyword' => '',
            'description' => '',
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => $data['menu'],
            'noindex' => true
        ));

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = array('vi' => 'danh-sach-don-hang', 'en' => 'en/order-list'); // Nếu có ngôn ngữ LANG

        return new ViewModel($data);
    }

    public function detailAction() // 64.html
    {
        $session = new Container('frontend');
        if (!$session->logged) {
            return $this->redirect()->toUrl(URL_LANG);
        }
        $translator = $this->getServiceLocator()->get('translator');
        $params = $this->params()->fromRoute();
        $data = array();
        $data['action'] = 'order-detail';
        $OrderDetailTb = new OrderDetailTb();
        $data['detail'] = $OrderDetailTb->detailOrder(array('orders_id' => $params['slug']));
        $data['listProduct'] = $OrderDetailTb->listItem(array('orders_id' => $params['slug']));
        $data['config'] = $OrderDetailTb->config();
        $data['recipient'] = json_decode($data['detail']['recipient_data'], true);

        // SEO || SNIPPET
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = array(
            $MenuPublicTb->getItem(array('active' => 'home', 'columns' => array('title','link'))),
            array('title' => $translator->translate("Đơn hàng").' '.$params['id'])
        );

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'title' => $translator->translate("Đơn hàng").' '.$params['id'],
            'keyword' => '',
            'description' => '',
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => $data['menu'],
            'noindex' => true
        ));

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = array('vi' => 'chi-tiet-don-hang', 'en' => 'en/order-details'); // Nếu có ngôn ngữ LANG

        return new ViewModel($data);
    }

    public function discountAction() // 65.html
    {
        $session = new Container('frontend');
        $ProductTb = new ProductTb();
        $ProductDiscountTb = new ProductDiscountTb();
        $post = $this->getRequest()->getPost()->toArray();
        $data = array();
        $item = $ProductDiscountTb->getItem(array('sku' => $post['sku']));
        if (empty($item)) {
            $data['error'] = 'Mã giảm giá không tồn tại';
        } elseif (($item['expired_date'] && strtotime($item['expired_date']) < time()) || ($item['expired_number'] && ($item['expired_number'] <= $item['remain']))) {
            $data['error'] = 'Mã giảm giá đã hết hiệu lực';
        } elseif ($item['status'] == 2) {
            $data['error'] = 'Mã giảm giá đang tạm ngưng áp dụng';
        } else {
            $item['allowed_value'] = explode(',', str_replace(':','',$item['allowed_value']));
            $productAllowedIds = ($item['allowed_type'] == 1) ? $item['allowed_value'] : array();
            $allType = array(2 => 'root_id', 3 => 'brand_id', 4 => 'list_label_id');

            if ($item['allowed_type'] > 1) {
                foreach ($item['allowed_value'] as $id) {
                    $productAllowedIds = array_merge($productAllowedIds, array_column($ProductTb->getList(array($allType[$item['allowed_type']] => $id)), 'id'));
                }
            }

            $productCartIds = array_column($session->cart,'id');
            $productAllowedIds = array_intersect($productCartIds, $productAllowedIds);

            if (count($productAllowedIds) > 0 || $item['allowed_type'] == 0) {
                $data['discount_id'] = $item['id'];
                $data['reducedCash'] = 0;
                $total = 0;
                foreach ($session->cart as $product) {
                    $total = $total + ($product['price']*$product['quantity']);
                    if (array_search($product['id'], $productAllowedIds) !== false) {
                        $data['reducedCash'] = ($data['reducedCash'] + (($item['discount_type'] == 1) ? (($product['price']*$item['discount_value'])/100) : $item['discount_value'])) * $product['quantity'];
                        $data['list'][] = $product['name'];
                    }
                }

                if ($total < $item['order_value']) {
                    $data['error'] = 'Mã giảm giá không áp dụng cho đơn hàng nhỏ hơn '.number_format($item['order_value'],0,0,'.').'đ';
                } else {
                    $data['message'] = 'Mã '.$post['sku'].' được giảm '.(($item['discount_type'] == 1) ? $item['discount_value'].'%' : number_format($item['discount_value'],0,0,'.').'đ');
                    if ($item['allowed_type'] == 0) {
                        $data['reducedCash'] = (($item['discount_type'] == 1) ? (($total*$item['discount_value'])/100) : $item['discount_value']);
                        $data['message'] .= ' trên tổng đơn hàng.';
                    } else {
                        $data['message'] .= ' áp dụng cho sản phẩm:';
                    }
                }

            } else{
                $data['error'] = 'Mã giảm giá không áp dụng cho các sản phẩm trong đơn hàng này.';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);

        return $this->getResponse();
    }
}
?>