<?php

namespace Frontend\Controller;

use Frontend\Model\InfoTb;
use Frontend\Model\MenuPublicTb;
use Frontend\Model\NewsTb;
use Frontend\Model\ProductBrandTb;
use Frontend\Model\ProductCatTb;
use Frontend\Model\ProductLabelTb;
use Frontend\Model\ProductSelectTb;
use Frontend\Model\ProductTagTb;
use Frontend\Model\ProductTb;
use Frontend\Model\SectionTb;
use Zend\Mvc\Controller\AbstractActionController;
use Zend\View\Model\ViewModel;
use Zend\Session\Container;

class ProductController extends AbstractActionController
{
    public function list11Action()
    {
        if ($this->getResponse()->getContent()) {
            return new ViewModel($this->getResponse()->getContent());
        }

        $params = $this->params()->fromRoute();
        $data = $this->getDefault($params);

        //Begin code

        $array = array(
            'root_id' => $params['id'],
            'columns' => array('id','name','slug','thumbnail','price_market','price_discount','price_percent'),
            'limit' => 18,
            'page' => isset($params['page']) ? $params['page'] : '',
        );

        $list = $this->listPage($array);
        $data['list'] = $list['list'];
        $data['paginator'] = $list['paginator'];
        $data['params'] = array_merge($data['params'], $list['params']);

        //End code

        $this->getResponse()->setContent($data);
        return new ViewModel($data);
    }

    public function list12Action()
    {
        if ($this->getResponse()->getContent()) {
            return new ViewModel($this->getResponse()->getContent());
        }

        $params = $this->params ()->fromRoute();
        $data = $this->getDefault($params);

        //Begin code

        // Xóa dòng này và code ở đây

        //End code

        $this->getResponse()->setContent($data);
        return new ViewModel($data);
    }

    public function list13Action()
    {
        if ($this->getResponse()->getContent()) {
            return new ViewModel($this->getResponse()->getContent());
        }

        $params = $this->params ()->fromRoute ();
        $data = $this->getDefault($params);

        //Begin code

        // Xóa dòng này và code ở đây

        //End code

        $this->getResponse()->setContent($data);
        return new ViewModel($data);
    }

    public function list14Action()
    {
        if ($this->getResponse()->getContent()) {
            return new ViewModel($this->getResponse()->getContent());
        }

        $params = $this->params ()->fromRoute ();
        $data = $this->getDefault($params);

        //Begin code

        // Xóa dòng này và code ở đây

        //End code

        $this->getResponse()->setContent($data);
        return new ViewModel($data);
    }

    public function detail15Action()
    {
        $params = $this->params()->fromRoute();
        // $params['root'] = '11.html'; // n: action list number || Sử dụng khi menu có danh mục
        $params['root'] = array('<id>' => '<n>.html'); // id: root_id || Sử dụng khi menu không có danh mục
        $data = $this->getDefault($params);

        //Begin code

        array_unshift($data['detail']['multi_image']['anh-sp'], array('name' => $data['detail']['name'], 'thumbnail' => $data['detail']['thumbnail']));

        $data['p_other'] = $this->listItem(array(
            'root_id'    => $data['detail']['cat_id'],
            'columns' => array('id','name','slug','thumbnail','price_market','price_discount','price_percent'),
            'deny_id'   => array($data['detail']['id']),
            'limit'     => 4,
        ));

        //End code

        return new ViewModel($data);
    }

    public function detail16Action()
    {
        $params = $this->params()->fromRoute();
        // $params['root'] = '<n>.html'; // n: action list number || Sử dụng khi menu có danh mục
        $params['root'] = array('<id>' => '<n>.html'); // id: root_id || Sử dụng khi menu không có danh mục
        $data = $this->getDefault($params);

        // Begin code

        // Xóa dòng này và code ở đây

        // End code

        return new ViewModel($data);
    }

    public function detail17Action()
    {
        $params = $this->params()->fromRoute();
        // $params['root'] = '<n>.html'; // n: action list number || Sử dụng khi menu có danh mục
        $params['root'] = array('<id>' => '<n>.html'); // id: root_id || Sử dụng khi menu không có danh mục
        $data = $this->getDefault($params);

        // Begin code

        // Xóa dòng này và code ở đây

        // End code

        return new ViewModel($data);
    }

    public function detail18Action()
    {
        $params = $this->params()->fromRoute();
        // $params['root'] = '<n>.html'; // n: action list number || Sử dụng khi menu có danh mục
        $params['root'] = array('<id>' => '<n>.html'); // id: root_id || Sử dụng khi menu không có danh mục
        $data = $this->getDefault($params);

        // Begin code

        // Xóa dòng này và code ở đây

        // End code

        return new ViewModel($data);
    }

    public function detail19Action()
    {
        $params = $this->params()->fromRoute();
        // $params['root'] = '<n>.html'; // n: action list number || Sử dụng khi menu có danh mục
        $params['root'] = array('<id>' => '<n>.html'); // id: root_id || Sử dụng khi menu không có danh mục
        $data = $this->getDefault($params);

        // Begin code

        // Xóa dòng này và code ở đây

        // End code

        return new ViewModel($data);
    }

    // Lấy danh sách dữ liệu không phân trang
    public function listItem($params = null)
    {
        if (empty($params['columns'])) {
            $params['columns'] = array('id','name','slug','thumbnail','price_market','price_discount','price_percent');
        }
        $ProductTb = new ProductTb();
        return $ProductTb->getList($params);
    }

    // Lấy dang sách dữ liệu có phân trang
    public function listPage($params = null)
    {
        if (empty($params['limit'])) {
            $params['limit'] = 0;
        }
        if (empty($params['number_page'])) {
            $params['number_page'] = 5;
        }
        if ($params['page']) {
            $params['offset'] = ($params['page'] - 1) * $params['limit'];
        } else {
            $params['page'] = 1;
        }

        $paginator = new \Zend\Paginator\Paginator(new \Zend\Paginator\Adapter\ArrayAdapter($this->listItem(array_merge($params, array('limit' => 0)))));
        $paginator->setCurrentPageNumber($params['page']);
        $paginator->setItemCountPerPage($params['limit']);
        $paginator->setPageRange($params['number_page']);

        return array(
            'params' => $params,
            'paginator' => $paginator,
            'list' => $paginator->getCurrentItems()
        );
    }

    // Thiết lập giá trị mặc đinh
    private function getDefault($params = null)
    {
        $data = array('action' => 'product-'.$params['action']);
        $link = $params['id'].'-'.$params['format'];
        preg_match('/[a-z]*/', $params['action'], $action);
        if ($action[0] == 'detail') {
            $ProductTb = new ProductTb();
            $data['detail'] = $ProductTb->getItem(array('id' => $params['id']));
            $data['slug'] = $params['slug'].'-'.$params['id'].'-'.$params['format'];

            $ProductCatTb = new ProductCatTb();
            $rootItem = $ProductCatTb->getParent(array('parent' => 0, 'child_id' => $data['detail']['cat_id'], 'columns' => array('id', 'parent')));
            $link = $data['detail']['cat_id'].'-'.(is_array($params['root']) ? $params['root'][$rootItem['id']] : $params['root']);


        } elseif (isset($params['menu_id'])) { // list
            $link = $params['shortcut'].$params['menu_id'].'-'.($params['id'] ? $params['id'].'-' : '').$params['format'];
        }

        // SEO || SNIPPET
        $MenuPublicTb = new MenuPublicTb();
        $data['menu'] = array_merge(
            array($MenuPublicTb->getItem(array('active' => 'home', 'columns' => array('title','keyword','description','link','active')))),
            array($MenuPublicTb->getItem(array('link' => '-'.$link, 'columns' => array('id','parent','name','title','keyword','description','link','active','thumbnail','level','detail','desc_short')))) // link: -<id>-<action(number)>.html
        );

        if (isset($params['brand_id'])) {
            $ProductBrandTb = new ProductBrandTb();
            $data['menu'][1] = $ProductBrandTb->getItem(array('id' => $params['brand_id'], 'columns' => array('id','name','slug','title','keyword','description')));
            $data['menu'][1]['link'] = $data['menu'][1]['slug'].'-br'.$data['menu'][1]['id'].'-'.$params['id'].'-'.$params['format'];
        } elseif (isset($params['label_id'])) {
            $ProductLabelTb = new ProductLabelTb();
            $data['menu'][1] = $ProductLabelTb->getItem(array('id' => $params['label_id'], 'columns' => array('id','name','slug','title','keyword','description','detail')));
            $data['menu'][1]['link'] = $data['menu'][1]['slug'].'-lb'.$data['menu'][1]['id'].'-'.$params['id'].'-'.$params['format'];
            $temp = $MenuPublicTb->getItem(array('link' => '-'.$params['id'].'-'.$params['format'], 'columns' => array('id','parent','name','title','keyword','description','link','active','thumbnail','level')));
            $data['menu'][1]['id'] = $temp['id'];
            $data['menu'][1]['parent'] = $temp['parent'];
            $data['menu'][1]['parent'] = $temp['parent'];
            $data['menu'][1]['level'] = $temp['level'];
        } elseif (isset($params['tag_id'])) {
            $ProductTagTb = new ProductTagTb();
            $data['menu'][1] = $ProductTagTb->getItem(array('id' => $params['tag_id'], 'columns' => array('id','name','slug','title','keyword','description')));
            $data['menu'][1]['link'] = $data['menu'][1]['slug'].'-tg'.$data['menu'][1]['id'].'-'.$params['id'].'-'.$params['format'];
        } elseif ($data['menu'][1]['parent'] > 0) {
            $data['breadcrumb'] = $MenuPublicTb->getItem(array('id' => $data['menu'][1]['parent'], 'columns' => array('id','name','title','keyword','description','link','active')));
        }

        $data['active'] = $data['menu'][1]['active'];
        if (isset($data['detail'])) {
            $data['menu'][] = array('title' => $data['detail']['title']);
            $arrs = array(
                'name' => $data['detail']['name'],
                'title' => $data['detail']['title'],
                'keyword' => $data['detail']['keyword'],
                'description' => $data['detail']['description'],
                'image' => UPLOAD_IMAGES.date('Y/m',explode('-',$data['detail']['thumbnail'])[0]).'/'.$data['detail']['thumbnail']
            );
        } else {
            $arrs = array(
                'name' => ((!empty($params['page'])) ? 'Trang '.$params['page'].': ' : '').$data['menu'][1]['name'],
                'title' => ((!empty($params['page'])) ? 'Trang '.$params['page'].': ' : '').$data['menu'][1]['title'],
                'keyword' => ((!empty($params['page'])) ? 'Trang '.$params['page'].': ' : '').$data['menu'][1]['keyword'],
                'description' => ((!empty($params['page'])) ? 'Trang '.$params['page'].': ' : '').$data['menu'][1]['description'],
                'image' => UPLOAD_IMAGES.date('Y/m',explode('-',$data['menu'][1]['thumbnail'])[0]).'/'.$data['menu'][1]['thumbnail']
            );
        }

        if (isset($data['detail']) && empty($data['detail']['id']) || empty($data['menu'][1])) {
            $response = $this->getResponse();
            $response->setStatusCode(404);
            $response->sendHeaders();
        } else {
            if(!$params['label_id']) {
                $langCurrent = str_replace(PUBLIC_PATH, '', URL_LANG);
                $currentSlug = $langCurrent.$params['slug'];
                $actualSlug = $data['detail']['slug'] ?? str_replace('-'.$link, '', end($data['menu'])['link']);
                if ($actualSlug != $currentSlug) {
                    $response = $this->getResponse();
                    $response->getHeaders()->addHeaderLine('Location', URL.$actualSlug.'-'.$params['id'].'-'.$params['format']);
                    $response->setStatusCode(302);
                    $response->sendHeaders();
                }
            }
        }

        $InfoTb = new InfoTb();
        $data['info'] = $InfoTb->getItem();

        $this->getEvent()->getRouteMatch()->setParam('seo', array(
            'name' => $arrs['name'],
            'title' => $arrs['title'],
            'keyword' => $arrs['keyword'],
            'description' => $arrs['description'],
            'image' => $arrs['image'],
            'url' => PROTOCOL.DOMAIN.$_SERVER['REQUEST_URI'],
            'site_name' => $data['info']['name'],
            'snippet' => $data['menu']
        ));

        //Điều kiện active cho danh mục cấp 1
        $data['level'] = $data['menu'][1]['level'];
        $data['menu_id'] = $data['menu'][1]['level'] == 1 ? $data['menu'][1]['id'] : $data['menu'][1]['parent'];

        $data['params'] = $this->params()->fromRoute();
        // $data['params']['slugLang'] = isset($data['detail']) ? $data['detail']['slugLang'] : $data['menu'][1]['slugLang']; // Nếu có ngôn ngữ LANG

        return $data;
    }
}

?>