<?php

namespace Frontend\Model;

use Zend\Db\TableGateway\AbstractTableGateway;
use Zend\Db\TableGateway\Feature;
use Zend\Authentication\Adapter\DbTable as AuthAdapter;
use Zend\Authentication\AuthenticationService;
use Zend\Authentication\Result;
use Zend\Db\Sql\Select;
use Zend\Session\Container;

class ClassTb extends AbstractTableGateway
{
    protected $table = 'class_tb';

    public function __construct()
    {
        $this->featureSet = new Feature\FeatureSet();
        $this->featureSet->addFeature(new Feature\GlobalAdapterFeature());
        $this->initialize();
    }

    public function listItem($params = null)
    {
        $select = new Select();
        $select->from(array('class' => $this->table));

        if (isset($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['status']) && $params['status'] != 'all') {
            $select->where->equalTo('class.status', $params['status']);
        }
        if (isset($params['list_id'])){
           $select->where->In('class.id', $params['list_id']);
        }
        if (isset($params['teacher_id'])) {
            $select->where->equalTo('class.teacher_id', $params['teacher_id']);
        }
        if (isset($params['consultant_id'])) {
            $select->where->equalTo('class.consultant_id', $params['consultant_id']);
        }
        if (isset($params['deny_id'])) {
            $select->where->notIn('class.id', $params['deny_id']);
        }

        if (isset($params['keysearch'])) {
            $select->where->like('class.name', '%'.$params['keysearch'].'%');
        }

        $select->join(
            array('consultant' => 'member_tb'),
            'class.consultant_id = consultant.id',
            array('consultant_name' => 'fullname', 'consultant_email' => 'email')
        )->join(
            array('teacher' => 'member_tb'),
            'class.teacher_id = teacher.id',
            array('teacher_name' => 'fullname', 'teacher_email' => 'email')
        );

        $select->where->notIn('class.status', [3]);

        $select->order((isset($params['orderby']) ? $params['orderby'] : 'class.id DESC'));

        return $this->selectWith($select)->toArray();
    }

    public function getItem($params = null)
    {
        $select = new Select();
        // $select->from($this->table);
        $select->from(array('class' => $this->table));
        if (!empty($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['id'])) {
            $select->where->equalTo('class.id', $params['id']);
        }
        if (isset($params['teacher_id'])) {
            $select->where->equalTo('class.teacher_id', $params['teacher_id']);
        }
        if (isset($params['status'])) {
            $select->where->equalTo('class.status', $params['status']);
        }

        $select->where->notIn('class.status', [3]);

        $select->join(
            array('consultant' => 'member_tb'),
            'class.consultant_id = consultant.id',
            array('consultant_name' => 'fullname', 'consultant_email' => 'email')
        )->join(
            array('teacher' => 'member_tb'),
            'class.teacher_id = teacher.id',
            array('teacher_name' => 'fullname', 'teacher_email' => 'email')
        );

        $result = $this->selectWith($select)->toArray()[0];
        foreach (array('day_of_week','off_date') as $name) {
            if ($result[$name]) {
                $result[$name] = json_decode($result[$name], true);
            }
        }

        return $result;
    }

    public function saveData($params = null)
    {
        $data = array();
        if (isset($params['post']['name'])) {
            $data['name'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['name']);
        }
        if (isset($params['post']['type_class'])) {
            $data['type_class'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['type_class']);
        }
        if (isset($params['post']['session_salaries'])) {
            $data['session_salaries'] = \Frontend\View\Helper\Sqlinjection::string(str_replace('.','', $params['post']['session_salaries']));
        }
        if (isset($params['post']['day_of_week'])) {
            sort($params['post']['day_of_week']);
            $data['day_of_week'] = json_encode($params['post']['day_of_week'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
        }
        if (isset($params['post']['session_times'])) {
            $data['session_times'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['session_times']);
        }
        if (isset($params['post']['start_date'])) {
            $data['start_date'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['start_date']);
        }
        if (isset($params['post']['end_date'])) {
            $data['end_date'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['end_date']);
        }
        if (isset($params['post']['end_date_auto'])) {
            $data['end_date'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['end_date_auto']);
        }
        if (isset($params['post']['teacher_id'])) {
            $data['teacher_id'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['teacher_id']);
        }
        if (isset($params['post']['consultant_id'])) {
            $data['consultant_id'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['consultant_id']);
        }
        if (isset($params['post']['makeup_date'])) {
            $data['makeup_date'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['makeup_date']);
        }
        if (isset($params['post']['off_date'])) {
            $data['off_date'] = json_encode($params['post']['off_date'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
        }
        if (isset($params['post']['status'])) {
            $data['status'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['status']);
        }
        if (isset($params['post']['sendmail'])) {
            $data['sendmail'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['sendmail']);
        }

        $session = new Container('frontend');
        if (!empty($params['id'])) {
            $data['date_updated'] = date('Y-m-d H:i:s', time());
            $data['user_updated'] = $params['post']['system'] ? 'system' : $session->logged['email'];
            $this->update($data, 'id = ' . $params['id']);
            $increment = $params['id'];
        } else {
            $data['date_created'] = date('Y-m-d H:i:s', time());
            $data['user_created'] = $params['post']['system'] ? 'system' : $session->logged['email'];

            $this->insert($data);
            $increment = $this->getLastInsertValue();
        }

        return $increment;
    }
}