<?php

namespace Frontend\Model;

use Zend\Db\TableGateway\AbstractTableGateway;
use Zend\Db\TableGateway\Feature;
use Zend\Authentication\Adapter\DbTable as AuthAdapter;
use Zend\Authentication\AuthenticationService;
use Zend\Authentication\Result;
use Zend\Db\Sql\Select;

class ConfigTb extends AbstractTableGateway
{
    protected $table = 'config_tb';

    public function __construct()
    {
        $this->featureSet = new Feature\FeatureSet();
        $this->featureSet->addFeature(new Feature\GlobalAdapterFeature());
        $this->initialize();
    }

    public function getItem($params = null)
    {
        $select = new Select();
        $select->from($this->table);
        if (!empty($params['columns'])) {
            $select->columns($params['columns']);
        }

        if (isset($params['id'])) {
            $select->where->equalTo('id', $params['id']);
        }

        return $this->selectWith($select)->toArray()[0];
    }

    public function saveData($params = null)
    {
        $data = array();
        if (isset($params['post']['teacher_off'])) {
            $data['teacher_off'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['teacher_off']);
        }
        if (isset($params['post']['student_off'])) {
            $data['student_off'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['student_off']);
        }
        if (isset($params['post']['time_loop'])) {
            $data['time_loop'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['time_loop']);
        }
        if (isset($params['post']['tax'])) {
            $data['tax'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['tax']);
        }

        if (!empty($params['id'])) {
            $data['date_updated'] = date('Y-m-d', time());
            $this->update($data, 'id = ' . $params['id']);
            $increment = $params['id'];
        }
        return $increment;
    }
}