<?php

namespace Frontend\Model;

use Zend\Db\TableGateway\AbstractTableGateway;
use Zend\Db\TableGateway\Feature;
use Zend\Authentication\Adapter\DbTable as AuthAdapter;
use Zend\Authentication\AuthenticationService;
use Zend\Authentication\Result;
use Zend\Db\Sql\Select;

class MemberTb extends AbstractTableGateway
{
    protected $table = 'member_tb';

    public function __construct()
    {
        $this->featureSet = new Feature\FeatureSet();
        $this->featureSet->addFeature(new Feature\GlobalAdapterFeature());
        $this->initialize();
    }

    public function listItem($params = null)
    {
        $select = new Select();
        $select->from(array('member' => $this->table));

        if (isset($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['status']) && $params['status'] != 'all') {
            $select->where->equalTo('member.status', $params['status']);
        }
        if (isset($params['role'])) {
            if (is_array($params['role'])) {
                $select->where->In('member.role', $params['role']);
            } else {
                $select->where->equalTo('member.role', $params['role']);
            }
        }
        if (isset($params['deny_id'])) {
            $select->where->notIn('member.id', $params['deny_id']);
        }
        if (isset($params['deny_role'])) {
            $select->where->notIn('member.role', $params['deny_role']);
        }

        if (isset($params['keysearch'])) {
            $select->where->nest()
                            ->or->like('member.fullname', '%'.$params['keysearch'].'%')
                            ->or->like('member.email', '%'.$params['keysearch'].'%')
                        ->unnest;
        }

        $select->join(
            array('role' => 'role_tb'),
            'member.role = role.id',
            array('role_name' => 'name')
        );

        $select->where->notIn('member.status', [3]);

        $select->order('member.id DESC');

        return $this->selectWith($select)->toArray();
    }

    public function getItem($params = null)
    {
        $select = new Select();
        // $select->from($this->table);
        $select->from(array('member' => $this->table));
        if (!empty($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['id'])) {
            $select->where->equalTo('member.id', $params['id']);
        }
        if (isset($params['email'])) {
            if ($params['orphone']) {
                $select->where
                        ->nest()
                            ->equalTo('member.email', $params['email'])
                            ->or
                            ->equalTo('member.phone', $params['orphone'])
                        ->unnest;
            } else {
                $select->where->equalTo('member.email', $params['email']);
            }
        }

        if (isset($params['phone'])) {
            $select->where->equalTo('member.phone', $params['phone']);
        }
        if (isset($params['status'])) {
            $select->where->equalTo('member.status', $params['status']);
        }

        $select->where->notIn('member.status', [3]);

        $select->join(
            array('role' => 'role_tb'),
            'member.role = role.id',
            array('role_name' => 'name')
        );

        $result = $this->selectWith($select)->toArray()[0];

        return $result;
    }

    public function saveData($params = null)
    {
        $data = array();
        if (isset($params['post']['email'])) {
            $data['email'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['email']);
        }
        if (isset($params['post']['password'])) {
            $data['password'] =  \Backend\View\Helper\Crypt::encodePassword($params['post']['password']);
        }
        if (isset($params['post']['fullname'])) {
            $data['fullname'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['fullname']);
        }
        if (isset($params['post']['phone'])) {
            $data['phone'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['phone']);
        }
        if (isset($params['post']['address'])) {
            $data['address'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['address']);
        }
        if (isset($params['post']['birthday'])) {
            $data['birthday'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['birthday']);
        }
        if (isset($params['post']['sex'])) {
            $data['sex'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['sex']);
        }
        if (isset($params['post']['role'])) {
            $data['role'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['role']);
        }
        if (isset($params['post']['bank_number'])) {
            $data['bank_number'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['bank_number']);
        }
        if (isset($params['post']['bank_name'])) {
            $data['bank_name'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['bank_name']);
        }
        if (isset($params['post']['bank_owner'])) {
            $data['bank_owner'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['bank_owner']);
        }
        if (isset($params['post']['thumbnail'])) {
            $data['thumbnail'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['thumbnail']);
        }
        if (isset($params['post']['time_work'])) {
            $data['time_work'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['time_work']);
        }
        if (isset($params['post']['status'])) {
            $data['status'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['status']);
        }
        if (isset($params['post']['note'])) {
            $data['note'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['note']);
        }
        if (!empty($params['id'])) {
            $data['date_updated'] = date('Y-m-d', time());
            $this->update($data, 'id = ' . $params['id']);
            $increment = $params['id'];
        } else {
            $data['date_created'] = date('Y-m-d', time());
            $this->insert($data);
            $increment = $this->getLastInsertValue();
        }

        return $increment;
    }

    public function login($params = null)
    {
        $authAdapter = new AuthAdapter(\Zend\Db\TableGateway\Feature\GlobalAdapterFeature::getStaticAdapter(), $this->table, 'email', 'password');
        $authAdapter->setIdentity($params['post']['email'])
                    ->setCredential(\Backend\View\Helper\Crypt::encodePassword($params['post']['password']));
        $select = $authAdapter->getDbSelect();
        $select->where->equalTo('status', 1);
        $result = $authAdapter->authenticate();
        if ($result->isValid()) {
            $member = $this->getItem(array(
                'email' => $params['post']['email'],
                'status' => 1
            ));

            if($member['id']) {
                $data['date_login'] = date('Y-m-d H:i:s', time());
                $this->update($data, 'id = "' . $member['id'] . '"');
            }

            return $member;
        }
        return false;
    }

    public function changePassword($params = null)
    {
        $data['password'] =  \Backend\View\Helper\Crypt::encodePassword(\Frontend\View\Helper\Sqlinjection::string($params['post']['password']));
        $this->update($data, 'email = "' . \Frontend\View\Helper\Sqlinjection::string($params['post']['email']) . '"');
   }
}