<?php

namespace Frontend\Model;

use Zend\Db\TableGateway\AbstractTableGateway;
use Zend\Db\TableGateway\Feature;
use Zend\Authentication\Adapter\DbTable as AuthAdapter;
use Zend\Authentication\AuthenticationService;
use Zend\Authentication\Result;
use Zend\Db\Sql\Select;
use Zend\Session\Container;
use Frontend\Model\MemberTb;
use Frontend\Model\ClassTb;

class NotificationTb extends AbstractTableGateway
{
    protected $table = 'notification_tb';

    public function __construct()
    {
        $this->featureSet = new Feature\FeatureSet();
        $this->featureSet->addFeature(new Feature\GlobalAdapterFeature());
        $this->initialize();
    }

    public function listItem($params = null)
    {
        $select = new Select();
        $select->from(array('notify' => $this->table));

        if (isset($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['status']) && $params['status'] != 'all') {
            $select->where->equalTo('notify.status', $params['status']);
        }
        if (isset($params['list_id'])){
           $select->where->In('notify.id', $params['list_id']);
        }
        if (isset($params['class_id'])) {
            if (is_array($params['class_id'])) {
                $select->where->In('notify.class_id', $params['class_id']);
            } else {
                $select->where->equalTo('notify.class_id', $params['class_id']);
            }
        }
        if (isset($params['user_open'])) {
            $select->where->equalTo('notify.user_open', $params['user_open']);
        }
        if (isset($params['user_reply'])) {
            $select->where->equalTo('notify.user_reply', $params['user_reply']);
        }
        if (isset($params['parent'])) {
            $select->where->equalTo('notify.parent', $params['parent']);
        }
        if (isset($params['deny_id'])) {
            $select->where->notIn('notify.id', $params['deny_id']);
        }

        $select->join(
            array('class' => 'class_tb'),
            'notify.class_id = class.id',
            array('class_name' => 'name')
        );

        $select->where->notIn('notify.status', [3]);
        $select->order((isset($params['orderby']) ? $params['orderby'] : 'notify.id DESC'));

        $result = $this->selectWith($select)->toArray();

        $MemberTb = new MemberTb();
        $ClassTb = new ClassTb();
        foreach ($result as $i => $value) {
            if($value['user_open']) {
                $open = $MemberTb->getItem(array('id' => $value['user_open']));
                $result[$i]['user_open_name'] = $open['fullname'];
                $result[$i]['user_open_email'] = $open['email'];
                $result[$i]['user_open_thumbnail'] = $open['thumbnail'];
            }

            if($value['user_reply']) {
                $reply = $MemberTb->getItem(array('id' => $value['user_reply']));
                $result[$i]['user_reply_name'] = $reply['fullname'];
                $result[$i]['user_reply_email'] = $reply['email'];
                $result[$i]['user_reply_thumbnail'] = $reply['thumbnail'];
                $result[$i]['user_reply_role'] = $reply['role'];
            }
        }

        return $result;
    }

    public function getItem($params = null)
    {
        $select = new Select();
        // $select->from($this->table);
        $select->from(array('notify' => $this->table));
        if (!empty($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['id'])) {
            $select->where->equalTo('notify.id', $params['id']);
        }
        if (isset($params['teacher_id'])) {
            $select->where->equalTo('notify.teacher_id', $params['teacher_id']);
        }
        if (isset($params['status'])) {
            $select->where->equalTo('notify.status', $params['status']);
        }

        $select->where->notIn('notify.status', [3]);

        $select->join(
            array('consultant' => 'member_tb'),
            'notify.consultant_id = consultant.id',
            array('consultant_name' => 'fullname', 'consultant_email' => 'email')
        )->join(
            array('teacher' => 'member_tb'),
            'notify.teacher_id = teacher.id',
            array('teacher_name' => 'fullname', 'teacher_email' => 'email')
        );

        $result = $this->selectWith($select)->toArray()[0];
        foreach (array('day_of_week','off_date') as $name) {
            if ($result[$name]) {
                $result[$name] = json_decode($result[$name], true);
            }
        }

        return $result;
    }

    public function saveData($params = null)
    {
        $data = array();
        if (isset($params['post']['name'])) {
            $data['name'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['name']);
        }
        if (isset($params['post']['user_open'])) {
            $data['user_open'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['user_open']);
        }
        if (isset($params['post']['user_reply'])) {
            $data['user_reply'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['user_reply']);
        }
        if (isset($params['post']['parent'])) {
            $data['parent'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['parent']);
        }
        if (isset($params['post']['class_id'])) {
            $data['class_id'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['class_id']);
        }
        if (isset($params['post']['content'])) {
            $data['content'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['content']);
        }
        if (isset($params['post']['status'])) {
            $data['status'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['status']);
        }

        $session = new Container('frontend');
        if (!empty($params['id'])) {
            $data['date_updated'] = date('Y-m-d H:i:s', time());
            $data['user_updated'] = $session->logged['email'];
            $this->update($data, 'id = ' . $params['id']);
            $increment = $params['id'];
        } else {
            $data['date_created'] = date('Y-m-d H:i:s', time());
            $data['user_created'] = $session->logged['email'];

            $this->insert($data);
            $increment = $this->getLastInsertValue();
        }

        return $increment;
    }
}