<?php

namespace Frontend\Model;

use Zend\Db\TableGateway\AbstractTableGateway;
use Zend\Db\TableGateway\Feature;
use Zend\Db\Sql\Select;

class OrderTb extends AbstractTableGateway
{
    protected $table = 'orders_tb';

    public function __construct()
    {
        $this->featureSet = new Feature\FeatureSet();
        $this->featureSet->addFeature(new Feature\GlobalAdapterFeature());
        $this->initialize();
    }

    public function saveData($params = null)
    {
        $data = array();
        if (isset($params['post']['member_id'])) {
            $data['member_id'] = $params['post']['member_id'];
        }
        if (isset($params['post']['discount_id'])) {
            $data['discount_id'] = $params['post']['discount_id'];
        }
        if (isset($params['post']['total_price'])) {
            $data['total_price'] = $params['post']['total_price'];
        }
        if (isset($params['post']['comment'])) {
            $data['comment'] = $params['post']['comment'];
        }
        if (isset($params['post']['recipient_data'])) {
            $data['recipient_data'] = json_encode($params['post']['recipient_data'], JSON_UNESCAPED_UNICODE);
        }
        if (isset($params['post']['multi_data'])) {
            $data['multi_data'] = json_encode($params['post']['multi_data'], JSON_UNESCAPED_UNICODE);
        }
        $data['date_created'] = date('Y-m-d H:i:s',time());
        $this->insert($data);
    }

    public function listItem($params = null)
    {
        $select = new Select();
        $select->from($this->table);

        if (!empty($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['limit'])) {
            $select->limit($params['limit'])->offset(isset($params['offset']) ? $params['offset'] : 0);
        }
        if (isset($params['member_id'])) {
            $select->where->equalTo('member_id', $params['member_id']);
        }

        $select->order((($params['orderby']) ? implode(', ', $params['orderby']).', ' : '').'id DESC');

        return $this->selectWith($select)->toArray();
    }

    public function countItem($params = null)
    {
        unset($params['limit']);
        return count($this->listItem($params));
    }
}