<?php

namespace Frontend\Model;

use Zend\Db\TableGateway\AbstractTableGateway;
use Zend\Db\TableGateway\Feature;
use Zend\Authentication\Adapter\DbTable as AuthAdapter;
use Zend\Authentication\AuthenticationService;
use Zend\Authentication\Result;
use Zend\Db\Sql\Select;

class RoleTb extends AbstractTableGateway
{
    protected $table = 'role_tb';

    public function __construct()
    {
        $this->featureSet = new Feature\FeatureSet();
        $this->featureSet->addFeature(new Feature\GlobalAdapterFeature());
        $this->initialize();
    }

    public function listItem($params = null)
    {
        $select = new Select();
        $select->from(array('role' => $this->table));

        if (isset($params['deny_id'])) {
            $select->where->notIn('role.id', $params['deny_id']);
        }

        $select->order('role.id ASC');

        return $this->selectWith($select)->toArray();
    }

    public function getItem($params = null)
    {
        $select = new Select();
        $select->from($this->table);
        if (!empty($params['columns'])) {
            $select->columns($params['columns']);
        }

        if (isset($params['id'])) {
            $select->where->equalTo('id', $params['id']);
        }

        return $this->selectWith($select)->toArray()[0];
    }
}