<?php

namespace Frontend\Model;

use Zend\Db\TableGateway\AbstractTableGateway;
use Zend\Db\TableGateway\Feature;
use Zend\Authentication\Adapter\DbTable as AuthAdapter;
use Zend\Authentication\AuthenticationService;
use Zend\Authentication\Result;
use Zend\Db\Sql\Select;
use Zend\Session\Container;

class SalariesTb extends AbstractTableGateway
{
    protected $table = 'salaries_tb';

    public function __construct()
    {
        $this->featureSet = new Feature\FeatureSet();
        $this->featureSet->addFeature(new Feature\GlobalAdapterFeature());
        $this->initialize();
    }

    public function listItem($params = null)
    {
        $select = new Select();
        $select->from(array('salaries' => $this->table));

        if (isset($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['status']) && $params['status'] != 'all') {
            $select->where->equalTo('salaries.status', $params['status']);
        }
        if (isset($params['role'])) {
            $select->where->equalTo('salaries.role', $params['role']);
        }
        if (isset($params['deny_id'])) {
            $select->where->notIn('salaries.role', $params['deny_id']);
        }
        if (isset($params['deny_role'])) {
            $select->where->notIn('salaries.role', $params['deny_role']);
        }

        if (isset($params['keysearch'])) {
            $select->where->nest()
                            ->or->like('salaries.fullname', '%'.$params['keysearch'].'%')
                            ->or->like('salaries.email', '%'.$params['keysearch'].'%')
                        ->unnest;
        }

        // $select->join(
        //     array('role' => 'role_tb'),
        //     'salaries.role = role.id',
        //     array('role_name' => 'name')
        // );

        // $select->where->notIn('salaries.status', [3]);

        $select->order('salaries.id DESC');

        return $this->selectWith($select)->toArray();
    }

    public function getItem($params = null)
    {
        $select = new Select();
        // $select->from($this->table);
        $select->from(array('salaries' => $this->table));
        if (!empty($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['id'])) {
            $select->where->equalTo('salaries.id', $params['id']);
        }
        if (isset($params['teacher_id'])) {
            $select->where->equalTo('salaries.teacher_id', $params['teacher_id']);
        }
        if (isset($params['month'])) {
            $select->where->equalTo('salaries.month', $params['month']);
        }

        $result = $this->selectWith($select)->toArray()[0];
        foreach (array('upsell') as $name) {
            if ($result[$name]) {
                $result[$name] = json_decode($result[$name], true);
            }
        }

        return $result;
    }

    public function saveData($params = null)
    {
        $data = array();
        if (isset($params['post']['name'])) {
            $data['name'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['name']);
        }
        if (isset($params['post']['teacher_id'])) {
            $data['teacher_id'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['teacher_id']);
        }
        if (isset($params['post']['month'])) {
            $data['month'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['month']);
        }
        if (isset($params['post']['upsell'])) {
            $data['upsell'] = json_encode($params['post']['upsell'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
        }
        if (isset($params['post']['print'])) {
            $data['print'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['print']);
        }
        if (isset($params['post']['zoom'])) {
            $data['zoom'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['zoom']);
        }
        if (isset($params['post']['other'])) {
            $data['other'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['other']);
        }
        if (isset($params['post']['note'])) {
            $data['note'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['note']);
        }

        $session = new Container('frontend');
        if (!empty($params['id'])) {
            $data['date_updated'] = date('Y-m-d H:i:s', time());
            $data['user_updated'] = $session->logged['email'];
            $this->update($data, 'id = ' . $params['id']);
            $increment = $params['id'];
        } else {
            $data['date_created'] = date('Y-m-d H:i:s', time());
            $data['user_created'] = $session->logged['email'];
            $this->insert($data);
            $increment = $this->getLastInsertValue();
        }

        return $increment;
    }
}