<?php

namespace Frontend\Model;

use Zend\Db\TableGateway\AbstractTableGateway;
use Zend\Db\TableGateway\Feature;
use Zend\Authentication\Adapter\DbTable as AuthAdapter;
use Zend\Authentication\AuthenticationService;
use Zend\Authentication\Result;
use Zend\Db\Sql\Select;
use Zend\Session\Container;

class StudentAttendancesTb extends AbstractTableGateway
{
    protected $table = 'student_attendances_tb';

    public function __construct()
    {
        $this->featureSet = new Feature\FeatureSet();
        $this->featureSet->addFeature(new Feature\GlobalAdapterFeature());
        $this->initialize();
    }

    public function listItem($params = null)
    {
        $select = new Select();
        $select->from(array('attendances' => $this->table));

        if (isset($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['class_id'])) {
            $select->where->equalTo('attendances.class_id', $params['class_id']);
        }
        if (isset($params['student_id'])) {
            $select->where->equalTo('attendances.student_id', $params['student_id']);
        }
        if (isset($params['status'])) {
            $select->where->equalTo('attendances.status', $params['status']);
        } else {
            $select->where->equalTo('attendances.status', 1);
        }

        if (isset($params['deny_id'])) {
            $select->where->notIn('attendances.role', $params['deny_id']);
        }

        if (isset($params['keysearch'])) {
            $select->where->nest()
                            ->or->like('attendances.fullname', '%'.$params['keysearch'].'%')
                            ->or->like('attendances.email', '%'.$params['keysearch'].'%')
                        ->unnest;
        }

        // $select->join(
        //     array('role' => 'role_tb'),
        //     'attendances.role = role.id',
        //     array('role_name' => 'name')
        // );

        $select->where->notIn('attendances.status', [3]);

        $select->order('attendances.id DESC');

        return $this->selectWith($select)->toArray();
    }

    public function getItem($params = null)
    {
        $select = new Select();
        // $select->from($this->table);
        $select->from(array('attendances' => $this->table));
        if (!empty($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['id'])) {
            $select->where->equalTo('attendances.id', $params['id']);
        }
        if (isset($params['class_id'])) {
            $select->where->equalTo('attendances.class_id', $params['class_id']);
        }
        if (isset($params['student_id'])) {
            $select->where->equalTo('attendances.student_id', $params['student_id']);
        }
        if (isset($params['session_date'])) {
            $select->where->equalTo('attendances.session_date', $params['session_date']);
        }
        if (isset($params['status'])) {
            $select->where->equalTo('attendances.status', $params['status']);
        } else {
            $select->where->equalTo('attendances.status', 1);
        }

        $select->where->notIn('attendances.status', [3]);

        $result = $this->selectWith($select)->toArray()[0];

        return $result;
    }

    public function saveData($params = null)
    {
        $data = array();
        if (isset($params['post']['student_id'])) {
            $data['student_id'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['student_id']);
        }
        if (isset($params['post']['class_id'])) {
            $data['class_id'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['class_id']);
        }
        if (isset($params['post']['session_date'])) {
            $data['session_date'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['session_date']);
        }
        if (isset($params['post']['checkin'])) {
            $data['checkin'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['checkin']);
        }
        if (isset($params['post']['status'])) {
            $data['status'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['status']);
        }

        $session = new Container('frontend');
        if (!empty($params['id'])) {
            $data['date_updated'] = date('Y-m-d H:i:s', time());
            $data['user_updated'] = $session->logged['email'];
            $this->update($data, 'id = ' . $params['id']);
            $increment = $params['id'];
        } else if (!empty($params['student_id'])) {
            $data['date_updated'] = date('Y-m-d H:i:s', time());
            $data['user_updated'] = $session->logged['email'];
            $this->update($data, 'student_id = ' . $params['student_id']);
            $increment = $params['student_id'];
        } else {
            $data['date_created'] = date('Y-m-d H:i:s', time());
            $data['user_created'] = $session->logged['email'];
            $this->insert($data);
            $increment = $this->getLastInsertValue();
        }

        return $increment;
    }
}