<?php

namespace Frontend\Model;

use Zend\Db\TableGateway\AbstractTableGateway;
use Zend\Db\TableGateway\Feature;
use Zend\Authentication\Adapter\DbTable as AuthAdapter;
use Zend\Authentication\AuthenticationService;
use Zend\Authentication\Result;
use Zend\Db\Sql\Select;
use Zend\Session\Container;
use Frontend\Model\ClassTb;

class StudentTb extends AbstractTableGateway
{
    protected $table = 'student_tb';

    public function __construct()
    {
        $this->featureSet = new Feature\FeatureSet();
        $this->featureSet->addFeature(new Feature\GlobalAdapterFeature());
        $this->initialize();
    }

    public function listItem($params = null)
    {
        $select = new Select();
        $select->from(array('student' => $this->table));

        if (isset($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['status']) && $params['status'] != 'all') {
            $select->where->equalTo('student.status', $params['status']);
        }
        if (isset($params['class_id'])) {
            if (is_array($params['class_id'])) {
                $select->where->In('student.class_id', $params['class_id']);
            } else {
                $select->where->equalTo('student.class_id', $params['class_id']);
            }
        }
        if (isset($params['deny_id'])) {
            $select->where->notIn('student.id', $params['deny_id']);
        }
        if (isset($params['deny_class'])) {
            $select->where->notIn('student.class_id', $params['deny_class']);
        }

        if (isset($params['keysearch'])) {
            $select->where->nest()
                            ->or->like('student.fullname', '%'.$params['keysearch'].'%')
                            ->or->like('student.phone', '%'.$params['keysearch'].'%')
                        ->unnest;
        }

        // $select->join(
        //     array('class' => 'class_tb'),
        //     'student.class_id = class.id',
        //     array('class_name' => 'name')
        // );

        $select->where->notIn('student.status', [3]);
        $select->order('student.id DESC');

        $result = $this->selectWith($select)->toArray();

        $ClassTb = new ClassTb();
        foreach ($result as $i => $value) {
            $className = $ClassTb->getItem(array('id' => $value['class_id']))['name'];
            $result[$i]['class_name'] = $value['status'] == 2 || !$className ? 'Tạm nghỉ' : $className;
        }

        return $result;
    }

    public function getItem($params = null)
    {
        $select = new Select();
        // $select->from($this->table);
        $select->from(array('student' => $this->table));
        if (!empty($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['id'])) {
            $select->where->equalTo('student.id', $params['id']);
        }
        if (isset($params['email'])) {
            if ($params['orphone']) {
                $select->where
                        ->nest()
                            ->equalTo('student.email', $params['email'])
                            ->or
                            ->equalTo('student.phone', $params['orphone'])
                        ->unnest;
            } else {
                $select->where->equalTo('student.email', $params['email']);
            }
        }

        if (isset($params['phone'])) {
            $select->where->equalTo('student.phone', $params['phone']);
        }
        if (isset($params['status'])) {
            $select->where->equalTo('student.status', $params['status']);
        }

        $select->where->notIn('student.status', [3]);

        // $select->join(
        //     array('class' => 'class_tb'),
        //     'student.class_id = class.id',
        //     array('class_name' => 'name')
        // );

        $result = $this->selectWith($select)->toArray()[0];

        return $result;
    }

    public function saveData($params = null)
    {
        $data = array();
        if (isset($params['post']['name'])) {
            $data['name'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['name']);
        }
        if (isset($params['post']['class_id'])) {
            if($params['post']['class_id'] == '-1') {
                $data['status'] = 2;
            } else {
                $data['class_id'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['class_id']);
                $data['status'] = 1;
            }
        }
        if (isset($params['post']['fullname'])) {
            $data['fullname'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['fullname']);
        }
        if (isset($params['post']['email'])) {
            $data['email'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['email']);
        }
        if (isset($params['post']['phone'])) {
            $data['phone'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['phone']);
        }
        if (isset($params['post']['birthday'])) {
            $data['birthday'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['birthday']);
        }
        if (isset($params['post']['check_in'])) {
            $data['check_in'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['check_in']);
        }
        if (isset($params['post']['note'])) {
            $data['note'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['note']);
        }
        if (isset($params['post']['status'])) {
            $data['status'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['status']);
        }
        if (isset($params['post']['sendmail'])) {
            $data['sendmail'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['sendmail']);
        }
        if (isset($params['post']['complete_course'])) {
            $data['complete_course'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['complete_course']);
        }

        $session = new Container('frontend');
        if (!empty($params['id'])) {
            $data['date_updated'] = date('Y-m-d H:i:s', time());
            $data['user_updated'] = $session->logged['email'];
            $this->update($data, 'id = ' . $params['id']);
            $increment = $params['id'];
        } else {
            $data['date_created'] = date('Y-m-d H:i:s', time());
            $data['user_created'] = $session->logged['email'];
            $this->insert($data);
            $increment = $this->getLastInsertValue();
        }

        return $increment;
    }
}