<?php

namespace Frontend\Model;

use Zend\Db\TableGateway\AbstractTableGateway;
use Zend\Db\TableGateway\Feature;
use Zend\Authentication\Adapter\DbTable as AuthAdapter;
use Zend\Authentication\AuthenticationService;
use Zend\Authentication\Result;
use Zend\Db\Sql\Select;
use Zend\Session\Container;

class TimekeepingTb extends AbstractTableGateway
{
    protected $table = 'timekeeping_tb';

    public function __construct()
    {
        $this->featureSet = new Feature\FeatureSet();
        $this->featureSet->addFeature(new Feature\GlobalAdapterFeature());
        $this->initialize();
    }

    public function listItem($params = null)
    {
        $select = new Select();
        $select->from(array('timekeeping' => $this->table));

        if (isset($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['deny_id'])) {
            $select->where->notIn('timekeeping.role', $params['deny_id']);
        }
        if (isset($params['class_id'])) {
            $select->where->equalTo('timekeeping.class_id', $params['class_id']);
        }
        if (isset($params['teacher_id'])) {
            $select->where->equalTo('timekeeping.teacher_id', $params['teacher_id']);
        }
        if (isset($params['date_checkin'])) {
            $select->where->equalTo('timekeeping.date_checkin', $params['date_checkin']);
        }

        $select->order('timekeeping.id ASC');

        return $this->selectWith($select)->toArray();
    }

    public function getItem($params = null)
    {
        $select = new Select();
        // $select->from($this->table);
        $select->from(array('timekeeping' => $this->table));
        if (!empty($params['columns'])) {
            $select->columns($params['columns']);
        }
        if (isset($params['id'])) {
            $select->where->equalTo('timekeeping.id', $params['id']);
        }
        if (isset($params['class_id'])) {
            $select->where->equalTo('timekeeping.class_id', $params['class_id']);
        }
        if (isset($params['teacher_id'])) {
            $select->where->equalTo('timekeeping.teacher_id', $params['teacher_id']);
        }
        if (isset($params['date_checkin'])) {
            $select->where->equalTo('timekeeping.date_checkin', $params['date_checkin']);
        }

        $result = $this->selectWith($select)->toArray()[0];

        return $result;
    }

    public function saveData($params = null)
    {
        $data = array();
        if (isset($params['post']['name'])) {
            $data['name'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['name']);
        }
        if (isset($params['post']['class_id'])) {
            $data['class_id'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['class_id']);
        }
        if (isset($params['post']['teacher_id'])) {
            $data['teacher_id'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['teacher_id']);
        }
        if (isset($params['post']['date_checkin'])) {
            $data['date_checkin'] = \Frontend\View\Helper\Sqlinjection::string($params['post']['date_checkin']);
        }

        $session = new Container('frontend');
        if (!empty($params['id'])) {
            $data['date_updated'] = date('Y-m-d H:i:s', time());
            $data['user_updated'] = $session->logged['email'];
            $this->update($data, 'id = ' . $params['id']);
            $increment = $params['id'];
        } else {
            $data['date_created'] = date('Y-m-d H:i:s', time());
            $data['user_created'] = $session->logged['email'];
            $this->insert($data);
            $increment = $this->getLastInsertValue();
        }

        return $increment;
    }
}