<?php

namespace Frontend\View\Helper;
use Zend\View\Helper\AbstractHelper;

class CleanLink extends AbstractHelper
{
	public function __invoke($url, $extraParams = [])
	{
	    // Phân tích URL
	    $parsed_url = parse_url($url);

	    // Chuyển query string thành mảng
	    $query_params = [];
	    if (isset($parsed_url['query'])) {
	        parse_str($parsed_url['query'], $query_params);
	    }

	    // Luôn giữ `action`, cộng thêm các tham số khác từ `$extraParams`
	    $keepParams = array_merge(['action'], $extraParams);
	    $filtered_query = array_intersect_key($query_params, array_flip($keepParams));

	    // Xây dựng lại URL
	    $cleanLink = $parsed_url['scheme'] . "://" . $parsed_url['host'] . $parsed_url['path'];
	    if (!empty($filtered_query)) {
	        $cleanLink .= "?" . http_build_query($filtered_query);
	    }

	    return $cleanLink;
	}
}