<?php

namespace Frontend\View\Helper;
use Zend\View\Helper\AbstractHelper;

class generateSchedule extends AbstractHelper
{
	public function __invoke($startDate, $endDate, $weekdays, $makeupDays = [])
    {
    	// Lấy ngày hiện tại theo định dạng d/m
	    $today = date('d/m');
	    $activeNext = null; // Biến để lưu ngày học tiếp theo

	    // Chuyển đổi ngày bắt đầu & kết thúc thành DateTime
	    $start = \DateTime::createFromFormat('d/m/Y', $startDate);
	    $end = \DateTime::createFromFormat('d/m/Y', $endDate);

	    // Chuyển đổi danh sách thứ từ chuỗi sang số nguyên và sắp xếp
	    $validDays = array_map('intval', $weekdays);
	    sort($validDays);

	    // Chuyển đổi danh sách ngày học bù thành định dạng d/m
	    $makeupDays = array_map(function ($date) {
	        return \DateTime::createFromFormat('d/m/Y', $date)->format('d/m');
	    }, $makeupDays);

	    $schedule = [];
	    $sessionCount = 1;
	    $foundActive = false; // Biến kiểm tra xem có ngày học nào trùng hôm nay không

	    // Tìm ngày hợp lệ đầu tiên
	    while ($start <= $end && !in_array($start->format('N') + 1, $validDays)) {
	        $start->modify('+1 day');
	    }

	    // Lặp từ ngày hợp lệ đầu tiên đến ngày kết thúc
	    while ($start <= $end) {
	        $currentDate = $start->format('d/m'); // Lấy ngày tháng hiện tại
	        $dayOfWeek = (int) $start->format('N') + 1; // Chuyển đổi thứ

	        // Xác định loại buổi học
	        if (in_array($currentDate, $makeupDays)) {
	            $schedule[] = [
	                'label' => "Học bù",
	                'date' => $currentDate,
	                'active' => ($currentDate === $today),
	                'active_next' => false
	            ];
	            if ($currentDate === $today) $foundActive = true;
	        } elseif (in_array($dayOfWeek, $validDays)) {
	            $schedule[] = [
	                'label' => "Buổi " . $sessionCount,
	                'date' => $currentDate,
	                'active' => ($currentDate === $today),
	                'active_next' => false
	            ];
	            if ($currentDate === $today) $foundActive = true;
	            $sessionCount++;
	        }

	        // Tìm ngày hợp lệ tiếp theo
	        do {
	            $start->modify('+1 day');
	            $nextDay = (int) $start->format('N') + 1;
	            $nextDate = $start->format('d/m');
	        } while (!in_array($nextDay, $validDays) && !in_array($nextDate, $makeupDays) && $start <= $end);
	    }

	    // Nếu hôm nay không có trong danh sách, tìm ngày học tiếp theo để set active_next
	    if (!$foundActive) {
	        foreach ($schedule as $index => $session) {
	            if ($session['date'] > $today) {
	                $schedule[$index]['active_next'] = true;
	                break;
	            }
	        }
	    }

	    return $schedule;
	}
}