<?php

namespace Frontend\View\Helper;
use Zend\View\Helper\AbstractHelper;

class getDayOfWeek extends AbstractHelper
{
	public function __invoke($days)
    {
		$weekdayMap = [
	        2 => 'Thứ 2',
	        3 => 'Thứ 3',
	        4 => 'Thứ 4',
	        5 => 'Thứ 5',
	        6 => 'Thứ 6',
	        7 => 'Thứ 7',
	        8 => 'Chủ nhật'
	    ];

	    sort($days);
	    $result = [];
	    foreach ($days as $day) {
	        if (isset($weekdayMap[$day])) {
	            $result[] = $weekdayMap[$day];
	        }
	    }

	    return implode(' - ', $result);
	}
}