<?php

namespace Frontend\View\Helper;
use Zend\View\Helper\AbstractHelper;

class paginationMonth extends AbstractHelper
{
	public function __invoke($url, $query = '&', $limitFutureMonth = true)
	{
	    // Lấy tháng và năm hiện tại
	    $currentMonth = date("n");
	    $currentYear = date("Y");

	    // Mặc định lấy tháng và năm hiện tại
	    $month = $currentMonth;
	    $year = $currentYear;

	    // Kiểm tra tham số `month` trong URL
	    if (isset($_GET['month']) && preg_match('/^(0[1-9]|1[0-2])-\d{4}$/', $_GET['month'])) {
	        $currentMonthYear = explode('-', $_GET['month']);
	        $month = (int)$currentMonthYear[0];
	        $year = (int)$currentMonthYear[1];
	    }

	    // Kiểm tra giới hạn năm hợp lệ (tuỳ chỉnh theo nhu cầu)
	    if ($year < 1000 || $year > 9999) {
	        $month = $currentMonth;
	        $year = $currentYear;
	    }

	    // Tính toán tháng trước và tháng sau
	    $prevMonth = $month - 1;
	    $nextMonth = $month + 1;
	    $prevYear = $year;
	    $nextYear = $year;

	    // Xử lý trường hợp vượt qua ranh giới năm
	    if ($prevMonth < 1) {
	        $prevMonth = 12;
	        $prevYear--;
	    }
	    if ($nextMonth > 12) {
	        $nextMonth = 1;
	        $nextYear++;
	    }

	    // Kiểm tra nếu có giới hạn, không cho phép vượt quá tháng hiện tại
	    $disableNext = false;
	    if ($limitFutureMonth && ($nextYear > $currentYear || ($nextYear == $currentYear && $nextMonth > $currentMonth))) {
	        $disableNext = true;
	    }

	    // Định dạng lại tháng cho URL (đảm bảo 2 chữ số)
	    $prevMonthFormatted = str_pad($prevMonth, 2, "0", STR_PAD_LEFT);
	    $nextMonthFormatted = str_pad($nextMonth, 2, "0", STR_PAD_LEFT);

	    // Xây dựng HTML phân trang
	    $htmlPagination = '<div class="salary_month">
	        <h3>Tháng ' . $month . ', ' . $year . '</h3>
	        <div class="salary_arrow">
	            <a class="arrow" href="' . $url . $query . 'month=' . $prevMonthFormatted . '-' . $prevYear . '">
	                <i class="fa fa-angle-left" aria-hidden="true"></i>
	            </a>';

	    // Kiểm tra có cho phép bấm "Next" hay không
	    if (!$disableNext) {
	        $htmlPagination .= '<a class="arrow" href="' . $url . $query . 'month=' . $nextMonthFormatted . '-' . $nextYear . '">
	                <i class="fa fa-angle-right" aria-hidden="true"></i>
	            </a>';
	    } else {
	        $htmlPagination .= '<span class="arrow disabled">
	                <i class="fa fa-angle-right" aria-hidden="true"></i>
	            </span>';
	    }

	    $htmlPagination .= '</div></div>';

	    return $htmlPagination;
	}
}