﻿/**
 * @license Copyright (c) 2003-2023, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
CKEDITOR.editorConfig = function( config ) {

    // %REMOVE_START%
    // The configuration options below are needed when running CKEditor from source files.
    config.plugins = 'dialogui,dialog,about,a11yhelp,dialogadvtab,basicstyles,bidi,blockquote,notification,button,toolbar,clipboard,panelbutton,panel,floatpanel,colorbutton,colordialog,xml,ajax,templates,menu,contextmenu,div,resize,elementspath,enterkey,entities,popup,filetools,filebrowser,find,floatingspace,listblock,richcombo,font,fakeobjects,forms,format,horizontalrule,htmlwriter,iframe,wysiwygarea,image,indent,indentblock,indentlist,smiley,justify,menubutton,language,link,list,liststyle,magicline,maximize,newpage,pagebreak,pastetext,pastetools,pastefromword,preview,print,removeformat,save,selectall,showblocks,showborders,sourcearea,specialchar,scayt,stylescombo,tab,table,tabletools,undo,flash';
    config.skin = 'moono';
    // %REMOVE_END%

    // Define changes to default configuration here. For example:
    // config.language = 'fr';
    // config.uiColor = '#AADC6E';
}; */

/**

 * @license Copyright (c) 2003-2015, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function (config) {
    // Define changes to default configuration here. For example:

    var pathname = window.location.pathname;
    pathname = pathname.split('/');
    $path = (pathname[1] != 'admin') ? '/' + pathname[1] + '/' + pathname[2] : '';
    config.language = BE_LANG;
    config.toolbarCanCollapse = true;
    config.entities_latin = false;
    config.font_defaultLabel = 'Arial';
    config.fontSize_defaultLabel = '14px';
    config.timestamp = (new Date()).getTime();
    config.plugins = 'dialogui,dialog,about,a11yhelp,dialogadvtab,basicstyles,bidi,blockquote,notification,button,toolbar,clipboard,panelbutton,panel,floatpanel,colorbutton,colordialog,xml,ajax,templates,menu,contextmenu,div,resize,elementspath,enterkey,entities,popup,filetools,filebrowser,find,floatingspace,listblock,richcombo,font,fakeobjects,forms,format,horizontalrule,htmlwriter,iframe,wysiwygarea,image,indent,indentblock,indentlist,smiley,justify,menubutton,language,link,list,liststyle,magicline,maximize,newpage,pagebreak,pastetext,pastetools,pastefromword,preview,print,removeformat,save,selectall,showblocks,showborders,sourcearea,specialchar,scayt,stylescombo,tab,table,tabletools,undo';
    config.extraPlugins = 'richcombo,placeholder_select,youtube,simplebutton,pastefromword';

    config.allowedContent = true;
    config.pasteFromWord_inlineImages = false;

    var fontSizeSizes = '';
    for (var size = 10; size <= 72; size++) {
        fontSizeSizes += size + '/' + size + 'px;';
    }
    config.fontSize_sizes = fontSizeSizes;

    config.toolbar = [
        { name: 'document', groups: ['mode', 'document', 'doctools'], items: ['Source', '-', 'Save', 'NewPage', 'Preview', 'Print', '-', 'Templates', 'Table'] },
        { name: 'clipboard', groups: ['clipboard', 'undo'], items: ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo'] },
        { name: 'editing', groups: ['find', 'selection', 'spellchecker'], items: ['Find', 'Replace', '-', 'SelectAll', '-', 'Scayt'] },
        { name: 'forms', items: ['Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 'Button', 'ImageButton', 'HiddenField'] },
        '/',
        { name: 'basicstyles', groups: ['basicstyles', 'cleanup'], items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'RemoveFormat'] },
        { name: 'paragraph', groups: ['list', 'indent', 'blocks', 'align', 'bidi'], items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl', 'Language'] },
        { name: 'links', items: ['Link', 'Unlink', 'Anchor'] },
        { name: 'insert', items: ['Image', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar', 'PageBreak', 'Iframe', 'Youtube'] },
        '/',
        { name: 'styles', items: ['Styles', 'Format', 'Font', 'FontSize'] },
        { name: 'colors', items: ['TextColor', 'BGColor'] },
        { name: 'tools', items: ['Maximize', 'ShowBlocks'] },
        { name: 'other', items: ['simplebutton'] }
    ];

    // config.filebrowserFlashBrowseUrl = $path + '/template/backend/plugins/ckfinder/ckfinder.html?type=Flash';
    // config.filebrowserFlashUploadUrl = $path + '/template/backend/plugins/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash';

    //      ┌────────────────────────────────────────────────────────────────────┐
    //      │  Chý ý khi sử dụng chức năng Duyệt ảnh của Ckeditor (Ckfinder):    │
    //      │  Cần vào link: https://charmevietnam.com/Common/CkfinderKey        │
    //      │  Hoặc tìm từ khóa "Ckfinder keygen" vào link có chức năng Generate │
    //      │  để tạo key mới cho Ckfinder để dùng full chức năng                │
    //      │  Tạo và thay key mới tại đường dẫn:                                │
    //      │  ../template/backend/plugins/ckfinder/config.php (tìm licenseKey)  │
    //      │  Cấu hình xong, bật 2 dòng dưới để có chức năng Duyệt ảnh máy chủ  │
    //      └────────────────────────────────────────────────────────────────────┘

    // config.filebrowserBrowseUrl = $path + '/template/backend/plugins/ckfinder/ckfinder.html';
    // config.filebrowserImageBrowseUrl = $path + '/template/backend/plugins/ckfinder/ckfinder.html?type=Images';
    config.filebrowserUploadUrl = $path + '/template/backend/plugins/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files';
    config.filebrowserImageUploadUrl = $path + '/template/backend/plugins/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images';
};

CKEDITOR.on('instanceReady', function (ev) {
    ev.editor.on('paste', function (event) {
        var data = event.data.dataValue;

        // Tạo một phân tích cú pháp DOM từ nội dung dán
        var parser = new DOMParser();
        var doc = parser.parseFromString(data, 'text/html');

        // Tìm tất cả thẻ img với src dưới dạng base64
        var imgs = doc.querySelectorAll('img[src^="data:image/"]');

        /* if (imgs.length > 0) {
            // Thông báo đến người dùng nội dung có chứa ảnh vừa dán
            alert('Trình soạn thảo không cho phép dán ảnh có định dạng Base64 (do paste từ file word hoặc từ website khác).\nVui lòng upload ảnh trực tiếp lên editor!');
        } */

        // remove ảnh base64 và thay thế bằng ảnh noimage
        for (var i = 0; i < imgs.length; i++) {
            var img = imgs[i];
            img.setAttribute('src', $path + '/template/backend/plugins/ckeditor/plugins/image/images/noimage.png');
            img.removeAttribute('data-cke-saved-src');
        }

        // Cập nhật nội dung dán với nội dung đã chỉnh sửa
        event.data.dataValue = doc.body.innerHTML;
    });
});