function setOff(obj, classId, teacherId, date) {
    var button = $(obj);
    var isOff = button.text() == "OFF";
    var columnIndex = button.parent().index() + 1;

    button.text(isOff ? "HỦY" : "OFF");

    if (isOff) {
        button.parent().addClass('off');
    } else {
        button.parent().removeClass('off');
    }

    $("#attendance-data tr").each(function() {
        var cell = $(this).find("td:nth-child("+ columnIndex +")");
        var studentId = $(this).data("id");
        var absentCount = $("#student-info tr[data-id='" + studentId + "'] .absent-count");
        var previousValue = cell.find('span').data('name');

        if (isOff) {
            // Nếu trước đó là "A", trừ đi 1 lần vắng
            if (previousValue === "KP" || previousValue === "CP") {
                absentCount.text(Math.max(0, parseInt(absentCount.text()) - 1));
            }
            cell.addClass("off").find('span').text("OFF");
            $('#total-absence-row').find("td:nth-child("+ columnIndex +")").addClass("off");
        } else {
            var namePrev = cell.find('span').data('name') ? cell.find('span').data('name') : '-';
            cell.removeClass("off").find('span').text(namePrev);
            $('#total-absence-row').find("td:nth-child("+ columnIndex +")").removeClass("off");

            // Khi hủy OFF, trả về trạng thái "-"
            var totalAbsentTr = $(this).find("td").filter(function () {
                return $(this).not('.off').find('span').data('name') === "KP" || $(this).not('.off').find('span').data('name') === "CP";
            });
            absentCount.text(totalAbsentTr.length);
        }
    });

    // Cập nhật lại tổng số vắng của cột OFF
    var totalColumn = $("#total-absence-row td:nth-child(" + columnIndex + ")");
    var totalAbsent = $("#attendance-data tr td:nth-child(" + columnIndex + ")").filter(function () {
        return $(this).not('.off').find('span').data('name') === "KP" || $(this).not('.off').find('span').data('name') === "CP";
    }).length;

    totalColumn.find("span").text(totalAbsent);

    if(classId && teacherId && date) {
        $.ajax({
            url: "off-92.html",
            type: "POST",
            data: {
                class_id: classId,
                teacher_id: teacherId,
                off_date: date,
                type: isOff ? 'add' : 'del'
            }
        }).done(function(data){
            $('#off-count').text($.parseJSON(data).offCount);
        });
    }
}

//LOGIC XỬ LÝ OFF CỦA GIÁO VIÊN
$(document).ready(function() {
    // Xử lý drag
    let isDragging = false;
    let startX, scrollLeft;

    $(".scrollable-table:not(.not)").on("mousedown", function(event) {
        isDragging = true;
        startX = event.pageX;
        scrollLeft = this.scrollLeft;
        $(this).addClass("dragging"); // Thêm class khi kéo
    });

    $(document).on("mousemove", function(event) {
        if (!isDragging) return;
        event.preventDefault();
        let walk = (event.pageX - startX) * 1.5; // Điều chỉnh độ nhạy kéo
        $(".scrollable-table:not(.not)").scrollLeft(scrollLeft - walk);
    });

    $(document).on("mouseup mouseleave", function() {
        isDragging = false;
        $(".scrollable-table:not(.not)").removeClass("dragging"); // Xóa class khi thả chuột
    });

    // Ngăn chọn văn bản khi kéo
    $(".scrollable-table:not(.not)").on("dragstart", function(event) {
        event.preventDefault();
    });

    function scrollToTarget() {
        let $container = $(".scrollable-table:not(.not)");
        let $target = $container.find(".active-day"); // Ưu tiên .active-day

        if (!$target.length) {
            $target = $container.find(".done").last(); // Nếu không có .active-day thì chọn .done cuối cùng
        }

        if ($target.length) {
            let containerOffset = $container.offset().left;
            let itemOffset = $target.offset().left;
            let scrollLeft = $container.scrollLeft();

            // Cuộn ngang đến phần tử được chọn
            $container.animate({
                scrollLeft: scrollLeft + (itemOffset - containerOffset) - 250
            }, 400); // 400ms là tốc độ cuộn
        }
    }

    // Gọi hàm khi trang tải xong
    scrollToTarget();

    $('body').on('click','.attendance_table [ht-target="#modalViewStudent"]', function(){
        var id = $(this).closest('tr').data('id');
        if(id) {
            $.ajax({
                url: "view-student-87.html",
                type: "POST",
                data: { student_id: id },
            }).done(function(data){
                $('#modalViewStudent .c_body').html(data);
                $('#btnShowViewStudent').click();
            });
        }
    });

    $('body').on('click', '.scrollable-table .att-cell.active-columns:not(.disabled):not(.off)', function(){
        $(this).find('.dropdown').addClass('is-active');
        $(this).closest('tr').siblings().find('.dropdown').removeClass('is-active');
    });

    $('body').on('click', '.scrollable-table .off', function(){
        $(this).closest('tr').siblings().find('.dropdown').removeClass('is-active');
    });

    $(document).click(function(e) {
        if (!$(e.target).closest(".att-cell").length) {
            $(".dropdown").removeClass('is-active');
        }
    });
});